---
title: Rule init-declarations
layout: doc
---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->
# Enforce/Disallow Variable Initializations (init-declarations)

In JavaScript, variables can be assigned during declaration, or at any point afterwards using an assignment statement. For example, in the following code, `foo` is initialized during declaration, while `bar` is initialized later.

```js
var foo = 1;
var bar;

if (foo) {
    bar = 1;
} else {
    bar = 2;
}
```

## Rule Details

This rule is aimed at enforcing or eliminating variable initializations during declaration. For example, in the following code, `foo` is initialized during declaration, while `bar` is not.

```js
var foo = 1;
var bar;

bar = 2;
```

This rule aims to bring consistency to variable initializations and declarations.

### Options

This rule is configured by passing in the string `"always"` (the default) to enforce initialization at declaration, or `"never"` to disallow initialization during declaration. This rule applies to `var`, `let`, and `const` variables, however `"never"` is ignored for `const` variables, as unassigned `const`s generate a parse error.

You can configure the rule as follows:

```javascript
{
    // (default) All variables must be initialized at declaration
    "init-declarations": [2, "always"],

    // Variables must not be initialized at declaration
    "init-declarations": [2, "never"]
}
```

When configured with `"always"` (the default), the following patterns are considered warnings:

```js
function foo() {
    var bar;
    let baz;
}
```

The following patterns are not considered warnings with `"always"`.

```js
function foo() {
    var bar = 1;
    let baz = 2;
    const qux = 3;
}
```

When configured with `"never"`, the following patterns are considered warnings.

```js
function foo() {
    var bar = 1;
    let baz = 2;
}
```

The following patterns are not considered warnings with `"never"`. Note that `const` variable initializations are ignored with `"never"`.

```js
function foo() {
    var bar;
    let baz;
    const buzz = 1;
}
```

### When Not To Use It

When you are indifferent as to how your variables are initialized.

## Version

This rule was introduced in ESLint 1.0.0-rc-1.

## Resources

* [Rule source](https://github.com/eslint/eslint/tree/master/lib/rules/init-declarations.js)
* [Documentation source](https://github.com/eslint/eslint/tree/master/docs/rules/init-declarations.md)
