---
title: Integrations
layout: doc
---

# Integrations

## Editors

* Sublime Text 3:
    * [SublimeLinter-eslint](https://github.com/roadhump/SublimeLinter-eslint)
    * [Build Next](https://github.com/albertosantini/sublimetext-buildnext)
* [Vim](https://github.com/scrooloose/syntastic/tree/master/syntax_checkers/javascript)
* Emacs: [Flycheck](http://flycheck.readthedocs.org/en/latest/) supports ESLint in recent versions.
* Eclipse Orion: ESLint is the [default linter](http://dev.eclipse.org/mhonarc/lists/orion-dev/msg02718.html)
* [TextMate 2](https://github.com/natesilva/javascript-eslint.tmbundle)
* Atom: [linter-eslint](https://atom.io/packages/linter-eslint)
* [IntelliJ IDEA, RubyMine, WebStorm, PhpStorm, PyCharm, AppCode, Android Studio, 0xDBE](http://plugins.jetbrains.com/plugin/7494)


## Build Systems

* **Grunt:**
    * [grunt-eslint](https://npmjs.org/package/grunt-eslint)
* **Gulp:**
    * [gulp-eslint](https://npmjs.org/package/gulp-eslint)
* **Mimosa:**
    * [mimosa-eslint](https://npmjs.org/package/mimosa-eslint)
* **Broccoli:**
    * [broccoli-eslint](https://www.npmjs.org/package/broccoli-eslint)
* **Webpack:**
    * [eslint-loader](https://www.npmjs.org/package/eslint-loader)
* **Ember-cli**
    * [ember-cli-eslint](https://www.npmjs.com/package/ember-cli-eslint)
* **Sails.js**
    * [sails-hook-eslint](https://www.npmjs.com/package/sails-hook-eslint)

## Command Line Tools

* [Eslint Watch](https://www.npmjs.com/package/eslint-watch)
* [Code Climate CLI](https://github.com/codeclimate/codeclimate)

## Source Control

* [Git Precommit Hook](https://coderwall.com/p/zq8jlq)
* [overcommit Git hook manager](https://github.com/brigade/overcommit)

## Testing

 * **Mocha.js**
    * [mocha-eslint](https://www.npmjs.com/package/mocha-eslint)

## External ESLint rules

* [AngularJS](https://github.com/Gillespie59/eslint-plugin-angular)
* [BackboneJS](https://github.com/ilyavolodin/eslint-plugin-backbone)
* [Jasmine](https://github.com/tlvince/eslint-plugin-jasmine)
* [React](https://github.com/yannickcr/eslint-plugin-react)

… and many more published on npm with the [eslintplugin](https://www.npmjs.com/browse/keyword/eslintplugin) keyword.
