---
title: Rule radix
layout: doc
---
<!-- Note: No pull requests accepted for this file. See README.md in the root directory for details. -->
# Require Radix Parameter (radix)

When using the `parseInt()` function it is common to omit the second argument, the radix, and let the function try to determine from the first argument what type of number it is. By default, `parseInt()` will autodetect decimal and hexadecimal (via `0x` prefix). Prior to ECMAScript 5, `parseInt()` also autodetected octal literals, which caused problems because many developers assumed a leading `0` would be ignored.

This confusion led to the suggestion that you always use the radix parameter to `parseInt()` to eliminate unintended consequences. So instead of doing this:

```js
var num = parseInt("071");      // 57
```

Do this:

```js
var num = parseInt("071", 10);  // 71
```

ECMAScript 5 changed the behavior of `parseInt()` so that it no longer autodetects octal literals and instead treats them as decimal literals. However, the differences between hexadecimal and decimal interpretation of the first parameter causes many developers to continue using the radix parameter to ensure the string is interpreted in the intended way.

## Rule Details

This rule is aimed at preventing the unintended conversion of a string to a number of a different base than intended.

The following patterns are considered warnings:

```js
var num = parseInt("071");

var num = parseInt(someValue);
```

The following patterns are not considered warnings:

```js
var num = parseInt("071", 10);

var num = parseFloat(someValue);
```

## When Not To Use It

If you are certain of the first argument's format, then the second argument is unnecessary and you can safely turn this rule off.

## Further Reading

* [parseInt and radix](http://davidwalsh.name/parseint-radix)
* [Missing radix parameter](http://jslinterrors.com/missing-radix-parameter/)

## Version

This rule was introduced in ESLint 0.0.7.

## Resources

* [Rule source](https://github.com/eslint/eslint/tree/master/lib/rules/radix.js)
* [Documentation source](https://github.com/eslint/eslint/tree/master/docs/rules/radix.md)
