---
layout: post
title: ESLint v8.6.0 released
teaser: "We just pushed ESLint v8.6.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-minor.png
authors:
  - btmills
categories:
  - Release Notes
tags:
  - Release
---

## Highlights

ESLint v8.6.0 allows rule lists or descriptions in [`eslint-disable-next-line` comments](https://eslint.org/docs/user-guide/configuring/rules#using-configuration-comments-1) to wrap lines:

```js
/* eslint-disable-next-line no-console --
 * Here's a very long description about why this configuration is necessary
 * along with some additional information.
 */
console.log('hello');
```

## Features


* [`6802a54`](https://github.com/eslint/eslint/commit/6802a54837ea008bef4d5ae11522941693ba5ef6) feat: handle logical assignment in [no-self-assign](/docs/rules/no-self-assign) ([#14152](https://github.com/eslint/eslint/issues/14152)) (Zzzen)
* [`3b38018`](https://github.com/eslint/eslint/commit/3b38018ef5cb004ad5bc011de726bd2df2eb2f3f) feat: allow to define `eslint-disable-next-line` in multiple lines ([#15436](https://github.com/eslint/eslint/issues/15436)) (Nitin Kumar)
* [`9d6fe5a`](https://github.com/eslint/eslint/commit/9d6fe5a6b65f397bafc5eb0a995e96717cdc9b53) feat: false negative with `onlyDeclarations` + `properties` in [id-match](/docs/rules/id-match) ([#15431](https://github.com/eslint/eslint/issues/15431)) (Nitin Kumar)








## Documentation


* [`6c4dee2`](https://github.com/eslint/eslint/commit/6c4dee2e87dac8d0751ce2426ded651ed0986112) docs: Document homedir is a configuration root ([#15469](https://github.com/eslint/eslint/issues/15469)) (Bas Bosman)
* [`51c37b1`](https://github.com/eslint/eslint/commit/51c37b118aed9c0d7a0efd40c491efca04c82ef9) docs: consistency changes ([#15404](https://github.com/eslint/eslint/issues/15404)) (Bas Bosman)
* [`775d181`](https://github.com/eslint/eslint/commit/775d18138244a28ebe1cb92849cd0f4e8cd27672) docs: Mention character classes in [no-useless-escape](/docs/rules/no-useless-escape) ([#15421](https://github.com/eslint/eslint/issues/15421)) (Sebastian Simon)








## Chores


* [`3a384fc`](https://github.com/eslint/eslint/commit/3a384fc287cebb7be5fe5ed95497d578437a503a) chore: Upgrade espree to 9.3.0 ([#15473](https://github.com/eslint/eslint/issues/15473)) (Brandon Mills)
* [`1443cc2`](https://github.com/eslint/eslint/commit/1443cc2fc8785157936b864258924fe9bcd23210) chore: Update blogpost.md.ejs ([#15468](https://github.com/eslint/eslint/issues/15468)) (Nicholas C. Zakas)
* [`28e907a`](https://github.com/eslint/eslint/commit/28e907a4ca05a026d156f814f4118f8fe713e99d) refactor: remove unused parameter in `linter.js` ([#15451](https://github.com/eslint/eslint/issues/15451)) (Milos Djermanovic)
* [`eaa08d3`](https://github.com/eslint/eslint/commit/eaa08d3055b195bce59cc96bb63ac29038cd7c7d) test: add tests for `allowReserved` parser option with flat config ([#15450](https://github.com/eslint/eslint/issues/15450)) (Milos Djermanovic)
