---
layout: post
title: ESLint v8.4.0 released
teaser: "We just pushed ESLint v8.4.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
authors:
  - mdjermanovic
categories:
  - Release Notes
tags:
  - release
  - minor
---

## Highlights

### New Parser Option

The default parser has a new option `allowReserved` (boolean, default `false`). When set to `true`, reserved words can be used as identifiers.

This option can only be used with `"ecmaVersion": 3`.

```json
{
    "parserOptions": {
        "ecmaVersion": 3,
        "allowReserved": true
    }
}
```

### New Features for Custom Formatters

This release adds two new features for [custom formatters](/docs/developer-guide/working-with-custom-formatters).

#### Async Formatters

Formatters are now allowed to return `Promise<string>`. That is, a formatter can be an async function.

```js
//------ my-formatter.js ------
module.exports = async function(results, context) {
    const something = await getSomethingAsync();
    // ...
    return formattedResults;
};
```

#### `context.cwd`

The `context` argument has a new property `cwd` (string, absolute path). It represents the working directory used for linting. This value comes from the `cwd` constructor option of the [ESLint](/docs/developer-guide/nodejs-api#-new-eslintoptions) class, and formatters can use it to output relative paths more reliably than by using `process.cwd()`.

```js
//------ my-formatter.js ------
module.exports = function(results, context) {
    const cwd = context.cwd;
    // ...
};
```






## Features


* [`5771663`](https://github.com/eslint/eslint/commit/5771663e8d3e86fec9454ee0af439c6989506bf3) feat: add `allowReserved` parser option ([#15387](https://github.com/eslint/eslint/issues/15387)) (Milos Djermanovic)
* [`32ac37a`](https://github.com/eslint/eslint/commit/32ac37a76b2e009a8f106229bc7732671d358189) feat: Flat config support in Linter (refs [#13481](https://github.com/eslint/eslint/issues/13481)) ([#15185](https://github.com/eslint/eslint/issues/15185)) (Nicholas C. Zakas)
* [`d041f34`](https://github.com/eslint/eslint/commit/d041f345cdf0306f15faa2f305fe1d21ef137eb1) feat: Treat Class/New Expressions as truthy in [no-constant-condition](/docs/rules/no-constant-condition) ([#15326](https://github.com/eslint/eslint/issues/15326)) (Jordan Eldredge)
* [`8f44cf5`](https://github.com/eslint/eslint/commit/8f44cf505765b663e371412ab57f0f1dbbe78513) feat: report only lines that exceed the limit in [max-lines-per-function](/docs/rules/max-lines-per-function) ([#15140](https://github.com/eslint/eslint/issues/15140)) (Sneh Khatri)
* [`808ad35`](https://github.com/eslint/eslint/commit/808ad35f204c838cd5eb8d766807dc43692f42f9) feat: pass cwd to formatters (refs [eslint/rfcs#57](https://github.com/eslint/rfcs/issues/57)) ([#13392](https://github.com/eslint/eslint/issues/13392)) (Toru Nagashima)
* [`f1b7499`](https://github.com/eslint/eslint/commit/f1b7499a5162d3be918328ce496eb80692353a5a) feat: support async formatters ([#15243](https://github.com/eslint/eslint/issues/15243)) (MO)






## Bug Fixes


* [`4940cc5`](https://github.com/eslint/eslint/commit/4940cc5c4903a691fe51d409137dd573c4c7706e) fix: mark --rulesdir option as deprecated in CLI docs ([#15310](https://github.com/eslint/eslint/issues/15310)) (Kevin Partington)




## Documentation


* [`54deec5`](https://github.com/eslint/eslint/commit/54deec56bc25d516becaf767769ee7543f491d62) docs: update integrations.md ([#15380](https://github.com/eslint/eslint/issues/15380)) (Vlad Sholokhov)
* [`fa0423a`](https://github.com/eslint/eslint/commit/fa0423af7f8453f6c97b915b3b026f258b76a600) docs: fix typo in PR template ([#15365](https://github.com/eslint/eslint/issues/15365)) (Nitin Kumar)
* [`e233920`](https://github.com/eslint/eslint/commit/e233920857e282ba22116ad5f1dcc6dfabc8ef5b) docs: enable a few more markdownlint rules and fix violations ([#15368](https://github.com/eslint/eslint/issues/15368)) (Bryan Mishkin)
* [`632176d`](https://github.com/eslint/eslint/commit/632176dc43180ea4e7f99da429fee3ee3814a04d) docs: Dedent needlessly indented example in [getter-return](/docs/rules/getter-return) docs ([#15363](https://github.com/eslint/eslint/issues/15363)) (Jordan Eldredge)
* [`4497e88`](https://github.com/eslint/eslint/commit/4497e880248c24dc19eea8a5466555b847c0c7eb) docs: Update release notes blog post template ([#15285](https://github.com/eslint/eslint/issues/15285)) (Nicholas C. Zakas)








## Chores


* [`efede90`](https://github.com/eslint/eslint/commit/efede90d59edc5cca9cd739df7e98f1ff00ca37d) chore: upgrade @eslint/eslintrc@1.0.5 ([#15389](https://github.com/eslint/eslint/issues/15389)) (Milos Djermanovic)
* [`0b8c846`](https://github.com/eslint/eslint/commit/0b8c846c77234125fbb211980bc1e62dc8791513) chore: fix update-readme to avoid multiple consecutive blank lines ([#15375](https://github.com/eslint/eslint/issues/15375)) (Milos Djermanovic)
* [`94b2a8b`](https://github.com/eslint/eslint/commit/94b2a8b3d1f7d139dd6b06216a64727b7d5f009b) chore: Use default Chromium binary in M1 Mac tests ([#15371](https://github.com/eslint/eslint/issues/15371)) (Brandon Mills)
* [`ba58d94`](https://github.com/eslint/eslint/commit/ba58d94cb51d4d2644c024446d5750eaf4853129) ci: use node `v16` for Verify Files ([#15364](https://github.com/eslint/eslint/issues/15364)) (Nitin Kumar)
* [`1e32ee5`](https://github.com/eslint/eslint/commit/1e32ee591e978188b121604d0af9cbc04a50a3b5) chore: add jsdoc type annotation to rules ([#15291](https://github.com/eslint/eslint/issues/15291)) (Bryan Mishkin)


