---
layout: post
title: ESLint v8.3.0 released
teaser: "We just pushed ESLint v8.3.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

This release supports ES2022 class static blocks in rules, the default parser, and scope analysis.

```js
class C {
    static x = ...;
    static y;
    static z;
    static {
        try {
            const obj = doSomethingWith(this.x);
            this.y = obj.y;
            this.z = obj.z;
        }
        catch {
            this.y = ...;
            this.z = ...;
        }
    }
}
```

It also supports `#x in obj`, officially known as ergonomic brand checks for private fields.

## Features


* [`60b0a29`](https://github.com/eslint/eslint/commit/60b0a292efd1b9cdc318b1e88a0cb7bbf14860b1) feat: add `allowProperties` option to [require-atomic-updates](/docs/rules/require-atomic-updates) ([#15238](https://github.com/eslint/eslint/issues/15238)) (Milos Djermanovic)
* [`79278a1`](https://github.com/eslint/eslint/commit/79278a14f1c8747bff8f5cb2100d8776f9d517f2) feat: update [no-use-before-define](/docs/rules/no-use-before-define) for class static blocks ([#15312](https://github.com/eslint/eslint/issues/15312)) (Milos Djermanovic)
* [`ddd01dc`](https://github.com/eslint/eslint/commit/ddd01dcd5f14c6ddea5decca46db2f379ec35aeb) feat: update [no-redeclare](/docs/rules/no-redeclare) for class static blocks ([#15313](https://github.com/eslint/eslint/issues/15313)) (Milos Djermanovic)
* [`de69cec`](https://github.com/eslint/eslint/commit/de69cec834411aeb276a525c11dc10f628df2f51) feat: update [no-inner-declarations](/docs/rules/no-inner-declarations) for class static blocks ([#15290](https://github.com/eslint/eslint/issues/15290)) (Milos Djermanovic)
* [`e2fe7ef`](https://github.com/eslint/eslint/commit/e2fe7ef7ea0458de56bed4e4c3d5f71aaebd3f28) feat: support for private-in syntax (fixes [#14811](https://github.com/eslint/eslint/issues/14811)) ([#15060](https://github.com/eslint/eslint/issues/15060)) (Yosuke Ota)
* [`34bc8d7`](https://github.com/eslint/eslint/commit/34bc8d7cb42d696ec56e0a3c780aa5b042285d6b) feat: Update espree and eslint-scope ([#15338](https://github.com/eslint/eslint/issues/15338)) (Brandon Mills)
* [`b171cd7`](https://github.com/eslint/eslint/commit/b171cd7ec839a0481a74a613b0d48a193f16bb6b) feat: update [max-depth](/docs/rules/max-depth) for class static blocks ([#15316](https://github.com/eslint/eslint/issues/15316)) (Milos Djermanovic)
* [`6487df3`](https://github.com/eslint/eslint/commit/6487df371496dd15272e2097e4d2c932532c8727) feat: update [padded-blocks](/docs/rules/padded-blocks) for class static blocks ([#15333](https://github.com/eslint/eslint/issues/15333)) (Milos Djermanovic)
* [`194f36d`](https://github.com/eslint/eslint/commit/194f36d9c009a72ec72fa9592ea9e31f9f168a52) feat: update the [complexity](/docs/rules/complexity) rule for class static blocks ([#15328](https://github.com/eslint/eslint/issues/15328)) (Milos Djermanovic)
* [`3530337`](https://github.com/eslint/eslint/commit/3530337e71327d8325d0de01e8e73952010b1a08) feat: update the [indent](/docs/rules/indent) rule for class static blocks ([#15324](https://github.com/eslint/eslint/issues/15324)) (Milos Djermanovic)
* [`f03cd14`](https://github.com/eslint/eslint/commit/f03cd146a97ed312d635ac7b53ba0f8d01aa8b47) feat: update [lines-around-comment](/docs/rules/lines-around-comment) for class static blocks ([#15323](https://github.com/eslint/eslint/issues/15323)) (Milos Djermanovic)
* [`5c64747`](https://github.com/eslint/eslint/commit/5c64747a8d7a4f896f0cbce67c7f5e7690837a9b) feat: update [brace-style](/docs/rules/brace-style) for class static blocks ([#15322](https://github.com/eslint/eslint/issues/15322)) (Milos Djermanovic)
* [`df2f1cc`](https://github.com/eslint/eslint/commit/df2f1cc81a559bbc9eee78a3a97315e2927af764) feat: update [max-statements](/docs/rules/max-statements) for class static blocks ([#15315](https://github.com/eslint/eslint/issues/15315)) (Milos Djermanovic)
* [`fd5a0b8`](https://github.com/eslint/eslint/commit/fd5a0b8506e4b6acd740ab966cc2c0e4ff6a4d15) feat: update [prefer-const](/docs/rules/prefer-const) for class static blocks ([#15325](https://github.com/eslint/eslint/issues/15325)) (Milos Djermanovic)
* [`b3669fd`](https://github.com/eslint/eslint/commit/b3669fde2316f136af3a16b58b0c44e8ec196cee) feat: code path analysis for class static blocks ([#15282](https://github.com/eslint/eslint/issues/15282)) (Milos Djermanovic)
* [`15c1397`](https://github.com/eslint/eslint/commit/15c1397f0063931f50f31af8d110a23c6d660000) feat: update eslint-scope for class static blocks ([#15321](https://github.com/eslint/eslint/issues/15321)) (Milos Djermanovic)
* [`1a1bb4b`](https://github.com/eslint/eslint/commit/1a1bb4b1ee87c1b33f2d86ef70b3d81e83377547) feat: update [one-var](/docs/rules/one-var) for class static blocks ([#15317](https://github.com/eslint/eslint/issues/15317)) (Milos Djermanovic)
* [`9b666e0`](https://github.com/eslint/eslint/commit/9b666e0682bacf44d2a5afa0023874b8b131b5f5) feat: update [padding-line-between-statements](/docs/rules/padding-line-between-statements) for class static blocks ([#15318](https://github.com/eslint/eslint/issues/15318)) (Milos Djermanovic)
* [`d3a267f`](https://github.com/eslint/eslint/commit/d3a267f5f39167e3ee8248ae6b9cae5034d0486f) feat: update [class-methods-use-this](/docs/rules/class-methods-use-this) for class static blocks ([#15298](https://github.com/eslint/eslint/issues/15298)) (Milos Djermanovic)
* [`cdaa541`](https://github.com/eslint/eslint/commit/cdaa54130aca7a9c8dfd76c613d0718b048401b2) feat: update [no-lone-blocks](/docs/rules/no-lone-blocks) for class static blocks ([#15295](https://github.com/eslint/eslint/issues/15295)) (Milos Djermanovic)
* [`8611538`](https://github.com/eslint/eslint/commit/8611538b47e325c6d6b115bf3d901a26e9ac29f8) feat: update [block-spacing](/docs/rules/block-spacing) for class static blocks ([#15297](https://github.com/eslint/eslint/issues/15297)) (Milos Djermanovic)
* [`7b56844`](https://github.com/eslint/eslint/commit/7b56844ece544e501f0173f6427038c9c5e0534f) feat: update [keyword-spacing](/docs/rules/keyword-spacing) for class static blocks ([#15289](https://github.com/eslint/eslint/issues/15289)) (Milos Djermanovic)
* [`ea18711`](https://github.com/eslint/eslint/commit/ea1871146402a77234393613fe56a416382c7f0f) feat: update [no-extra-semi](/docs/rules/no-extra-semi) for class static blocks ([#15287](https://github.com/eslint/eslint/issues/15287)) (Milos Djermanovic)
* [`0f0971f`](https://github.com/eslint/eslint/commit/0f0971ffc2ca6f4513eeffdf5cfa36826c8f4543) feat: update [semi](/docs/rules/semi) rule for class static blocks ([#15286](https://github.com/eslint/eslint/issues/15286)) (Milos Djermanovic)
* [`abe740c`](https://github.com/eslint/eslint/commit/abe740ce68dcc9e5413df93b3d80a2e3260f1c18) feat: add examples for [block-scoped-var](/docs/rules/block-scoped-var) with class static blocks ([#15302](https://github.com/eslint/eslint/issues/15302)) (Milos Djermanovic)
* [`0338fd2`](https://github.com/eslint/eslint/commit/0338fd201614247eeb21e68a26e4b4c8a74f71b0) feat: Normalize ecmaVersion to eslint-scope when using custom parser ([#15268](https://github.com/eslint/eslint/issues/15268)) (Yosuke Ota)






## Bug Fixes


* [`8aa7645`](https://github.com/eslint/eslint/commit/8aa764524cf74f0b70d184c7957dbbb5f36a5ac7) fix: update [vars-on-top](/docs/rules/vars-on-top) for class static blocks ([#15306](https://github.com/eslint/eslint/issues/15306)) (Milos Djermanovic)
* [`479a4cb`](https://github.com/eslint/eslint/commit/479a4cbc70f4032d4accd48e4471629e8635d677) fix: update [semi-style](/docs/rules/semi-style) for class static blocks ([#15309](https://github.com/eslint/eslint/issues/15309)) (Milos Djermanovic)
* [`6d1c666`](https://github.com/eslint/eslint/commit/6d1c666d318cc9e1860e1e2c72fbfa4bdd4a2c4b) fix: update [no-invalid-this](/docs/rules/no-invalid-this) and [no-eval](/docs/rules/no-eval) for class static blocks ([#15300](https://github.com/eslint/eslint/issues/15300)) (Milos Djermanovic)




## Documentation


* [`6b85426`](https://github.com/eslint/eslint/commit/6b85426c33ba7ac0206cccef39ccc875b773aeae) docs: Expand  `--debug` option description in the CLI documentation ([#15308](https://github.com/eslint/eslint/issues/15308)) (darkred)
* [`3ae5258`](https://github.com/eslint/eslint/commit/3ae52584296887e5fc5b0267346294bb920a00e6) docs: the [strict](/docs/rules/strict) rule does not apply to class static blocks ([#15314](https://github.com/eslint/eslint/issues/15314)) (Milos Djermanovic)
* [`9309841`](https://github.com/eslint/eslint/commit/9309841a6cfa85005e0bf79e20415bb9220ba46e) docs: Remove inconsistent colon in pull request docs ([#15303](https://github.com/eslint/eslint/issues/15303)) (Jordan Eldredge)
* [`da238cc`](https://github.com/eslint/eslint/commit/da238cc731a9b5ecd48280e0ea4ebd8a48ebeedc) docs: remove deprecation note from [lines-around-comment](/docs/rules/lines-around-comment) ([#15293](https://github.com/eslint/eslint/issues/15293)) (Milos Djermanovic)
* [`1055f16`](https://github.com/eslint/eslint/commit/1055f16fc6f78cc553f0b1462e8af44244c1f84b) docs: [no-unused-expressions](/docs/rules/no-unused-expressions) - class static blocks don't have directives ([#15283](https://github.com/eslint/eslint/issues/15283)) (Milos Djermanovic)
* [`4c55216`](https://github.com/eslint/eslint/commit/4c55216ba958fcc8c3dd29fcaa80298216a48303) docs: Add variables option to [no-use-before-define](/docs/rules/no-use-before-define) ([#15276](https://github.com/eslint/eslint/issues/15276)) (Mathias Rasmussen)








## Chores


* [`edd8d24`](https://github.com/eslint/eslint/commit/edd8d240db8878763dbb147fb6124412c0783a42) chore: upgrade eslint-visitor-keys for class static blocks ([#15277](https://github.com/eslint/eslint/issues/15277)) (Milos Djermanovic)
