---
layout: post
title: ESLint v8.0.0 released
teaser: "We just pushed ESLint v8.0.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-major.png
tags:
  - release
  - major
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

There are several breaking changes in v8.0.0. We've created a [migration guide](/docs/user-guide/migrating-to-8.0.0) to explain the breaking changes and describe how to upgrade. In addition, there are several new features:

* ESLint's default parser and all core rules now fully support the following ES2022 syntax:
    * Class public instance fields and private instance fields
    * Class public static fields and private static fields
    * Class private instance methods and accessors
    * Class private static methods and accessors
    * RegExp match indices
    * Top-level `await`
* Autofix can now remove unused disable directives when `--fix` and `--report-unused-disable-directives` are used together.
* The use of reserved words as identifiers in ES3 is now [disallowed](https://github.com/eslint/eslint/issues/15017). This change only affects users with default parser configured with `{ "ecmaVersion": 3 }` in parser options.
* The [`class-methods-use-this`](/docs/8.0.0/rules/class-methods-use-this) rule has a new `enforceForClassFields` option.
* The [`max-classes-per-file`](/docs/8.0.0/rules/max-classes-per-file) rule has a new `ignoreExpressions` option.
* The `meta.docs.category` property has been removed from all core rules.

## Breaking Changes


* [`7cf96cf`](https://github.com/eslint/eslint/commit/7cf96cf185f849d379b660072d660ec35ac5b46d) Breaking: Disallow reserved words in ES3 (fixes [#15017](https://github.com/eslint/eslint/issues/15017)) ([#15046](https://github.com/eslint/eslint/issues/15046)) (Milos Djermanovic)
* [`305e14a`](https://github.com/eslint/eslint/commit/305e14af8bd12afc01487abee5c9b0f3eaca989e) Breaking: remove meta.docs.category in core rules (fixes [#13398](https://github.com/eslint/eslint/issues/13398)) ([#14594](https://github.com/eslint/eslint/issues/14594)) (薛定谔的猫)
* [`24c9f2a`](https://github.com/eslint/eslint/commit/24c9f2ac57efcd699ca69695c82e51ce5742df7b) Breaking: Strict package exports (refs [#13654](https://github.com/eslint/eslint/issues/13654)) ([#14706](https://github.com/eslint/eslint/issues/14706)) (Nicholas C. Zakas)
* [`86d31a4`](https://github.com/eslint/eslint/commit/86d31a4951e3a39e359e284f5fe336ac477369fe) Breaking: disallow SourceCode#getComments() in RuleTester (refs [#14744](https://github.com/eslint/eslint/issues/14744)) ([#14769](https://github.com/eslint/eslint/issues/14769)) (Milos Djermanovic)
* [`1d2213d`](https://github.com/eslint/eslint/commit/1d2213deb69c5901c1950bbe648aa819e7e742ed) Breaking: Fixable disable directives (fixes [#11815](https://github.com/eslint/eslint/issues/11815)) ([#14617](https://github.com/eslint/eslint/issues/14617)) (Josh Goldberg)
* [`4a7aab7`](https://github.com/eslint/eslint/commit/4a7aab7d4323ff7027eebca709d4e95a9aaa80bc) Breaking: require `meta` for fixable rules (fixes [#13349](https://github.com/eslint/eslint/issues/13349)) ([#14634](https://github.com/eslint/eslint/issues/14634)) (Milos Djermanovic)
* [`d6a761f`](https://github.com/eslint/eslint/commit/d6a761f9b6582e9f71705161be827ca303ef183f) Breaking: Require `meta.hasSuggestions` for rules with suggestions ([#14573](https://github.com/eslint/eslint/issues/14573)) (Bryan Mishkin)
* [`6bd747b`](https://github.com/eslint/eslint/commit/6bd747b5b7731195224875b952a9ea61445a9938) Breaking: support new regex d flag (fixes [#14640](https://github.com/eslint/eslint/issues/14640)) ([#14653](https://github.com/eslint/eslint/issues/14653)) (Yosuke Ota)
* [`8b4f3ab`](https://github.com/eslint/eslint/commit/8b4f3abdb794feb3be31959bb44bfb0ef6318e8e) Breaking: fix [comma-dangle](/docs/rules/comma-dangle) schema (fixes [#13739](https://github.com/eslint/eslint/issues/13739)) ([#14030](https://github.com/eslint/eslint/issues/14030)) (Joakim Nilsson)
* [`b953a4e`](https://github.com/eslint/eslint/commit/b953a4ee12f120658a9ec27d1f8ca88dd3dfb599) Breaking: upgrade espree and support new class features (refs [#14343](https://github.com/eslint/eslint/issues/14343)) ([#14591](https://github.com/eslint/eslint/issues/14591)) (Toru Nagashima)
* [`8cce06c`](https://github.com/eslint/eslint/commit/8cce06cb39886902ce0d2e6882f46c3bf52fb955) Breaking: add some rules to eslint:recommended (refs [#14673](https://github.com/eslint/eslint/issues/14673)) ([#14691](https://github.com/eslint/eslint/issues/14691)) (薛定谔的猫)
* [`86bb63b`](https://github.com/eslint/eslint/commit/86bb63b370e0ff350e988a5fa228a8234abe800c) Breaking: Drop `codeframe` and `table` formatters ([#14316](https://github.com/eslint/eslint/issues/14316)) (Federico Brigante)
* [`f3cb320`](https://github.com/eslint/eslint/commit/f3cb3208c8952a6218d54658cfda85942b9fda42) Breaking: drop node v10/v13/v15 (fixes [#14023](https://github.com/eslint/eslint/issues/14023)) ([#14592](https://github.com/eslint/eslint/issues/14592)) (薛定谔的猫)






## Enhancements


* [`67c0074`](https://github.com/eslint/eslint/commit/67c0074fa843fab629f464ff875007a8ee33cc7f) Update: Suggest missing rule in flat config (fixes [#14027](https://github.com/eslint/eslint/issues/14027)) ([#15074](https://github.com/eslint/eslint/issues/15074)) (Nicholas C. Zakas)
* [`cf34e5c`](https://github.com/eslint/eslint/commit/cf34e5cf5ed5d09eb53c16cca06821c4e34b7b70) Update: [space-before-blocks](/docs/rules/space-before-blocks) ignore after switch colons (fixes [#15082](https://github.com/eslint/eslint/issues/15082)) ([#15093](https://github.com/eslint/eslint/issues/15093)) (Milos Djermanovic)
* [`14a4739`](https://github.com/eslint/eslint/commit/14a4739ab2233acef995a6dde233de05d067a0f3) Update: [`no-new-func`](/docs/rules/no-new-func) rule catching eval case of `MemberExpression` ([#14860](https://github.com/eslint/eslint/issues/14860)) (Mojtaba Samimi)
* [`0a1a850`](https://github.com/eslint/eslint/commit/0a1a850575ca75db017051abe5e931f0f9c8012b) Update: include `ruleId` in error logs (fixes [#15037](https://github.com/eslint/eslint/issues/15037)) ([#15053](https://github.com/eslint/eslint/issues/15053)) (Ari Perkkiö)
* [`88a3952`](https://github.com/eslint/eslint/commit/88a39520716bdd11f8647e47c57bd8bf91bc7148) Update: support class fields in the [`complexity`](/docs/rules/complexity) rule (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14957](https://github.com/eslint/eslint/issues/14957)) (Milos Djermanovic)
* [`6d1ccb6`](https://github.com/eslint/eslint/commit/6d1ccb676fedd1ceb4b1e44abf8133f116a5aecb) Update: enforceForClassFields in [class-methods-use-this](/docs/rules/class-methods-use-this) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#15018](https://github.com/eslint/eslint/issues/15018)) (YeonJuan)
* [`dd10937`](https://github.com/eslint/eslint/commit/dd109379f730a988a9e6c0102bcfe443ad0b4b94) Update: added ignoreExpressions option to [max-classes-per-file](/docs/rules/max-classes-per-file) ([#15000](https://github.com/eslint/eslint/issues/15000)) (Josh Goldberg)
* [`05ca24c`](https://github.com/eslint/eslint/commit/05ca24c57f90f91421b682dca3d7a45b7957fb77) Update: Code path analysis for class fields (fixes [#14343](https://github.com/eslint/eslint/issues/14343)) ([#14886](https://github.com/eslint/eslint/issues/14886)) (Nicholas C. Zakas)
* [`44c6fc8`](https://github.com/eslint/eslint/commit/44c6fc879de61e9513835d1d4d6ae978d9a43c51) Update: support class fields in [func-name-matching](/docs/rules/func-name-matching) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14964](https://github.com/eslint/eslint/issues/14964)) (Milos Djermanovic)
* [`3d7d5fb`](https://github.com/eslint/eslint/commit/3d7d5fb32425e8c04d3eaa0107a2ab03a2e285df) Update: reporting loc for `never` option in [`eol-last`](/docs/rules/eol-last) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#14840](https://github.com/eslint/eslint/issues/14840)) (Nitin Kumar)
* [`f110926`](https://github.com/eslint/eslint/commit/f110926a7abcc875a86dd13116f794e4f950e2ba) Update: fix [no-unused-vars](/docs/rules/no-unused-vars) false negative with comma operator ([#14928](https://github.com/eslint/eslint/issues/14928)) (Sachin)
* [`26b0cd9`](https://github.com/eslint/eslint/commit/26b0cd924e79a0ab2374c0cd813e92055f9fff7b) Update: fix [no-unreachable](/docs/rules/no-unreachable) logic for class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14920](https://github.com/eslint/eslint/issues/14920)) (Milos Djermanovic)
* [`9052eee`](https://github.com/eslint/eslint/commit/9052eee07a459dc059cd92f657a3ae73acc95bb5) Update: check class fields in [no-extra-parens](/docs/rules/no-extra-parens) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14906](https://github.com/eslint/eslint/issues/14906)) (Milos Djermanovic)




## Bug Fixes


* [`2174a6f`](https://github.com/eslint/eslint/commit/2174a6f0e5d18b673604d31e3ca7b790cdc9429b) Fix: [require-atomic-updates](/docs/rules/require-atomic-updates) property assignment message (fixes [#15076](https://github.com/eslint/eslint/issues/15076)) ([#15109](https://github.com/eslint/eslint/issues/15109)) (Milos Djermanovic)
* [`c9efb5f`](https://github.com/eslint/eslint/commit/c9efb5f91937dcb6c8f3d7cb2f59940046d77901) Fix: preserve formatting when rules are removed from disable directives ([#15081](https://github.com/eslint/eslint/issues/15081)) (Milos Djermanovic)
* [`9bd3d87`](https://github.com/eslint/eslint/commit/9bd3d87c8d7369e85f2b7d9b784fed8143191d30) Fix: semicolon-less style in [lines-between-class-members](/docs/rules/lines-between-class-members) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#15045](https://github.com/eslint/eslint/issues/15045)) (Milos Djermanovic)
* [`f966fe6`](https://github.com/eslint/eslint/commit/f966fe6286b6f668812f5155b79d4ee2a8b584b3) Fix: Update [semi](/docs/rules/semi) for class-fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14945](https://github.com/eslint/eslint/issues/14945)) (Nicholas C. Zakas)
* [`e9764f3`](https://github.com/eslint/eslint/commit/e9764f3e2fe3f7b6341c9a4381f0dcd23548338e) Fix: [no-undef-init](/docs/rules/no-undef-init) should not apply to class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14994](https://github.com/eslint/eslint/issues/14994)) (Milos Djermanovic)
* [`3409785`](https://github.com/eslint/eslint/commit/3409785a41a5bd2b128ed11b8baf7a59f9e412ee) Fix: [camelcase](/docs/rules/camelcase) ignoreGlobals shouldn't apply to undef vars (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14966](https://github.com/eslint/eslint/issues/14966)) (Milos Djermanovic)
* [`ee1b54f`](https://github.com/eslint/eslint/commit/ee1b54f31fa840e6ec72a313aa4090fdd3e985cd) Fix: [keyword-spacing](/docs/rules/keyword-spacing) private name compat (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14946](https://github.com/eslint/eslint/issues/14946)) (Nicholas C. Zakas)
* [`af96584`](https://github.com/eslint/eslint/commit/af965848c010612c3e136c367cc9b9e2e822f580) Fix: handle computed class fields in [operator-linebreak](/docs/rules/operator-linebreak) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14915](https://github.com/eslint/eslint/issues/14915)) (Milos Djermanovic)
* [`a773b99`](https://github.com/eslint/eslint/commit/a773b99873965652a86bec489193dc42a8923f5f) Fix: [no-useless-computed-key](/docs/rules/no-useless-computed-key) edge cases with class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14903](https://github.com/eslint/eslint/issues/14903)) (Milos Djermanovic)
* [`cbc43da`](https://github.com/eslint/eslint/commit/cbc43daad2ea229fb15a9198efd2bc2721dfb75f) Fix: [prefer-destructuring](/docs/rules/prefer-destructuring) PrivateIdentifier false positive (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14897](https://github.com/eslint/eslint/issues/14897)) (Milos Djermanovic)
* [`ccb9a91`](https://github.com/eslint/eslint/commit/ccb9a9138acd63457e004630475495954c1be6f4) Fix: [dot-notation](/docs/rules/dot-notation) false positive with private identifier (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14898](https://github.com/eslint/eslint/issues/14898)) (Milos Djermanovic)




## Documentation


* [`f885fe0`](https://github.com/eslint/eslint/commit/f885fe06a0a79d91fc72a132fd31edf9ef0502cd) Docs: add note and example for extending the range of fix (refs [#13706](https://github.com/eslint/eslint/issues/13706)) ([#13748](https://github.com/eslint/eslint/issues/13748)) (Milos Djermanovic)
* [`3da1509`](https://github.com/eslint/eslint/commit/3da1509106f508f0eb8ba48cdfc666225fda7edc) Docs: Add jsdoc `type` annotation to sample rule ([#15085](https://github.com/eslint/eslint/issues/15085)) (Bryan Mishkin)
* [`68a49a9`](https://github.com/eslint/eslint/commit/68a49a9446c3286bb9ff24b90713c794b7e1f6f5) Docs: Update Rollup Integrations ([#15142](https://github.com/eslint/eslint/issues/15142)) (xiaohai)
* [`d867f81`](https://github.com/eslint/eslint/commit/d867f8100737bb82742debee2b5dc853c5f07c91) Docs: Remove a dot from [curly](/docs/rules/curly) link ([#15128](https://github.com/eslint/eslint/issues/15128)) (Mauro Murru)
* [`2d654f1`](https://github.com/eslint/eslint/commit/2d654f115f6e05b59c85434e75cf68204b976f22) Docs: add example .eslintrc.json ([#15087](https://github.com/eslint/eslint/issues/15087)) (Nicolas Mattia)
* [`16034f0`](https://github.com/eslint/eslint/commit/16034f09ae6c7a78b8268b4c859928f18de7b9d6) Docs: fix fixable example ([#15107](https://github.com/eslint/eslint/issues/15107)) (QiChang Li)
* [`7f2346b`](https://github.com/eslint/eslint/commit/7f2346b40ffd0d470092e52b995d7ab2648089db) Docs: Update release blog post template ([#15094](https://github.com/eslint/eslint/issues/15094)) (Nicholas C. Zakas)
* [`a744dfa`](https://github.com/eslint/eslint/commit/a744dfa1f077afe406014f84135f8d26e9a12a94) Docs: Update CLA info ([#15058](https://github.com/eslint/eslint/issues/15058)) (Brian Warner)
* [`91e82f5`](https://github.com/eslint/eslint/commit/91e82f5c4cfeab5ac6d01865ce0eb9ea0649df39) Docs: LintMessage.line and column are possibly undefined ([#15032](https://github.com/eslint/eslint/issues/15032)) (Brandon Mills)
* [`dd56631`](https://github.com/eslint/eslint/commit/dd5663166a8235512e797522731af1e9651f9392) Docs: remove duplicate code path analysis document ([#15033](https://github.com/eslint/eslint/issues/15033)) (Milos Djermanovic)
* [`8c61f5a`](https://github.com/eslint/eslint/commit/8c61f5ac67682fcfec7fc6faafcf72e4b1a339ff) Docs: add info about non-capturing groups to [prefer-named-capture-group](/docs/rules/prefer-named-capture-group) ([#15009](https://github.com/eslint/eslint/issues/15009)) (Andrzej Wódkiewicz)
* [`4338b74`](https://github.com/eslint/eslint/commit/4338b74767fa71e4e8d171f8503aa33d970e509f) Docs: add [no-dupe-class-members](/docs/rules/no-dupe-class-members) examples with class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#15005](https://github.com/eslint/eslint/issues/15005)) (Milos Djermanovic)
* [`88b4e3d`](https://github.com/eslint/eslint/commit/88b4e3d191c2577e2e1a283cc5f825feea6271cc) Docs: Make clear how rule options are overridden (fixes [#14962](https://github.com/eslint/eslint/issues/14962)) ([#14976](https://github.com/eslint/eslint/issues/14976)) (Jake Ob)
* [`4165c7f`](https://github.com/eslint/eslint/commit/4165c7f937f5fc46d4209ae8f763238d73f37238) Docs: Clarify Linter vs ESLint in node.js api docs (fixes [#14953](https://github.com/eslint/eslint/issues/14953)) ([#14995](https://github.com/eslint/eslint/issues/14995)) (Brian Bartels)
* [`80cfb8f`](https://github.com/eslint/eslint/commit/80cfb8f858888bddfefd7de6b4ecbf5aabe267bc) Docs: fix typo in migration guide ([#14985](https://github.com/eslint/eslint/issues/14985)) (Nitin Kumar)
* [`396a0e3`](https://github.com/eslint/eslint/commit/396a0e3c7c82e5d2680d07250008094f336856db) Docs: update ScopeManager with class fields ([#14974](https://github.com/eslint/eslint/issues/14974)) (Milos Djermanovic)
* [`6663e7a`](https://github.com/eslint/eslint/commit/6663e7aed498a73108b5e6371f218d9411b87796) Docs: remove `docs` script (fixes [#14288](https://github.com/eslint/eslint/issues/14288)) ([#14971](https://github.com/eslint/eslint/issues/14971)) (Nitin Kumar)
* [`44f7de5`](https://github.com/eslint/eslint/commit/44f7de5ee4d934dee540d3d55305126c670f6bfc) Docs: Update deprecated information ([#14961](https://github.com/eslint/eslint/issues/14961)) (TagawaHirotaka)
* [`a8bcef7`](https://github.com/eslint/eslint/commit/a8bcef70a4a6b1fbb2007075bed754635f27ff01) Docs: Add 2021 and 2022 to supported ECMAScript versions ([#14952](https://github.com/eslint/eslint/issues/14952)) (coderaiser)
* [`b301069`](https://github.com/eslint/eslint/commit/b301069981dc1dcca51df2813dcebdca8c150502) Docs: fix 'When Not To Use' in [prefer-named-capture-group](/docs/rules/prefer-named-capture-group) (refs [#14959](https://github.com/eslint/eslint/issues/14959)) ([#14969](https://github.com/eslint/eslint/issues/14969)) (Milos Djermanovic)
* [`e98f14d`](https://github.com/eslint/eslint/commit/e98f14d356b5ff934dd2a0a1fb226f1b15317ab3) Docs: Fix typo in [no-implicit-globals](/docs/rules/no-implicit-globals).md ([#14954](https://github.com/eslint/eslint/issues/14954)) (jwbth)
* [`81c60f4`](https://github.com/eslint/eslint/commit/81c60f4a8725738f191580646562d1dca7eee933) Docs: document ESLint api ([#14934](https://github.com/eslint/eslint/issues/14934)) (Sam Chen)
* [`28fe19c`](https://github.com/eslint/eslint/commit/28fe19c4a9108111932966aa7c9f361c26601d70) Docs: Add v8.0.0 migration guide (fixes [#14856](https://github.com/eslint/eslint/issues/14856)) ([#14884](https://github.com/eslint/eslint/issues/14884)) (Nicholas C. Zakas)
* [`1f5d088`](https://github.com/eslint/eslint/commit/1f5d0889264c60dddb6fb07a3b1e43f840e84d57) Docs: add an example `Object.assign()` for rule [no-import-assign](/docs/rules/no-import-assign) ([#14916](https://github.com/eslint/eslint/issues/14916)) (薛定谔的猫)
* [`c4e5802`](https://github.com/eslint/eslint/commit/c4e58023f22381508babfc52087853b5e3965b9c) Docs: improve rule details for [`no-console`](/docs/rules/no-console) (fixes [#14793](https://github.com/eslint/eslint/issues/14793)) ([#14901](https://github.com/eslint/eslint/issues/14901)) (Nitin Kumar)
* [`5c3a470`](https://github.com/eslint/eslint/commit/5c3a47072aeb5cfda40a1eb20b43a10c5ca7aab3) Docs: add class fields in [no-multi-assign](/docs/rules/no-multi-assign) documentation (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14907](https://github.com/eslint/eslint/issues/14907)) (Milos Djermanovic)
* [`d234d89`](https://github.com/eslint/eslint/commit/d234d890b383837f8e4bda0f6ce1e2a348f9835e) Docs: add class fields in [func-names](/docs/rules/func-names) documentation (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14908](https://github.com/eslint/eslint/issues/14908)) (Milos Djermanovic)
* [`e037d61`](https://github.com/eslint/eslint/commit/e037d61a12ad17a36e05dcf65aa63fad303c79b9) Docs: Mention workaround for escaping the slash character in selectors ([#14675](https://github.com/eslint/eslint/issues/14675)) (Aria)
* [`81f03b6`](https://github.com/eslint/eslint/commit/81f03b6ad69c7f67ad6ba72e02e73266aa8f7696) Docs: Update license copyright ([#14877](https://github.com/eslint/eslint/issues/14877)) (Nicholas C. Zakas)




## Dependency Upgrades


* [`7d3f7f0`](https://github.com/eslint/eslint/commit/7d3f7f01281671c4761f8da0d3ae9882a38eca8a) Upgrade: unfrozen @eslint/eslintrc (fixes [#15036](https://github.com/eslint/eslint/issues/15036)) ([#15146](https://github.com/eslint/eslint/issues/15146)) (Brandon Mills)
* [`9e5c2e8`](https://github.com/eslint/eslint/commit/9e5c2e853ace560876c2f2119e134639be8659d0) Upgrade: @eslint/eslintrc@1.0.1 ([#15047](https://github.com/eslint/eslint/issues/15047)) (Milos Djermanovic)
* [`ec9db63`](https://github.com/eslint/eslint/commit/ec9db63e53a6605a558dcd82947d2425f89887c3) Upgrade: @eslint/eslintrc@1.0.0 ([#14865](https://github.com/eslint/eslint/issues/14865)) (Milos Djermanovic)
* [`62c6fe7`](https://github.com/eslint/eslint/commit/62c6fe7d10ff4eeebd196e143f96cfd88818393d) Upgrade: Debug 4.0.1 > 4.3.2 ([#14892](https://github.com/eslint/eslint/issues/14892)) (sandesh bafna)
* [`88db3f5`](https://github.com/eslint/eslint/commit/88db3f54988dddfbda35764ecf1ea16354c4213a) Upgrade: `js-yaml` to v4 ([#14890](https://github.com/eslint/eslint/issues/14890)) (Bryan Mishkin)
* [`ae6072b`](https://github.com/eslint/eslint/commit/ae6072b1de5c8b30ce6c58290852082439c40b30) Upgrade: `eslint-visitor-keys` to v3 ([#14902](https://github.com/eslint/eslint/issues/14902)) (Bryan Mishkin)
* [`e53d8cf`](https://github.com/eslint/eslint/commit/e53d8cf9d73bd105cf6ba4f6b5477ccc4b980939) Upgrade: `markdownlint` dev dependencies ([#14883](https://github.com/eslint/eslint/issues/14883)) (Bryan Mishkin)
* [`d66e941`](https://github.com/eslint/eslint/commit/d66e9414be60e05badb96bc3e1a55ca34636d7f8) Upgrade: @humanwhocodes/config-array to 0.6 ([#14891](https://github.com/eslint/eslint/issues/14891)) (Bryan Mishkin)




## Build Related


* [`71faa38`](https://github.com/eslint/eslint/commit/71faa38adada4bd2f1ec0da7e45e6c7c84d1671d) Build: changelog update for 8.0.0-rc.0 (ESLint Jenkins)
* [`d148ffd`](https://github.com/eslint/eslint/commit/d148ffdec385e832956c748e36941e598b57b031) Build: changelog update for 8.0.0-beta.2 (ESLint Jenkins)
* [`95cc61e`](https://github.com/eslint/eslint/commit/95cc61e40a89aa2278ae93ae2f35c38737280abb) Build: changelog update for 8.0.0-beta.1 (ESLint Jenkins)
* [`c74fe08`](https://github.com/eslint/eslint/commit/c74fe08642c30e1a4cd4e0866251a2d29466add8) Build: Force prerelease peer dep for Node 16 in CI ([#14933](https://github.com/eslint/eslint/issues/14933)) (Brandon Mills)
* [`027165c`](https://github.com/eslint/eslint/commit/027165cacf62ab1662f4c343ff30b235fd9d46b8) Build: changelog update for 8.0.0-beta.0 (ESLint Jenkins)
* [`b8b2d55`](https://github.com/eslint/eslint/commit/b8b2d5553b0de23e8b72ee45949650cd5f9a10d2) Build: add codeql ([#14729](https://github.com/eslint/eslint/issues/14729)) (薛定谔的猫)




## Chores


* [`fabdf8a`](https://github.com/eslint/eslint/commit/fabdf8a4e2f82b5fe2f903f015c3e60747a0b143) Chore: Remove `target.all` from `Makefile.js` ([#15088](https://github.com/eslint/eslint/issues/15088)) (Hirotaka Tagawa / wafuwafu13)
* [`05d7140`](https://github.com/eslint/eslint/commit/05d7140d46e2b5300d4dc9a60450eed956c95420) Chore: document target global in Makefile.js ([#15084](https://github.com/eslint/eslint/issues/15084)) (Hirotaka Tagawa / wafuwafu13)
* [`47be800`](https://github.com/eslint/eslint/commit/47be8003d700bc0606495ae42610eaba94e639c5) Chore: test Property > .key with { a = 1 } pattern (fixes [#14799](https://github.com/eslint/eslint/issues/14799)) ([#15072](https://github.com/eslint/eslint/issues/15072)) (Milos Djermanovic)
* [`9fb0f70`](https://github.com/eslint/eslint/commit/9fb0f7040759ea23538997648f2d2d53e7c9db8a) Chore: fix bug report template ([#15061](https://github.com/eslint/eslint/issues/15061)) (Milos Djermanovic)
* [`f87e199`](https://github.com/eslint/eslint/commit/f87e199e988f42fc490890eee0642d86c48c85ff) Chore: Cleanup issue templates ([#15039](https://github.com/eslint/eslint/issues/15039)) (Nicholas C. Zakas)
* [`921ba1e`](https://github.com/eslint/eslint/commit/921ba1ee53e5f2219f09050565b8d69fab517d72) Chore: fix failing cli test ([#15041](https://github.com/eslint/eslint/issues/15041)) (Milos Djermanovic)
* [`143a598`](https://github.com/eslint/eslint/commit/143a5987f18f063a47a0646fa1e10e0f88602f6f) Chore: Switch issues to use forms ([#15024](https://github.com/eslint/eslint/issues/15024)) (Nicholas C. Zakas)
* [`b4232d4`](https://github.com/eslint/eslint/commit/b4232d47f88611c68a6c0f915b092b68845ecbaf) Chore: Add test that deprecated rules display a deprecated notice ([#14989](https://github.com/eslint/eslint/issues/14989)) (TagawaHirotaka)
* [`db15183`](https://github.com/eslint/eslint/commit/db1518374a5e88efedf1ed4609d879f3091af74f) Chore: Refactor comments of tests ([#14956](https://github.com/eslint/eslint/issues/14956)) (TagawaHirotaka)
* [`a79c9f3`](https://github.com/eslint/eslint/commit/a79c9f35d665c2bcc63267bdf359a8176e0a84ce) Chore: Enforce jsdoc check-line-alignment never ([#14955](https://github.com/eslint/eslint/issues/14955)) (Brett Zamir)
* [`2d18db6`](https://github.com/eslint/eslint/commit/2d18db6278320fb97bc8e0bff3518c790566a6a6) Chore: add test for merging `parserOptions` in Linter ([#14948](https://github.com/eslint/eslint/issues/14948)) (Milos Djermanovic)
* [`9a4ae3b`](https://github.com/eslint/eslint/commit/9a4ae3b68a1afd9483d331997635727fb19a1a99) Chore: Apply comment require-description and check ClassDeclaration ([#14949](https://github.com/eslint/eslint/issues/14949)) (Brett Zamir)
* [`8344675`](https://github.com/eslint/eslint/commit/8344675c309a359dd2af5afddba6122f5dc803d0) Chore: fix small typo ([#14951](https://github.com/eslint/eslint/issues/14951)) (Sosuke Suzuki)
* [`58840ac`](https://github.com/eslint/eslint/commit/58840ac844a61c72eabb603ecfb761812b82a7ed) Chore: Update jsdoc plugin and tweak rules in effect ([#14814](https://github.com/eslint/eslint/issues/14814)) (Brett Zamir)
* [`be334f9`](https://github.com/eslint/eslint/commit/be334f9d8633e9d193dcb8b36f484547e9d3ab97) Chore: Fix Makefile call to linter.getRules() ([#14932](https://github.com/eslint/eslint/issues/14932)) (Brandon Mills)
* [`0c86b68`](https://github.com/eslint/eslint/commit/0c86b68a6e2435eb03b681b51b099b552b521adc) Chore: Replace old syntax for Array flat/flatMap ([#14614](https://github.com/eslint/eslint/issues/14614)) (Stephen Wade)
* [`6a89f3f`](https://github.com/eslint/eslint/commit/6a89f3f7b6a3edb3465952521bdf06a220515b95) Chore: ignore `yarn-error.log` and `.pnpm-debug.log` ([#14925](https://github.com/eslint/eslint/issues/14925)) (Nitin Kumar)
* [`3b6cd89`](https://github.com/eslint/eslint/commit/3b6cd8934b3640ffb6fa49b471babf07f0ad769a) Chore: Add rel/abs path tests in `no-restricted-{imports/modules}` rules ([#14910](https://github.com/eslint/eslint/issues/14910)) (Bryan Mishkin)
* [`f984515`](https://github.com/eslint/eslint/commit/f98451584a82e41f82ceacd484ea0fe90aa9ce63) Chore: add assertions on reporting location in [`semi`](/docs/rules/semi) ([#14899](https://github.com/eslint/eslint/issues/14899)) (Nitin Kumar)
* [`149230c`](https://github.com/eslint/eslint/commit/149230ce7e296c029a0b6c085216fc0360ed4c65) Chore: Specify Node 14.x for Verify Files CI job ([#14896](https://github.com/eslint/eslint/issues/14896)) (Milos Djermanovic)
* [`537cf6a`](https://github.com/eslint/eslint/commit/537cf6a0e78ee9b7167e7f8c56f4053d3fb5b2d7) Chore: update `glob-parent` (fixes [#14879](https://github.com/eslint/eslint/issues/14879))([#14887](https://github.com/eslint/eslint/issues/14887)) (Nitin Kumar)
* [`f7b4a3f`](https://github.com/eslint/eslint/commit/f7b4a3f6a44e167c71985d373f73eebd3a4d9556) Chore: update dev deps to latest ([#14624](https://github.com/eslint/eslint/issues/14624)) (薛定谔的猫)
