---
layout: post
title: ESLint v8.0.0-rc.0 released
teaser: "We just pushed ESLint v8.0.0-rc.0, which is a new prerelease version for ESLint v8. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-beta.png
tags:
  - release
  - minor
authors:
  - mdjermanovic
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

This version of ESLint is provided to gather feedback from the community before releasing the final version. Please try it and report any unexpected issues.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@8.0.0-rc.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/8.0.0/user-guide/migrating-to-8.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.








## Enhancements


* [`67c0074`](https://github.com/eslint/eslint/commit/67c0074fa843fab629f464ff875007a8ee33cc7f) Update: Suggest missing rule in flat config (fixes [#14027](https://github.com/eslint/eslint/issues/14027)) ([#15074](https://github.com/eslint/eslint/issues/15074)) (Nicholas C. Zakas)
* [`cf34e5c`](https://github.com/eslint/eslint/commit/cf34e5cf5ed5d09eb53c16cca06821c4e34b7b70) Update: [space-before-blocks](/docs/rules/space-before-blocks) ignore after switch colons (fixes [#15082](https://github.com/eslint/eslint/issues/15082)) ([#15093](https://github.com/eslint/eslint/issues/15093)) (Milos Djermanovic)
* [`14a4739`](https://github.com/eslint/eslint/commit/14a4739ab2233acef995a6dde233de05d067a0f3) Update: [`no-new-func`](/docs/rules/no-new-func) rule catching eval case of `MemberExpression` ([#14860](https://github.com/eslint/eslint/issues/14860)) (Mojtaba Samimi)
* [`0a1a850`](https://github.com/eslint/eslint/commit/0a1a850575ca75db017051abe5e931f0f9c8012b) Update: include `ruleId` in error logs (fixes [#15037](https://github.com/eslint/eslint/issues/15037)) ([#15053](https://github.com/eslint/eslint/issues/15053)) (Ari Perkkiö)




## Bug Fixes


* [`c9efb5f`](https://github.com/eslint/eslint/commit/c9efb5f91937dcb6c8f3d7cb2f59940046d77901) Fix: preserve formatting when rules are removed from disable directives ([#15081](https://github.com/eslint/eslint/issues/15081)) (Milos Djermanovic)




## Documentation


* [`7f2346b`](https://github.com/eslint/eslint/commit/7f2346b40ffd0d470092e52b995d7ab2648089db) Docs: Update release blog post template ([#15094](https://github.com/eslint/eslint/issues/15094)) (Nicholas C. Zakas)
* [`a744dfa`](https://github.com/eslint/eslint/commit/a744dfa1f077afe406014f84135f8d26e9a12a94) Docs: Update CLA info ([#15058](https://github.com/eslint/eslint/issues/15058)) (Brian Warner)








## Chores


* [`fabdf8a`](https://github.com/eslint/eslint/commit/fabdf8a4e2f82b5fe2f903f015c3e60747a0b143) Chore: Remove `target.all` from `Makefile.js` ([#15088](https://github.com/eslint/eslint/issues/15088)) (Hirotaka Tagawa / wafuwafu13)
* [`05d7140`](https://github.com/eslint/eslint/commit/05d7140d46e2b5300d4dc9a60450eed956c95420) Chore: document target global in Makefile.js ([#15084](https://github.com/eslint/eslint/issues/15084)) (Hirotaka Tagawa / wafuwafu13)
* [`47be800`](https://github.com/eslint/eslint/commit/47be8003d700bc0606495ae42610eaba94e639c5) Chore: test Property > .key with { a = 1 } pattern (fixes [#14799](https://github.com/eslint/eslint/issues/14799)) ([#15072](https://github.com/eslint/eslint/issues/15072)) (Milos Djermanovic)
* [`9fb0f70`](https://github.com/eslint/eslint/commit/9fb0f7040759ea23538997648f2d2d53e7c9db8a) Chore: fix bug report template ([#15061](https://github.com/eslint/eslint/issues/15061)) (Milos Djermanovic)
* [`f87e199`](https://github.com/eslint/eslint/commit/f87e199e988f42fc490890eee0642d86c48c85ff) Chore: Cleanup issue templates ([#15039](https://github.com/eslint/eslint/issues/15039)) (Nicholas C. Zakas)


