---
layout: post
title: ESLint v8.0.0-beta.2 released
teaser: "We just pushed ESLint v8.0.0-beta.2, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - mdjermanovic
categories:
  - Release Notes
---

## Highlights

* The use of reserved words as identifiers in ES3 is now [disallowed](https://github.com/eslint/eslint/issues/15017). This change only affects users with default parser configured with `{ "ecmaVersion": 3 }` in parser options.
* All core rules have been updated to support ES2022 class fields and private class members. ESLint now fully supports the following ES2022 syntax:
  * Class public instance fields and private instance fields
  * Class public static fields and private static fields
  * Class private instance methods and accessors
  * Class private static methods and accessors
  * RegExp match indices
  * Top-level `await`
* The [`class-methods-use-this`](/docs/8.0.0/rules/class-methods-use-this) rule has a new `enforceForClassFields` option.
* The [`max-classes-per-file`](/docs/8.0.0/rules/max-classes-per-file) rule has a new `ignoreExpressions` option.

Since this is a beta release, it is not expected to be ready for production, but please try it and report any unexpected issues.

### Notes

* VS Code ESLint extension has [added support for ESLint v8.0.0](https://marketplace.visualstudio.com/items/dbaeumer.vscode-eslint/changelog), you'll just need to install the latest v2.1.25 of the extension.
* We have received reports from plugin authors about [problems with testing plugin rules with Jest](https://github.com/eslint/eslint/issues/14936#issuecomment-905786726), as Jest's resolver currently doesn't support [subpath exports](https://nodejs.org/api/packages.html#packages_subpath_exports). For a workaround, please see [this comment](https://github.com/eslint/eslint/issues/14936#issuecomment-906768517).


### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@8.0.0-beta.2 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/8.0.0/user-guide/migrating-to-8.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`7cf96cf`](https://github.com/eslint/eslint/commit/7cf96cf185f849d379b660072d660ec35ac5b46d) Breaking: Disallow reserved words in ES3 (fixes [#15017](https://github.com/eslint/eslint/issues/15017)) ([#15046](https://github.com/eslint/eslint/issues/15046)) (Milos Djermanovic)






## Enhancements


* [`88a3952`](https://github.com/eslint/eslint/commit/88a39520716bdd11f8647e47c57bd8bf91bc7148) Update: support class fields in the [`complexity`](/docs/rules/complexity) rule (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14957](https://github.com/eslint/eslint/issues/14957)) (Milos Djermanovic)
* [`6d1ccb6`](https://github.com/eslint/eslint/commit/6d1ccb676fedd1ceb4b1e44abf8133f116a5aecb) Update: enforceForClassFields in [class-methods-use-this](/docs/rules/class-methods-use-this) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#15018](https://github.com/eslint/eslint/issues/15018)) (YeonJuan)
* [`dd10937`](https://github.com/eslint/eslint/commit/dd109379f730a988a9e6c0102bcfe443ad0b4b94) Update: added ignoreExpressions option to [max-classes-per-file](/docs/rules/max-classes-per-file) ([#15000](https://github.com/eslint/eslint/issues/15000)) (Josh Goldberg)




## Bug Fixes


* [`9bd3d87`](https://github.com/eslint/eslint/commit/9bd3d87c8d7369e85f2b7d9b784fed8143191d30) Fix: semicolon-less style in [lines-between-class-members](/docs/rules/lines-between-class-members) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#15045](https://github.com/eslint/eslint/issues/15045)) (Milos Djermanovic)
* [`f966fe6`](https://github.com/eslint/eslint/commit/f966fe6286b6f668812f5155b79d4ee2a8b584b3) Fix: Update [semi](/docs/rules/semi) for class-fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14945](https://github.com/eslint/eslint/issues/14945)) (Nicholas C. Zakas)
* [`e9764f3`](https://github.com/eslint/eslint/commit/e9764f3e2fe3f7b6341c9a4381f0dcd23548338e) Fix: [no-undef-init](/docs/rules/no-undef-init) should not apply to class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14994](https://github.com/eslint/eslint/issues/14994)) (Milos Djermanovic)




## Documentation


* [`91e82f5`](https://github.com/eslint/eslint/commit/91e82f5c4cfeab5ac6d01865ce0eb9ea0649df39) Docs: LintMessage.line and column are possibly undefined ([#15032](https://github.com/eslint/eslint/issues/15032)) (Brandon Mills)
* [`dd56631`](https://github.com/eslint/eslint/commit/dd5663166a8235512e797522731af1e9651f9392) Docs: remove duplicate code path analysis document ([#15033](https://github.com/eslint/eslint/issues/15033)) (Milos Djermanovic)
* [`8c61f5a`](https://github.com/eslint/eslint/commit/8c61f5ac67682fcfec7fc6faafcf72e4b1a339ff) Docs: add info about non-capturing groups to [prefer-named-capture-group](/docs/rules/prefer-named-capture-group) ([#15009](https://github.com/eslint/eslint/issues/15009)) (Andrzej Wódkiewicz)
* [`4338b74`](https://github.com/eslint/eslint/commit/4338b74767fa71e4e8d171f8503aa33d970e509f) Docs: add [no-dupe-class-members](/docs/rules/no-dupe-class-members) examples with class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#15005](https://github.com/eslint/eslint/issues/15005)) (Milos Djermanovic)
* [`88b4e3d`](https://github.com/eslint/eslint/commit/88b4e3d191c2577e2e1a283cc5f825feea6271cc) Docs: Make clear how rule options are overridden (fixes [#14962](https://github.com/eslint/eslint/issues/14962)) ([#14976](https://github.com/eslint/eslint/issues/14976)) (Jake Ob)
* [`4165c7f`](https://github.com/eslint/eslint/commit/4165c7f937f5fc46d4209ae8f763238d73f37238) Docs: Clarify Linter vs ESLint in node.js api docs (fixes [#14953](https://github.com/eslint/eslint/issues/14953)) ([#14995](https://github.com/eslint/eslint/issues/14995)) (Brian Bartels)
* [`80cfb8f`](https://github.com/eslint/eslint/commit/80cfb8f858888bddfefd7de6b4ecbf5aabe267bc) Docs: fix typo in migration guide ([#14985](https://github.com/eslint/eslint/issues/14985)) (Nitin Kumar)




## Dependency Upgrades


* [`9e5c2e8`](https://github.com/eslint/eslint/commit/9e5c2e853ace560876c2f2119e134639be8659d0) Upgrade: @eslint/eslintrc@1.0.1 ([#15047](https://github.com/eslint/eslint/issues/15047)) (Milos Djermanovic)






## Chores


* [`921ba1e`](https://github.com/eslint/eslint/commit/921ba1ee53e5f2219f09050565b8d69fab517d72) Chore: fix failing cli test ([#15041](https://github.com/eslint/eslint/issues/15041)) (Milos Djermanovic)
* [`143a598`](https://github.com/eslint/eslint/commit/143a5987f18f063a47a0646fa1e10e0f88602f6f) Chore: Switch issues to use forms ([#15024](https://github.com/eslint/eslint/issues/15024)) (Nicholas C. Zakas)
* [`b4232d4`](https://github.com/eslint/eslint/commit/b4232d47f88611c68a6c0f915b092b68845ecbaf) Chore: Add test that deprecated rules display a deprecated notice ([#14989](https://github.com/eslint/eslint/issues/14989)) (TagawaHirotaka)


