---
layout: post
title: ESLint v8.0.0-beta.1 released
teaser: "We just pushed ESLint v8.0.0-beta.1, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - mdjermanovic
categories:
  - Release Notes
---

## Highlights


* Beta testing revealed that the impact of the breaking change to [allow line comment directives](https://github.com/eslint/eslint/pull/14656) for all directives that previously required block comments outweighs the benefits of this feature due to a high number of accidental directives, so we decided to [revert this change](https://github.com/eslint/eslint/issues/14960) and exclude this feature from v8.0.0.
* Code Path Analysis now supports ES2022 class fields. In particular, each class field initializer now starts a separate code path. A new `origin` property has been added to [CodePath](/docs/8.0.0/developer-guide/code-path-analysis#codepath) objects.
* The `meta.docs.category` property has been removed from all core rules.

Since this is a beta release, it is not expected to be ready for production, but please try it and report any unexpected issues.


### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@8.0.0-beta.1 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/8.0.0/user-guide/migrating-to-8.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`305e14a`](https://github.com/eslint/eslint/commit/305e14af8bd12afc01487abee5c9b0f3eaca989e) Breaking: remove meta.docs.category in core rules (fixes [#13398](https://github.com/eslint/eslint/issues/13398)) ([#14594](https://github.com/eslint/eslint/issues/14594)) (薛定谔的猫)






## Enhancements


* [`05ca24c`](https://github.com/eslint/eslint/commit/05ca24c57f90f91421b682dca3d7a45b7957fb77) Update: Code path analysis for class fields (fixes [#14343](https://github.com/eslint/eslint/issues/14343)) ([#14886](https://github.com/eslint/eslint/issues/14886)) (Nicholas C. Zakas)
* [`44c6fc8`](https://github.com/eslint/eslint/commit/44c6fc879de61e9513835d1d4d6ae978d9a43c51) Update: support class fields in [func-name-matching](/docs/rules/func-name-matching) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14964](https://github.com/eslint/eslint/issues/14964)) (Milos Djermanovic)
* [`3d7d5fb`](https://github.com/eslint/eslint/commit/3d7d5fb32425e8c04d3eaa0107a2ab03a2e285df) Update: reporting loc for `never` option in [`eol-last`](/docs/rules/eol-last) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#14840](https://github.com/eslint/eslint/issues/14840)) (Nitin Kumar)
* [`f110926`](https://github.com/eslint/eslint/commit/f110926a7abcc875a86dd13116f794e4f950e2ba) Update: fix [no-unused-vars](/docs/rules/no-unused-vars) false negative with comma operator ([#14928](https://github.com/eslint/eslint/issues/14928)) (Sachin)
* [`26b0cd9`](https://github.com/eslint/eslint/commit/26b0cd924e79a0ab2374c0cd813e92055f9fff7b) Update: fix [no-unreachable](/docs/rules/no-unreachable) logic for class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14920](https://github.com/eslint/eslint/issues/14920)) (Milos Djermanovic)




## Bug Fixes


* [`3409785`](https://github.com/eslint/eslint/commit/3409785a41a5bd2b128ed11b8baf7a59f9e412ee) Fix: [camelcase](/docs/rules/camelcase) ignoreGlobals shouldn't apply to undef vars (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14966](https://github.com/eslint/eslint/issues/14966)) (Milos Djermanovic)
* [`ee1b54f`](https://github.com/eslint/eslint/commit/ee1b54f31fa840e6ec72a313aa4090fdd3e985cd) Fix: [keyword-spacing](/docs/rules/keyword-spacing) private name compat (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14946](https://github.com/eslint/eslint/issues/14946)) (Nicholas C. Zakas)




## Documentation


* [`396a0e3`](https://github.com/eslint/eslint/commit/396a0e3c7c82e5d2680d07250008094f336856db) Docs: update ScopeManager with class fields ([#14974](https://github.com/eslint/eslint/issues/14974)) (Milos Djermanovic)
* [`6663e7a`](https://github.com/eslint/eslint/commit/6663e7aed498a73108b5e6371f218d9411b87796) Docs: remove `docs` script (fixes [#14288](https://github.com/eslint/eslint/issues/14288)) ([#14971](https://github.com/eslint/eslint/issues/14971)) (Nitin Kumar)
* [`44f7de5`](https://github.com/eslint/eslint/commit/44f7de5ee4d934dee540d3d55305126c670f6bfc) Docs: Update deprecated information ([#14961](https://github.com/eslint/eslint/issues/14961)) (TagawaHirotaka)
* [`a8bcef7`](https://github.com/eslint/eslint/commit/a8bcef70a4a6b1fbb2007075bed754635f27ff01) Docs: Add 2021 and 2022 to supported ECMAScript versions ([#14952](https://github.com/eslint/eslint/issues/14952)) (coderaiser)
* [`b301069`](https://github.com/eslint/eslint/commit/b301069981dc1dcca51df2813dcebdca8c150502) Docs: fix 'When Not To Use' in [prefer-named-capture-group](/docs/rules/prefer-named-capture-group) (refs [#14959](https://github.com/eslint/eslint/issues/14959)) ([#14969](https://github.com/eslint/eslint/issues/14969)) (Milos Djermanovic)
* [`e98f14d`](https://github.com/eslint/eslint/commit/e98f14d356b5ff934dd2a0a1fb226f1b15317ab3) Docs: Fix typo in [no-implicit-globals](/docs/rules/no-implicit-globals).md ([#14954](https://github.com/eslint/eslint/issues/14954)) (jwbth)
* [`81c60f4`](https://github.com/eslint/eslint/commit/81c60f4a8725738f191580646562d1dca7eee933) Docs: document ESLint api ([#14934](https://github.com/eslint/eslint/issues/14934)) (Sam Chen)






## Build Related


* [`c74fe08`](https://github.com/eslint/eslint/commit/c74fe08642c30e1a4cd4e0866251a2d29466add8) Build: Force prerelease peer dep for Node 16 in CI ([#14933](https://github.com/eslint/eslint/issues/14933)) (Brandon Mills)




## Chores


* [`db15183`](https://github.com/eslint/eslint/commit/db1518374a5e88efedf1ed4609d879f3091af74f) Chore: Refactor comments of tests ([#14956](https://github.com/eslint/eslint/issues/14956)) (TagawaHirotaka)
* [`a79c9f3`](https://github.com/eslint/eslint/commit/a79c9f35d665c2bcc63267bdf359a8176e0a84ce) Chore: Enforce jsdoc check-line-alignment never ([#14955](https://github.com/eslint/eslint/issues/14955)) (Brett Zamir)
* [`2d18db6`](https://github.com/eslint/eslint/commit/2d18db6278320fb97bc8e0bff3518c790566a6a6) Chore: add test for merging `parserOptions` in Linter ([#14948](https://github.com/eslint/eslint/issues/14948)) (Milos Djermanovic)
* [`9a4ae3b`](https://github.com/eslint/eslint/commit/9a4ae3b68a1afd9483d331997635727fb19a1a99) Chore: Apply comment require-description and check ClassDeclaration ([#14949](https://github.com/eslint/eslint/issues/14949)) (Brett Zamir)
* [`8344675`](https://github.com/eslint/eslint/commit/8344675c309a359dd2af5afddba6122f5dc803d0) Chore: fix small typo ([#14951](https://github.com/eslint/eslint/issues/14951)) (Sosuke Suzuki)
* [`58840ac`](https://github.com/eslint/eslint/commit/58840ac844a61c72eabb603ecfb761812b82a7ed) Chore: Update jsdoc plugin and tweak rules in effect ([#14814](https://github.com/eslint/eslint/issues/14814)) (Brett Zamir)


