---
layout: post
title: ESLint v8.0.0-beta.0 released
teaser: "We just pushed ESLint v8.0.0-beta.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

Most of the highlights of this release are breaking changes, and are discussed further in the [migration guide](/docs/8.0.0/user-guide/migrating-to-8.0.0). In addition, there are some new features:

- The default parser now supports ES2022 syntax, including class fields and top-level `await`. Some rules still need to be updated, and you can follow progress on the [tracking issue](https://github.com/eslint/eslint/issues/14857).
- Autofix gained support for removing unused disable directives when using `--fix` with `--report-unused-disable-directives`.

Since this is a beta release, it is not expected to be ready for production, but please try it and report any unexpected issues.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@8.0.0-beta.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/8.0.0/user-guide/migrating-to-8.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`24c9f2a`](https://github.com/eslint/eslint/commit/24c9f2ac57efcd699ca69695c82e51ce5742df7b) Breaking: Strict package exports (refs [#13654](https://github.com/eslint/eslint/issues/13654)) ([#14706](https://github.com/eslint/eslint/issues/14706)) (Nicholas C. Zakas)
* [`86d31a4`](https://github.com/eslint/eslint/commit/86d31a4951e3a39e359e284f5fe336ac477369fe) Breaking: disallow SourceCode#getComments() in RuleTester (refs [#14744](https://github.com/eslint/eslint/issues/14744)) ([#14769](https://github.com/eslint/eslint/issues/14769)) (Milos Djermanovic)
* [`1d2213d`](https://github.com/eslint/eslint/commit/1d2213deb69c5901c1950bbe648aa819e7e742ed) Breaking: Fixable disable directives (fixes [#11815](https://github.com/eslint/eslint/issues/11815)) ([#14617](https://github.com/eslint/eslint/issues/14617)) (Josh Goldberg)
* [`4a7aab7`](https://github.com/eslint/eslint/commit/4a7aab7d4323ff7027eebca709d4e95a9aaa80bc) Breaking: require `meta` for fixable rules (fixes [#13349](https://github.com/eslint/eslint/issues/13349)) ([#14634](https://github.com/eslint/eslint/issues/14634)) (Milos Djermanovic)
* [`d6a761f`](https://github.com/eslint/eslint/commit/d6a761f9b6582e9f71705161be827ca303ef183f) Breaking: Require `meta.hasSuggestions` for rules with suggestions ([#14573](https://github.com/eslint/eslint/issues/14573)) (Bryan Mishkin)
* [`4c841b8`](https://github.com/eslint/eslint/commit/4c841b880b5649392a55c98ecc9af757bd213ff0) Breaking: allow all directives in line comments (fixes [#14575](https://github.com/eslint/eslint/issues/14575)) ([#14656](https://github.com/eslint/eslint/issues/14656)) (薛定谔的猫)
* [`6bd747b`](https://github.com/eslint/eslint/commit/6bd747b5b7731195224875b952a9ea61445a9938) Breaking: support new regex d flag (fixes [#14640](https://github.com/eslint/eslint/issues/14640)) ([#14653](https://github.com/eslint/eslint/issues/14653)) (Yosuke Ota)
* [`8b4f3ab`](https://github.com/eslint/eslint/commit/8b4f3abdb794feb3be31959bb44bfb0ef6318e8e) Breaking: fix [comma-dangle](/docs/rules/comma-dangle) schema (fixes [#13739](https://github.com/eslint/eslint/issues/13739)) ([#14030](https://github.com/eslint/eslint/issues/14030)) (Joakim Nilsson)
* [`b953a4e`](https://github.com/eslint/eslint/commit/b953a4ee12f120658a9ec27d1f8ca88dd3dfb599) Breaking: upgrade espree and support new class features (refs [#14343](https://github.com/eslint/eslint/issues/14343)) ([#14591](https://github.com/eslint/eslint/issues/14591)) (Toru Nagashima)
* [`8cce06c`](https://github.com/eslint/eslint/commit/8cce06cb39886902ce0d2e6882f46c3bf52fb955) Breaking: add some rules to eslint:recommended (refs [#14673](https://github.com/eslint/eslint/issues/14673)) ([#14691](https://github.com/eslint/eslint/issues/14691)) (薛定谔的猫)
* [`86bb63b`](https://github.com/eslint/eslint/commit/86bb63b370e0ff350e988a5fa228a8234abe800c) Breaking: Drop `codeframe` and `table` formatters ([#14316](https://github.com/eslint/eslint/issues/14316)) (Federico Brigante)
* [`f3cb320`](https://github.com/eslint/eslint/commit/f3cb3208c8952a6218d54658cfda85942b9fda42) Breaking: drop node v10/v13/v15 (fixes [#14023](https://github.com/eslint/eslint/issues/14023)) ([#14592](https://github.com/eslint/eslint/issues/14592)) (薛定谔的猫)






## Enhancements


* [`9052eee`](https://github.com/eslint/eslint/commit/9052eee07a459dc059cd92f657a3ae73acc95bb5) Update: check class fields in [no-extra-parens](/docs/rules/no-extra-parens) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14906](https://github.com/eslint/eslint/issues/14906)) (Milos Djermanovic)




## Bug Fixes


* [`af96584`](https://github.com/eslint/eslint/commit/af965848c010612c3e136c367cc9b9e2e822f580) Fix: handle computed class fields in [operator-linebreak](/docs/rules/operator-linebreak) (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14915](https://github.com/eslint/eslint/issues/14915)) (Milos Djermanovic)
* [`a773b99`](https://github.com/eslint/eslint/commit/a773b99873965652a86bec489193dc42a8923f5f) Fix: [no-useless-computed-key](/docs/rules/no-useless-computed-key) edge cases with class fields (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14903](https://github.com/eslint/eslint/issues/14903)) (Milos Djermanovic)
* [`cbc43da`](https://github.com/eslint/eslint/commit/cbc43daad2ea229fb15a9198efd2bc2721dfb75f) Fix: [prefer-destructuring](/docs/rules/prefer-destructuring) PrivateIdentifier false positive (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14897](https://github.com/eslint/eslint/issues/14897)) (Milos Djermanovic)
* [`ccb9a91`](https://github.com/eslint/eslint/commit/ccb9a9138acd63457e004630475495954c1be6f4) Fix: [dot-notation](/docs/rules/dot-notation) false positive with private identifier (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14898](https://github.com/eslint/eslint/issues/14898)) (Milos Djermanovic)




## Documentation


* [`28fe19c`](https://github.com/eslint/eslint/commit/28fe19c4a9108111932966aa7c9f361c26601d70) Docs: Add v8.0.0 migration guide (fixes [#14856](https://github.com/eslint/eslint/issues/14856)) ([#14884](https://github.com/eslint/eslint/issues/14884)) (Nicholas C. Zakas)
* [`1f5d088`](https://github.com/eslint/eslint/commit/1f5d0889264c60dddb6fb07a3b1e43f840e84d57) Docs: add an example `Object.assign()` for rule [no-import-assign](/docs/rules/no-import-assign) ([#14916](https://github.com/eslint/eslint/issues/14916)) (薛定谔的猫)
* [`c4e5802`](https://github.com/eslint/eslint/commit/c4e58023f22381508babfc52087853b5e3965b9c) Docs: improve rule details for [`no-console`](/docs/rules/no-console) (fixes [#14793](https://github.com/eslint/eslint/issues/14793)) ([#14901](https://github.com/eslint/eslint/issues/14901)) (Nitin Kumar)
* [`5c3a470`](https://github.com/eslint/eslint/commit/5c3a47072aeb5cfda40a1eb20b43a10c5ca7aab3) Docs: add class fields in [no-multi-assign](/docs/rules/no-multi-assign) documentation (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14907](https://github.com/eslint/eslint/issues/14907)) (Milos Djermanovic)
* [`d234d89`](https://github.com/eslint/eslint/commit/d234d890b383837f8e4bda0f6ce1e2a348f9835e) Docs: add class fields in [func-names](/docs/rules/func-names) documentation (refs [#14857](https://github.com/eslint/eslint/issues/14857)) ([#14908](https://github.com/eslint/eslint/issues/14908)) (Milos Djermanovic)
* [`e037d61`](https://github.com/eslint/eslint/commit/e037d61a12ad17a36e05dcf65aa63fad303c79b9) Docs: Mention workaround for escaping the slash character in selectors ([#14675](https://github.com/eslint/eslint/issues/14675)) (Aria)
* [`81f03b6`](https://github.com/eslint/eslint/commit/81f03b6ad69c7f67ad6ba72e02e73266aa8f7696) Docs: Update license copyright ([#14877](https://github.com/eslint/eslint/issues/14877)) (Nicholas C. Zakas)




## Dependency Upgrades


* [`ec9db63`](https://github.com/eslint/eslint/commit/ec9db63e53a6605a558dcd82947d2425f89887c3) Upgrade: @eslint/eslintrc@1.0.0 ([#14865](https://github.com/eslint/eslint/issues/14865)) (Milos Djermanovic)
* [`62c6fe7`](https://github.com/eslint/eslint/commit/62c6fe7d10ff4eeebd196e143f96cfd88818393d) Upgrade: Debug 4.0.1 > 4.3.2 ([#14892](https://github.com/eslint/eslint/issues/14892)) (sandesh bafna)
* [`88db3f5`](https://github.com/eslint/eslint/commit/88db3f54988dddfbda35764ecf1ea16354c4213a) Upgrade: `js-yaml` to v4 ([#14890](https://github.com/eslint/eslint/issues/14890)) (Bryan Mishkin)
* [`ae6072b`](https://github.com/eslint/eslint/commit/ae6072b1de5c8b30ce6c58290852082439c40b30) Upgrade: `eslint-visitor-keys` to v3 ([#14902](https://github.com/eslint/eslint/issues/14902)) (Bryan Mishkin)
* [`e53d8cf`](https://github.com/eslint/eslint/commit/e53d8cf9d73bd105cf6ba4f6b5477ccc4b980939) Upgrade: `markdownlint` dev dependencies ([#14883](https://github.com/eslint/eslint/issues/14883)) (Bryan Mishkin)
* [`d66e941`](https://github.com/eslint/eslint/commit/d66e9414be60e05badb96bc3e1a55ca34636d7f8) Upgrade: @humanwhocodes/config-array to 0.6 ([#14891](https://github.com/eslint/eslint/issues/14891)) (Bryan Mishkin)




## Build Related


* [`b8b2d55`](https://github.com/eslint/eslint/commit/b8b2d5553b0de23e8b72ee45949650cd5f9a10d2) Build: add codeql ([#14729](https://github.com/eslint/eslint/issues/14729)) (薛定谔的猫)




## Chores


* [`be334f9`](https://github.com/eslint/eslint/commit/be334f9d8633e9d193dcb8b36f484547e9d3ab97) Chore: Fix Makefile call to linter.getRules() ([#14932](https://github.com/eslint/eslint/issues/14932)) (Brandon Mills)
* [`0c86b68`](https://github.com/eslint/eslint/commit/0c86b68a6e2435eb03b681b51b099b552b521adc) Chore: Replace old syntax for Array flat/flatMap ([#14614](https://github.com/eslint/eslint/issues/14614)) (Stephen Wade)
* [`6a89f3f`](https://github.com/eslint/eslint/commit/6a89f3f7b6a3edb3465952521bdf06a220515b95) Chore: ignore `yarn-error.log` and `.pnpm-debug.log` ([#14925](https://github.com/eslint/eslint/issues/14925)) (Nitin Kumar)
* [`3b6cd89`](https://github.com/eslint/eslint/commit/3b6cd8934b3640ffb6fa49b471babf07f0ad769a) Chore: Add rel/abs path tests in `no-restricted-{imports/modules}` rules ([#14910](https://github.com/eslint/eslint/issues/14910)) (Bryan Mishkin)
* [`f984515`](https://github.com/eslint/eslint/commit/f98451584a82e41f82ceacd484ea0fe90aa9ce63) Chore: add assertions on reporting location in [`semi`](/docs/rules/semi) ([#14899](https://github.com/eslint/eslint/issues/14899)) (Nitin Kumar)
* [`149230c`](https://github.com/eslint/eslint/commit/149230ce7e296c029a0b6c085216fc0360ed4c65) Chore: Specify Node 14.x for Verify Files CI job ([#14896](https://github.com/eslint/eslint/issues/14896)) (Milos Djermanovic)
* [`537cf6a`](https://github.com/eslint/eslint/commit/537cf6a0e78ee9b7167e7f8c56f4053d3fb5b2d7) Chore: update `glob-parent` (fixes [#14879](https://github.com/eslint/eslint/issues/14879))([#14887](https://github.com/eslint/eslint/issues/14887)) (Nitin Kumar)
* [`f7b4a3f`](https://github.com/eslint/eslint/commit/f7b4a3f6a44e167c71985d373f73eebd3a4d9556) Chore: update dev deps to latest ([#14624](https://github.com/eslint/eslint/issues/14624)) (薛定谔的猫)
