---
layout: post
title: ESLint v7.29.0 released
teaser: "We just pushed ESLint v7.29.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

The `ESLint` class has a new [`getRulesMetaForResults()` method](https://eslint.org/docs/developer-guide/nodejs-api#-eslintgetrulesmetaforresultsresults) that returns `meta` information for rules in lint results. ESLint integrations should migrate to `ESLint#getRulesMetaForResults()` from the `getRules()` method on the deprecated `CLIEngine` class.

`RuleTester` test cases now support an optional `only` boolean property that allows [running a single test case in isolation](https://eslint.org/docs/developer-guide/unit-tests#running-individual-tests) for easier debugging.

## Features


* [`bfbfe5c`](https://github.com/eslint/eslint/commit/bfbfe5c1fd4c39a06d5e159dbe48479ca4305fc0) New: Add only to RuleTester (refs [eslint/rfcs#73](https://github.com/eslint/rfcs/issues/73)) ([#14677](https://github.com/eslint/eslint/issues/14677)) (Brandon Mills)
* [`c2cd7b4`](https://github.com/eslint/eslint/commit/c2cd7b4a18057ca6067bdfc16de771dc5d90c0ea) New: Add ESLint#getRulesMetaForResults() (refs [#13654](https://github.com/eslint/eslint/issues/13654)) ([#14716](https://github.com/eslint/eslint/issues/14716)) (Nicholas C. Zakas)






## Bug Fixes


* [`6a1c7a0`](https://github.com/eslint/eslint/commit/6a1c7a0dac050ea5876972c50563a7eb867b38d3) Fix: allow fallthrough comment inside block (fixes [#14701](https://github.com/eslint/eslint/issues/14701)) ([#14702](https://github.com/eslint/eslint/issues/14702)) (Kevin Gibbons)




## Documentation


* [`a47e5e3`](https://github.com/eslint/eslint/commit/a47e5e30b0da364593b6881f6826c595da8696f5) Docs: Add Mega-Linter to the list of integrations ([#14707](https://github.com/eslint/eslint/issues/14707)) (Nicolas Vuillamy)
* [`c93a222`](https://github.com/eslint/eslint/commit/c93a222563177a9b5bc7a59aa106bc0a6d31e063) Docs: fix a broken link ([#14697](https://github.com/eslint/eslint/issues/14697)) (Sam Chen)








## Chores


* [`eea7e0d`](https://github.com/eslint/eslint/commit/eea7e0d09d6ef43d6663cbe424e7974764a5f7fe) Chore: remove duplicate code ([#14719](https://github.com/eslint/eslint/issues/14719)) (Nitin Kumar)
* [`353ddf9`](https://github.com/eslint/eslint/commit/353ddf965078030794419b089994373e27ffc86e) Chore: enable reportUnusedDisableDirectives in eslint-config-eslint ([#14699](https://github.com/eslint/eslint/issues/14699)) (薛定谔的猫)
* [`757c495`](https://github.com/eslint/eslint/commit/757c49584a5852c468c1b4a0b74ad3aa39d954e5) Chore: add some rules to eslint-config-eslint ([#14692](https://github.com/eslint/eslint/issues/14692)) (薛定谔的猫)
