---
layout: post
title: ESLint v7.28.0 released
teaser: "We just pushed ESLint v7.28.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - mdjermanovic
categories:
  - Release Notes
---

## Highlights

### `context.getPhysicalFilename()`

Rules can now use the new method `getPhysicalFilename()` on the `context` object to get the full path of the file on disk without any code block information.

The difference between `getPhysicalFilename` and `getFilename` is observable when ESLint is used with [processors](/docs/user-guide/configuring/plugins#specifying-processor):

```js
context.getPhysicalFilename() // "/project/example.md"        - original file
context.getFilename()         // "/project/example.md/0_0.js" - virtual filename assigned to a code block
```






## Features


* [`bb66a3d`](https://github.com/eslint/eslint/commit/bb66a3d91af426dac9a7ffdbe47bdbbc0ffd4dd7) New: add `getPhysicalFilename()` method to rule context (fixes [#11989](https://github.com/eslint/eslint/issues/11989)) ([#14616](https://github.com/eslint/eslint/issues/14616)) (Nitin Kumar)




## Enhancements


* [`c545163`](https://github.com/eslint/eslint/commit/c5451635b4e89827cfc8d8d77083647c74506e42) Update: support multiline `/*eslint-env*/` directives (fixes [#14652](https://github.com/eslint/eslint/issues/14652)) ([#14660](https://github.com/eslint/eslint/issues/14660)) (薛定谔的猫)




## Bug Fixes


* [`1f048cb`](https://github.com/eslint/eslint/commit/1f048cb0eec660d2052f1758f4b2ad7b1cb424e1) Fix: [no-implicit-coercion](/docs/rules/no-implicit-coercion) false positive with `String()` (fixes [#14623](https://github.com/eslint/eslint/issues/14623)) ([#14641](https://github.com/eslint/eslint/issues/14641)) (Milos Djermanovic)
* [`e44ce0a`](https://github.com/eslint/eslint/commit/e44ce0a8acfaad513c385150c25e76e82a1b8f12) Fix: [no-duplicate-imports](/docs/rules/no-duplicate-imports) allow unmergeable (fixes [#12758](https://github.com/eslint/eslint/issues/12758), fixes [#12760](https://github.com/eslint/eslint/issues/12760)) ([#14238](https://github.com/eslint/eslint/issues/14238)) (Soufiane Boutahlil)
* [`e4f111b`](https://github.com/eslint/eslint/commit/e4f111b67d114adbf76a9c9dbb18fa4f49bc91b6) Fix: [arrow-body-style](/docs/rules/arrow-body-style) crash with object pattern (fixes [#14633](https://github.com/eslint/eslint/issues/14633)) ([#14635](https://github.com/eslint/eslint/issues/14635)) (Milos Djermanovic)




## Documentation


* [`123fb86`](https://github.com/eslint/eslint/commit/123fb8648731c2c23313c544ffa1872d3024fe68) Docs: Add Feedback Needed triage description ([#14670](https://github.com/eslint/eslint/issues/14670)) (Nicholas C. Zakas)
* [`2e43dac`](https://github.com/eslint/eslint/commit/2e43dacd24337a82d4184fac9b44d497675f46ef) Docs: fix [`no-sequences`](/docs/rules/no-sequences) example ([#14643](https://github.com/eslint/eslint/issues/14643)) (Nitin Kumar)
* [`958ff4e`](https://github.com/eslint/eslint/commit/958ff4e8a5102f204f1484d09985e28a79790996) Docs: add note for arrow functions in no-seq rule ([#14578](https://github.com/eslint/eslint/issues/14578)) (Nitin Kumar)
* [`85a2725`](https://github.com/eslint/eslint/commit/85a2725b1fade5538e727102d9701ccb503e54d4) Docs: Update README team and sponsors (ESLint Jenkins)




## Dependency Upgrades


* [`1237705`](https://github.com/eslint/eslint/commit/1237705dd08c209c5e3136045ec51a4ba87a3abe) Upgrade: @eslint/eslintrc to 0.4.2 ([#14672](https://github.com/eslint/eslint/issues/14672)) (Milos Djermanovic)
* [`8d1e75a`](https://github.com/eslint/eslint/commit/8d1e75a31b3e3d67130709a219bdd07ce6f3cf74) Upgrade: glob-parent version in package.json ([#14658](https://github.com/eslint/eslint/issues/14658)) (Hamza Najeeb)






## Chores


* [`d709abf`](https://github.com/eslint/eslint/commit/d709abfdde087325d4578b6709dc61040b8ca9d8) Chore: fix comment location in [no-unused-vars](/docs/rules/no-unused-vars) ([#14648](https://github.com/eslint/eslint/issues/14648)) (Milos Djermanovic)
* [`ec28b5a`](https://github.com/eslint/eslint/commit/ec28b5a2bdc69f34ce29d670f5e84d2446774a00) Chore: upgrade eslint-plugin-eslint-plugin ([#14590](https://github.com/eslint/eslint/issues/14590)) (薛定谔的猫)


