---
layout: post
title: ESLint v7.20.0 released
teaser: "We just pushed ESLint v7.20.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - mdjermanovic
categories:
  - Release Notes
---

## Highlights


* The [no-unused-expressions](/docs/rules/no-unused-expressions) rule has a new option `enforceForJSX` to flag unused JSX elements.
* The following selectors have been updated to support JSX and custom parsers: `:first-child`, `:last-child`, `:nth-child(n)`, `:nth-last-child(n)`, sibling `~`, and adjacent sibling `+`. All [selectors](/docs/developer-guide/selectors) now support JSX and custom parsers. 







## Enhancements


* [`ad90761`](https://github.com/eslint/eslint/commit/ad9076183bc2c2029525edfc4596e403999348d1) Update: add enforceForJSX option to [no-unused-expressions](/docs/rules/no-unused-expressions) rule ([#14012](https://github.com/eslint/eslint/issues/14012)) (Duncan Beevers)




## Bug Fixes


* [`9d6063a`](https://github.com/eslint/eslint/commit/9d6063add931f0803cae1676d5df307baf114360) Fix: Crash with esquery when using JSX (fixes [#13639](https://github.com/eslint/eslint/issues/13639)) ([#14072](https://github.com/eslint/eslint/issues/14072)) (Yosuke Ota)
* [`d6c84af`](https://github.com/eslint/eslint/commit/d6c84af67318537177ffac0120a81af08e3e9df4) Fix: `--init` autoconfig shouldn't add deprecated rules (fixes [#14017](https://github.com/eslint/eslint/issues/14017)) ([#14060](https://github.com/eslint/eslint/issues/14060)) (Milos Djermanovic)
* [`9b277a1`](https://github.com/eslint/eslint/commit/9b277a16a7261e51b7ba36d6de7f996e9203a6a4) Fix: Support ENOTDIR error code in the folder existence checking utility ([#13973](https://github.com/eslint/eslint/issues/13973)) (Constantine Genchevsky)




## Documentation


* [`f4ac3b0`](https://github.com/eslint/eslint/commit/f4ac3b0e7072fbd3c14e9c64ff0c2c255a4eb730) Docs: fix sibling selector descriptions ([#14099](https://github.com/eslint/eslint/issues/14099)) (Milos Djermanovic)
* [`a0871f1`](https://github.com/eslint/eslint/commit/a0871f1840060bd23cfe0952a096b107142db2f0) Docs: Triage process ([#14014](https://github.com/eslint/eslint/issues/14014)) (Nicholas C. Zakas)
* [`b4e2af5`](https://github.com/eslint/eslint/commit/b4e2af5db1c29343ffec2cd104b04bf39b77ee56) Docs: Add more fields to bug report template ([#14039](https://github.com/eslint/eslint/issues/14039)) (Nicholas C. Zakas)




## Dependency Upgrades


* [`7aeb127`](https://github.com/eslint/eslint/commit/7aeb12798f2b9da706f3593f26a02e717929c9af) Upgrade: pin @babel/code-frame@7.12.11 ([#14067](https://github.com/eslint/eslint/issues/14067)) (Milos Djermanovic)




## Build Related


* [`cb27b0a`](https://github.com/eslint/eslint/commit/cb27b0abeda6dfee55dd43b9cbe12afad321f55d) Build: package.json update for eslint-config-eslint release (ESLint Jenkins)




