---
layout: post
title: ESLint v7.19.0 released
teaser: "We just pushed ESLint v7.19.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

With this release, we're excited to publish our revamped [configuration guide](/docs/user-guide/configuring/).
Technical writer [Khawar Latif Khan](https://github.com/khawarlatifkhan) spent the last several months since our Google Season of Docs [project announcement](/blog/2020/08/eslint-google-season-of-docs-project-writer) digging into and improving what used to be a single dense page.
The [new documentation](/docs/user-guide/configuring/) is logically organized with readability improvements throughout.
Thank you Khawar!

## Enhancements


* [`ce7f061`](https://github.com/eslint/eslint/commit/ce7f06121d9eb9cc2b3da24b4456b4d382e1413b) Update: add shadowed variable loc to message in [no-shadow](/docs/rules/no-shadow) (fixes [#13646](https://github.com/eslint/eslint/issues/13646)) ([#13841](https://github.com/eslint/eslint/issues/13841)) (t-mangoe)
* [`c60e23f`](https://github.com/eslint/eslint/commit/c60e23ff306a14ca6eabcadb275ed27995fcc6e4) Update: fix `let` logic in for-in and for-of loops in [no-extra-parens](/docs/rules/no-extra-parens) ([#14011](https://github.com/eslint/eslint/issues/14011)) (Milos Djermanovic)
* [`1a078b9`](https://github.com/eslint/eslint/commit/1a078b9166f29cb3760435ddbc1a0da4a0974d4a) Update: check ternary `:` even if `?` was reported in [space-infix-ops](/docs/rules/space-infix-ops) ([#13963](https://github.com/eslint/eslint/issues/13963)) (Milos Djermanovic)
* [`1c309eb`](https://github.com/eslint/eslint/commit/1c309ebca4a81a0faf397103dbc621019dea8c9c) Update: fix [no-invalid-regexp](/docs/rules/no-invalid-regexp) false negatives with no flags specified ([#14018](https://github.com/eslint/eslint/issues/14018)) (Milos Djermanovic)




## Bug Fixes


* [`d76e8f6`](https://github.com/eslint/eslint/commit/d76e8f69bd791357c67ada7b5c55608acf29b622) Fix: [no-useless-rename](/docs/rules/no-useless-rename) invalid autofix with parenthesized identifiers ([#14032](https://github.com/eslint/eslint/issues/14032)) (Milos Djermanovic)
* [`e1da90f`](https://github.com/eslint/eslint/commit/e1da90fc414a3c9c16f52db4a5bd81bd4f9532a4) Fix: nested indenting for offsetTernaryExpressions: true (fixes [#13971](https://github.com/eslint/eslint/issues/13971)) ([#13972](https://github.com/eslint/eslint/issues/13972)) (Chris Brody)
* [`fb27422`](https://github.com/eslint/eslint/commit/fb274226242eaebc1480fc9c901202986afc3c8a) Fix: extend [prefer-const](/docs/rules/prefer-const) fixer range to whole declaration (fixes [#13899](https://github.com/eslint/eslint/issues/13899)) ([#14033](https://github.com/eslint/eslint/issues/14033)) (Nitin Kumar)




## Documentation


* [`5800d92`](https://github.com/eslint/eslint/commit/5800d921144ec330b6ee7cd03364434007331354) Docs: Clarify stylistic rule update policy ([#14052](https://github.com/eslint/eslint/issues/14052)) (Brandon Mills)
* [`0ccf6d2`](https://github.com/eslint/eslint/commit/0ccf6d200147437b338cadb34546451972befd75) Docs: remove configuring.md ([#14036](https://github.com/eslint/eslint/issues/14036)) (Milos Djermanovic)
* [`e0b05c7`](https://github.com/eslint/eslint/commit/e0b05c704f3ce6f549d14718236d22fe49fcb611) Docs: add a correct example to [no-unsafe-optional-chaining](/docs/rules/no-unsafe-optional-chaining) (refs [#14029](https://github.com/eslint/eslint/issues/14029)) ([#14050](https://github.com/eslint/eslint/issues/14050)) (armin yahya)
* [`3fc4fa4`](https://github.com/eslint/eslint/commit/3fc4fa485ca9ccd5e16dbc7e53ba31452d22dc4a) Docs: update configuring links ([#14038](https://github.com/eslint/eslint/issues/14038)) (Milos Djermanovic)
* [`8561c21`](https://github.com/eslint/eslint/commit/8561c2116ef89e53ebffb750066f1b00a4acdb76) Docs: fix broken links in configuring/README.md ([#14046](https://github.com/eslint/eslint/issues/14046)) (Milos Djermanovic)
* [`f6602d5`](https://github.com/eslint/eslint/commit/f6602d569427e9e2a4f3b5ca3fc3a8bffb28d15e) Docs: Reorganize Configuration Documentation ([#13837](https://github.com/eslint/eslint/issues/13837)) (klkhan)
* [`a4fdb70`](https://github.com/eslint/eslint/commit/a4fdb7001aa41b9ad8bb92cc8a47b9135c94afc7) Docs: Fixed Typo ([#14007](https://github.com/eslint/eslint/issues/14007)) (Yash Singh)
* [`f7ca481`](https://github.com/eslint/eslint/commit/f7ca48165d025e01c38698352cff24d1de87cc8b) Docs: Explain why we disable lock files (refs [eslint/tsc-meetings#234](https://github.com/eslint/tsc-meetings/issues/234)) ([#14006](https://github.com/eslint/eslint/issues/14006)) (Brandon Mills)








## Chores


* [`65bb0ab`](https://github.com/eslint/eslint/commit/65bb0abde56f72586036fff151aa2d13f1b7be6c) Chore: Clean up new issue workflow ([#14040](https://github.com/eslint/eslint/issues/14040)) (Nicholas C. Zakas)
