---
layout: post
title: ESLint v7.14.0 released
teaser: "We just pushed ESLint v7.14.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - mdjermanovic
categories:
  - Release Notes
---

## Highlights

The [no-nonoctal-decimal-escape](/docs/rules/no-nonoctal-decimal-escape) rule has been added. This rule disallows the use of legacy escape sequences `\8` and `\9` in string literals.







## Features


* [`98c00c4`](https://github.com/eslint/eslint/commit/98c00c41d2aecb3a990393d430694f4ce6b47de5) New: Add [no-nonoctal-decimal-escape](/docs/rules/no-nonoctal-decimal-escape) rule (fixes [#13765](https://github.com/eslint/eslint/issues/13765)) ([#13845](https://github.com/eslint/eslint/issues/13845)) (Milos Djermanovic)




## Enhancements


* [`5f09073`](https://github.com/eslint/eslint/commit/5f0907399a9666dec78c74384c8969c01483c30e) Update: fix 'skip' options in [no-irregular-whitespace](/docs/rules/no-irregular-whitespace) (fixes [#13852](https://github.com/eslint/eslint/issues/13852)) ([#13853](https://github.com/eslint/eslint/issues/13853)) (Milos Djermanovic)




## Bug Fixes


* [`2004b7e`](https://github.com/eslint/eslint/commit/2004b7ecd3db0d4e7376cc3344246f7b9ada5801) Fix: enable debug logs for @eslint/eslintrc (fixes [#13850](https://github.com/eslint/eslint/issues/13850)) ([#13861](https://github.com/eslint/eslint/issues/13861)) (Milos Djermanovic)
* [`d2239a1`](https://github.com/eslint/eslint/commit/d2239a1fdec452e24ede04e990d16d42516fa538) Fix: [no-useless-constructor](/docs/rules/no-useless-constructor) crash on bodyless constructor (fixes [#13830](https://github.com/eslint/eslint/issues/13830)) ([#13842](https://github.com/eslint/eslint/issues/13842)) (Ari Perkkiö)




## Documentation


* [`1861b40`](https://github.com/eslint/eslint/commit/1861b4086f1018f43ab19744d866d5da986c500d) Docs: correct the [function-call-argument-newline](/docs/rules/function-call-argument-newline) 'default' descriptions ([#13866](https://github.com/eslint/eslint/issues/13866)) (Trevin Hofmann)
* [`eda0aa1`](https://github.com/eslint/eslint/commit/eda0aa18498dd85eb618873e8e0f4ac97032cfca) Docs: [no-restricted-imports](/docs/rules/no-restricted-imports) is only for static imports ([#13863](https://github.com/eslint/eslint/issues/13863)) (Robat Williams)
* [`042ae44`](https://github.com/eslint/eslint/commit/042ae44682a8a6c5037d920689124e2304056dd8) Docs: Fix JS syntax and doc URL in working-with-custom-formatters.md ([#13828](https://github.com/eslint/eslint/issues/13828)) (Raphael LANG)








## Chores


* [`95d2fe6`](https://github.com/eslint/eslint/commit/95d2fe6057498fc1cc2193d28c8c2d1593224b33) Chore: remove eslint comment from [no-octal-escape](/docs/rules/no-octal-escape) tests ([#13846](https://github.com/eslint/eslint/issues/13846)) (Milos Djermanovic)
* [`038dc73`](https://github.com/eslint/eslint/commit/038dc73c99ae68eae2035ef303f3a947053c8f05) Chore: Test on Node.js 15 ([#13844](https://github.com/eslint/eslint/issues/13844)) (Brandon Mills)


