---
layout: post
title: 'A year of paying contributors: Review'
teaser: "As part of the goals of the ESLint Collective, we have been paying contributors over the past year. We share the different approaches we tried and their results. We value the time of our contributors and we are continuously finding better ways to reward their work."
tags:
  - Sponsorships
  - Donations
  - Contributors
  - Sustainability
authors:
  - nzakas
categories:
  - Financials
---

It was in February of 2019 that we announced the launch of the [ESLint Collective](https://eslint.org/blog/2019/02/funding-eslint-future) to fund ESLint's ongoing development. One of the primary reasons for seeking funding was due to the increasing amount of time required to maintain a project that, as of today, is downloaded over 13 million times each week. We waited until the last quarter of 2019 before we started paying contributors because we wanted to see what our monthly sponsorships would stabilize at and so we'd have some money saved to guarantee a certain amount would be available to pay contributors. Since then, we've tried a few different approaches with varying degrees of success and failure, and we'd like to share that experience.

## The Technical Steering Committee

The Technical Steering Committee (TSC) is a group of five people who manage the overall direction of the ESLint project. Most of the work that goes into each ESLint release is done by TSC members, including the actual release process itself. Additionally, TSC members review issues and pull requests, as well as representing ESLint at outside events. All that is why we started by figuring out a way to pay TSC members, many of whom have been involved in the project for years prior to ESLint receiving funding.

Here's what we came up with:

* Each TSC member would be paid $50/hour for any contributions to ESLint. Contributions can include actual time working in GitHub, writing code or documentation, attending meetings (both ESLint meetings and external meetings where they represent ESLint), and providing support to the community (over e-mail, chat, etc.).
* Payments are capped at $1,000/month for each member. This cap exists primarily to ensure we are saving some portion of our monthly donations and secondarily to dissuade TSC members from spending too much time on the project in addition to their full time jobs. We don't want to fund burnout.
* Later, we added a split of [Tidelift](https://tidelift.com/funding/github/npm/eslint) funds among the TSC members. We call this the "TSC stipend" and is paid each month to each TSC member regardless of their hourly contributions. The TSC stipend counts towards the $1,000/month limit for each member, and members can invoice the project for the difference between the hours they contributed and the Tidelift amount.

So far, this arrangement has worked exceedingly well. Since starting the TSC payments, we have seen TSC member participation slowly increase. There is something to be said for paying people for valuable work: when the work is explicitly valued, people are more willing to do it. Overall, we would call this part of our program a success.

## Dedicated maintainer

Back in November 2019, we [announced](https://eslint.org/blog/2019/11/funding-update) hiring longtime maintainer Kai Cataldo as a dedicated maintainer. Having recently left his full-time job, Kai wanted to spend more time working on ESLint. We didn't have the budget to pay him a proper full-time salary for his work, so we agreed on 20 hours per week for $5,000/month, with Kai spending the other 20 hours of his week working on other projects or freelancing.

We tried this for a few months before it became apparent that this arrangement wasn't sustainable for Kai. While the payments from ESLint were steady, he had to spend a lot of his other 20 hours each week finding ways to make enough money. So, we updated the arrangement to be for 10 hours each week at $2,500, to give Kai more time to find other work while still providing a baseline amount of dedicated ESLint time.

Unfortunately, that arrangement also did not work. Once again, splitting time between his ESLint duties and trying to find other part-time work proved to be a more difficult task than any of us realized, and this month, Kai decided to step down as a dedicated maintainer. He will remain on the TSC and still be eligible for the TSC member payments.

This was a difficult thing for the team to work through, and we think there's an important lesson about open source sustainability: even though we receive donations, ESLint doesn't bring in enough to pay maintainers full-time. When that happens, maintainers face a difficult decision: we can try to make part-time development work, but it's hard to find other part-time work to make up the monthly income we need to make it worthwhile. In some cases, doing the part-time work makes it more difficult to find other work because you are time-constrained in a way that other freelancers are not.

We are currently rethinking how (and if) we'd like to pursue dedicated maintainers in the future given Kai's experience.

## Other Experiments

Along with the TSC payments and hiring a dedicated maintainer, we've also tried several other things to distribute payments to more contributors. Our ultimate goal is to be able to pay most, if not all, contributors to ESLint because all contributions are helpful. We still haven't thought through the details of how this will work, but we have tried several other experiments:

1. For v7.0.0, we decided to give one-time payments of $250 to several contributors who made outsized contributions to the release. The contributors were both surprised and happy, but we also learned that there are some countries where regulations are very strict regarding what we in the United States call self-employment income. Not everyone was able to participate because of this.
1. Longtime contributor Kevin Partington had started spending a lot of time helping out community members in our [Discord](https://eslint.org/chat), and to thank him for that, we started paying him $25/hour for any amount of help he provides. If you've ever stopped by our Discord and asked for help, there's a good chance Kevin is the one who helped you out.

## Wrapping up

Overall, we are always on the lookout for meaningful and impactful contributions to ESLint so we can reward pay people for those contributions. We will continue to experiment with paying contributors in different ways going forward as we look for ways to make ESLint sustainable for the foreseeable future.

Not everything we tried has worked out, nor did we expect it to, but we firmly believe that it's worth continuing to work on this problem. Maintaining a project like ESLint takes a lot of work and a lot of contributions from a lot of people. The only way for that to continue is to pay people for their time.
