---
layout: post
title: Supporting ESLint's dependencies
teaser: "As part of our goal for open source sustainability, we are happy to announce that we're starting to support ESLint's dependencies. We're grateful to the projects upon which ESLint is built and we want to share our success with them. Thanks to our sponsors, we're able to help them, and we hope to extend this to more dependencies."
tags:
  - Sponsorships
  - Donations
  - Dependencies
authors:
  - nzakas
categories:
  - Financials
---

When ESLint first started accepting donations, it was with the explicit goal of creating a sustainable future for the project. In the short term, that meant ensuring we could compensate those who spent a significant amount of time on the project, but we always intended that to be a starting point and not an end. There is so much more that goes into open source sustainability and we wanted to be mindful of that as we continued to grow. That's why we're excited to announce that we're now supporting several of the projects that ESLint itself is built upon.

Sponsors choose to support ESLint because they have come to depend on ESLint, and as such, want to ensure that the project continues. Similarly, ESLint is built on top of smaller open source projects, and we feel like it is our responsibility to also help those projects thrive. We're grateful to our sponsors for helping us get to 50% of our $20,000/month goal, and we feel that it's time to spread some of that success to our dependencies. As such, we've budgeted part of our donations for our dependencies.

Today we are happy to announce that we've started donating $100/month to each of the following projects (and one person):

* [Ajv](https://npmjs.com/package/ajv) is a JSON schema validator that ESLint uses to validate configuration.
* [Eleventy](https://www.11ty.dev/) is a Node.js-based static site generator that we use to create [eslint.org](http://eslint.org).
* [Sindre Sorhus](https://sindresorhus.com/) is a prolific open source developer, and ESLint uses several of his modules, including [`chalk`](https://npmjs.com/package/chalk), [`globals`](https://npmjs.com/package/globals), [`import-fresh`](https://npmjs.com/package/import-fresh), [`strip-ansi`](https://npmjs.com/package/strip-ansi), and [`strip-json-comments`](https://npmjs.com/package/strip-json-comments).

We're grateful to these projects, and all of our dependencies, for allowing us to build ESLint.

And this is just the start. As our donations continue to grow, we anticipate being able to support more of our dependencies in the future. We envision a future where donations to large open source projects trickle down into their dependencies so the entire open source ecosystem can benefit.
