---
layout: post
title: ESLint v7.8.0 released
teaser: "We just pushed ESLint v7.8.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---


## Highlights

Support for [logical assignment operators](https://github.com/tc39/proposal-logical-assignment) and [numeric separators](https://github.com/tc39/proposal-numeric-separator) has landed in ESLint! To enable linting this syntax, please set `ecmaVersion` to `2021`:

```json
{
    "parserOptions": {
        "ecmaVersion": 2021
    }
}
```

## Enhancements


* [`58abd93`](https://github.com/eslint/eslint/commit/58abd9311900a8af5a3c0963daaf64675bdd8383) Update: support logical assignments in code path analysis (refs [#13569](https://github.com/eslint/eslint/issues/13569)) ([#13612](https://github.com/eslint/eslint/issues/13612)) (Milos Djermanovic)
* [`db7488e`](https://github.com/eslint/eslint/commit/db7488e6326fd1b7ea04c5062beb1c5f75fc15ed) Update: support logical assignments in core rules (refs [#13569](https://github.com/eslint/eslint/issues/13569)) ([#13618](https://github.com/eslint/eslint/issues/13618)) (Milos Djermanovic)
* [`88a9ade`](https://github.com/eslint/eslint/commit/88a9ade7643bb166efbab45cee15f3269496f4be) Update: add es2021 environment (refs [#13602](https://github.com/eslint/eslint/issues/13602)) ([#13603](https://github.com/eslint/eslint/issues/13603)) (Milos Djermanovic)
* [`0003dc0`](https://github.com/eslint/eslint/commit/0003dc0f966f2b47555595586f84eb3163cb0179) Update: support numeric separators (refs [#13568](https://github.com/eslint/eslint/issues/13568)) ([#13581](https://github.com/eslint/eslint/issues/13581)) (Milos Djermanovic)
* [`96b11a0`](https://github.com/eslint/eslint/commit/96b11a0717bf32b94ec768611574372320fb774b) Update: Add exceptionPatterns to [id-length](/docs/rules/id-length) rule (fixes [#13094](https://github.com/eslint/eslint/issues/13094)) ([#13576](https://github.com/eslint/eslint/issues/13576)) (sodam)
* [`3439fea`](https://github.com/eslint/eslint/commit/3439fea5c0ed330d01d874b0c9df51dd51ae792c) Update: support numeric-separator in [no-loss-of-precision](/docs/rules/no-loss-of-precision) (refs [#13568](https://github.com/eslint/eslint/issues/13568)) ([#13574](https://github.com/eslint/eslint/issues/13574)) (Anix)
* [`ed64767`](https://github.com/eslint/eslint/commit/ed64767859d776145d68145419a61f5379b4dd63) Update: add comment to message in [no-warning-comments](/docs/rules/no-warning-comments) (fixes [#12327](https://github.com/eslint/eslint/issues/12327)) ([#13522](https://github.com/eslint/eslint/issues/13522)) (Anix)
* [`66442a9`](https://github.com/eslint/eslint/commit/66442a9faf9872db4a40f56dde28c48f4d02fc7b) Update: Add [no-magic-numbers](/docs/rules/no-magic-numbers) 'ignoreDefaultValues' option ([#12611](https://github.com/eslint/eslint/issues/12611)) (Dieter Luypaert)






## Documentation


* [`3729219`](https://github.com/eslint/eslint/commit/372921924778f2e525535985e17c97b988546210) Docs: Update Step 1 of Development Environment documentation (klkhan)
* [`483bf7f`](https://github.com/eslint/eslint/commit/483bf7f3cc40e0d866798d6ca9ee1c19aa77ddd2) Docs: fix examples in [object-curly-newline](/docs/rules/object-curly-newline) ([#13605](https://github.com/eslint/eslint/issues/13605)) (Soobin Bak)
* [`1c35d57`](https://github.com/eslint/eslint/commit/1c35d57b0a5f374cc55f1727a7561bcab1962e83) Docs: Remove stale Keybase 2FA instructions ([#13622](https://github.com/eslint/eslint/issues/13622)) (Brandon Mills)
* [`4111d21`](https://github.com/eslint/eslint/commit/4111d21a046b73892e2c84f92815a21ef4db63e1) Docs: Fix typo and missing article before noun in docs ([#13611](https://github.com/eslint/eslint/issues/13611)) (Patrice Sandhu)
* [`b487164`](https://github.com/eslint/eslint/commit/b487164d01dd0bf66fdf2df0e374ce1c3bdb0339) Docs: add exponentiation operators to [operator-assignment](/docs/rules/operator-assignment) documentation ([#13577](https://github.com/eslint/eslint/issues/13577)) (Milos Djermanovic)




## Dependency Upgrades


* [`091e52a`](https://github.com/eslint/eslint/commit/091e52ae1ca408f3e668f394c14d214c9ce806e6) Upgrade: espree@7.3.0 (refs [#13568](https://github.com/eslint/eslint/issues/13568)) ([#13609](https://github.com/eslint/eslint/issues/13609)) (Kai Cataldo)






## Chores


* [`a320324`](https://github.com/eslint/eslint/commit/a32032430a0779a4e3b2d137d4d0682844084b82) Chore: Test formatted integers in [no-dupe-keys](/docs/rules/no-dupe-keys) (refs [#13568](https://github.com/eslint/eslint/issues/13568)) ([#13626](https://github.com/eslint/eslint/issues/13626)) (Brandon Mills)
* [`82669fa`](https://github.com/eslint/eslint/commit/82669fa66670a00988db5b1d10fe8f3bf30be84e) Chore: Extract some functionality to eslintrc (refs [#13481](https://github.com/eslint/eslint/issues/13481)) ([#13613](https://github.com/eslint/eslint/issues/13613)) (Nicholas C. Zakas)
* [`bdb65ec`](https://github.com/eslint/eslint/commit/bdb65ec2e672c9815bee356b61d1cd60a1072152) Chore: add 3rd party parsers in BUG_REPORT template ([#13606](https://github.com/eslint/eslint/issues/13606)) (YeonJuan)
* [`f954476`](https://github.com/eslint/eslint/commit/f954476fb6b0664679c73babd5e8a0647572b81f) Chore: add common 3rd party parsers to issue template ([#13596](https://github.com/eslint/eslint/issues/13596)) (Kai Cataldo)
* [`2bee6d2`](https://github.com/eslint/eslint/commit/2bee6d256ae0516c9a9003bb3fdca24ff93253b5) Chore: Mark config-related files (refs [#13481](https://github.com/eslint/eslint/issues/13481)) ([#13597](https://github.com/eslint/eslint/issues/13597)) (Nicholas C. Zakas)


