---
layout: post
title: Introducing the ESLint Google Season of Docs project and technical writer
teaser: "We are happy to announce that ESLint was accepted into the Google Season of Docs program. It is with pleasure that we introduce our technical writer for 2020, Khawar Latif Khan. We are looking forward to working with him on his proposed project for our configuration documentation."
tags:
  - Google Season of Docs
  - Technical Writing
authors:
  - nzakas
categories:
  - Announcements
---

This year, ESLint was accepted into the Google Season of Docs (GSoD) program for the first time (thanks, in large part, to our [sponsors](https://opencollective.com/eslint)). The ESLint team has always placed a high value on quality documentation for the project and we came up with a [list of projects](https://github.com/eslint/eslint/issues/13130#issuecomment-614916040) that we thought could improve our documentation. We received more than 20 applications through GSoD, and after a lot of time grading and reviewing applications, we finally ended up with our technical writer!

It's our pleasure to introduce Khawar Latif Khan, the 2020 ESLint GSoD technical writer. Here's a little about Khawar, straight from him:
	
> I am an engineer turned communications specialist from Pakistan, with a passion to create helpful and understandable content. I have a graduate degree in Technical and Professional Communication from North Carolina State University, under the Fulbright Scholarship. During and after my undergraduate degree in Electrical Engineering, I got interested in communicating complex technical knowledge to people in simple terms, an area which most Engineering programs do not pay attention to. This drove me to change my major and serve as a bridge between the creators and the audience of technical information, both interacting with the same content but with different goals.

What interested Khawar in ESLint:

> Despite the fact that I have been using open-source software for quite some time, my familiarity with the term is fairly new, similar to my knowledge of linting software. When I started learning Python (through edX), I did wonder how tiny errors can mess the whole code up. I thought it would be nice to have your codes tested, somehow, and get your errors identified, and then I came to know about the term "linting." I haven't aptly used linting software yet but I’m sure these will make my life a lot easier in the days to come.
>
> Working with ESLint will not only help me pursue my interests but also strengthen my connection with my engineering knowledge and technical background. My proposed project for ESLint, to reorganize/rewrite the configuration documentation, will focus on conducting a comprehensive content audit, improving the information architecture, and to make the content both useful and reusable. With the guidance of experienced personnel working at ESLint and a collaborative environment, I believe, will add great value to the documentation of ESLint.

Khawar submitted a proposal for reorganizing and rewriting our [configuration documentation](https://eslint.org/docs/user-guide/configuring), which right now contains a lot of information without a lot of structure. His proposal included a comprehensive plan for addressing the documentation, separated into these steps:

- Conducting a comprehensive content audit
- Create an Information Architecture to understand the flow of information
- Improve the Information Architecture to reorganize the documentation
- Identify links and references between different sections of the content
- Rewrite/Edit parts of the documentation, if necessary to meet the reconfiguration requirements
- Ensure the content is flexible and reusable

This proposal contained pages of information related to how each step will progress and how long each step is anticipated to take. This level of detail made us feel comfortable that Khawar understood the project's goals and the amount of work involved.

Khawar's ESLint mentor will be Kai Cataldo. Kai is ESLint's first paid dedicated maintainer, and having his time available is what allowed us to participate in GSoD this year. (Just one of the ways in which your [donations](https://opencollective.com/eslint) benefit the project.) Kai will work directly with Khawar to get him up to speed on the project and guide him through the process of updating the configuration documentation.

We are very excited to be participating in GSoD for the first time and grateful to Khawar for taking this project on. Hopefully, this won't be the last time the ESLint project is able to participate in GSoD and we look forward to sharing the results of this year's project in the future.
