---
layout: post
title: ESLint v7.7.0 released
teaser: "We just pushed ESLint v7.7.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

In [ESLint v7.3.0](https://eslint.org/blog/2020/06/eslint-v7.3.0-released), we released a change to the `comma-dangle` rule that [disallowed having multiple options in the rule's configuration](https://github.com/eslint/eslint/pull/13166). Our semantic versioning policy allows for changes that may introduce new errors in semver-minor releases if the change is considered a bug fix and, at the time, we decided that this change fell under that category. After discussing internally whether this was the correct application of our policy or not, we have decided to [update our semantic versioning policy](https://github.com/eslint/eslint/pull/13563) to include rule schemas as part of the public API and to revert this change in this release.




## Enhancements


* [`b46f3ee`](https://github.com/eslint/eslint/commit/b46f3ee0dae4add9df99cae940b641ad8de58b9e) Update: allowFunctionParams option in [no-underscore-dangle](/docs/rules/no-underscore-dangle) (fixes 12579) ([#13545](https://github.com/eslint/eslint/issues/13545)) (Sunghyun Cho)




## Bug Fixes


* [`4e0b672`](https://github.com/eslint/eslint/commit/4e0b672eb4bf39f7502a550b08b25a56a196f19f) Fix: revert "Update: disallow multiple options in [comma-dangle](/docs/rules/comma-dangle) schema" ([#13564](https://github.com/eslint/eslint/issues/13564)) (Kai Cataldo)
* [`254990e`](https://github.com/eslint/eslint/commit/254990e87914457ca25ea2d7ee012964e56fc9e5) Fix: [indent](/docs/rules/indent) for async arrow functions (fixes [#13497](https://github.com/eslint/eslint/issues/13497)) ([#13544](https://github.com/eslint/eslint/issues/13544)) (Anix)




## Documentation


* [`26aa245`](https://github.com/eslint/eslint/commit/26aa2452b5f407fabc25dad21182180e4d3be532) Docs: clarify "case" specifier in [padding-line-between-statements](/docs/rules/padding-line-between-statements) ([#13562](https://github.com/eslint/eslint/issues/13562)) (Milos Djermanovic)
* [`082891c`](https://github.com/eslint/eslint/commit/082891c042d72953fe86cd3ce9c96e661760793d) Docs: Update semantic versioning policy ([#13563](https://github.com/eslint/eslint/issues/13563)) (Nicholas C. Zakas)








## Chores


* [`9124a15`](https://github.com/eslint/eslint/commit/9124a1599638a1caf4b7e252d1cb66abdc5e51c6) Chore: remove leche (fixes [#13287](https://github.com/eslint/eslint/issues/13287)) ([#13533](https://github.com/eslint/eslint/issues/13533)) (Mark de Dios)


