---
layout: post
title: ESLint v7.6.0 released
teaser: "We just pushed ESLint v7.6.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

### `RuleTester` requires `meta.fixable` for fixable rules

Fixable rules are required to have a `meta.fixable` property. A bug in the `RuleTester` class (which is intended to help plugin authors write and test custom rules) was recently surfaced in which fixable rules that do not export metadata (the `meta` property) are not validated for the existence of a `meta.fixable` property, while rules that do export `meta` are.

This has been fixed in this release! Unfortunately, this can lead to new errors being reported by the `RuleTester` for rules that apply fixes and are missing a `meta` property. Please feel free to stop by our [help channel](https://eslint.org/chat/help) if you need assistance resolving this issue.




## Enhancements


* [`ecb2b73`](https://github.com/eslint/eslint/commit/ecb2b7343a0d14fb57d297a16be6c1b176fb3dbf) Update: require `meta` for fixable rules in RuleTester (refs [#13349](https://github.com/eslint/eslint/issues/13349)) ([#13489](https://github.com/eslint/eslint/issues/13489)) (Milos Djermanovic)
* [`e71e298`](https://github.com/eslint/eslint/commit/e71e2980cd2e319afc70d8c859c7ffd59cf4157b) Update: Change [no-duplicate-case](/docs/rules/no-duplicate-case) to comparing tokens (fixes [#13485](https://github.com/eslint/eslint/issues/13485)) ([#13494](https://github.com/eslint/eslint/issues/13494)) (Yosuke Ota)




## Bug Fixes


* [`318fe10`](https://github.com/eslint/eslint/commit/318fe103dbf2548eee293ff456ef0b829dbe3db3) Fix: Do not output `undefined` as line and column when it's unavailable ([#13519](https://github.com/eslint/eslint/issues/13519)) (haya14busa)
* [`16b10fe`](https://github.com/eslint/eslint/commit/16b10fe8ba3c78939d5ada4a25caf2f0c9e6a058) Fix: Update the chatroom link to go directly to help channel ([#13536](https://github.com/eslint/eslint/issues/13536)) (Nicholas C. Zakas)




## Documentation


* [`6fb4edd`](https://github.com/eslint/eslint/commit/6fb4edde3b7a7ae2faf8ac956a7342fbf80865fc) Docs: fix broken links in developer guide ([#13518](https://github.com/eslint/eslint/issues/13518)) (Sam Chen)
* [`6c4aea4`](https://github.com/eslint/eslint/commit/6c4aea44fd78e1eecea5fe3c37e1921e3b1e98a6) Docs: add ECMAScript 2020 to README ([#13510](https://github.com/eslint/eslint/issues/13510)) (Milos Djermanovic)
