---
layout: post
title: ESLint v7.5.0 released
teaser: "We just pushed ESLint v7.5.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

### Optional Chaining Support

Support for [optional chaining](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Optional_chaining) has landed in ESLint!

```js
const maybeProp = obj.first?.second;
```

The default parser and built-in rules will support this syntax when you enable `parserOptions.ecmaVersion: 2020` in your configuration:

```json
{
    "parserOptions": {
        "ecmaVersion": 2020
    }
}
```

### Deprecating `id-blacklist`

`id-blacklist` has been deprecated and replaced with `id-denylist`. We renamed `id-blacklist` to `id-denylist` in the previous release ([v7.4.0](/blog/2020/07/eslint-v7.4.0-released)), which unfortunately led to some unintended breakages in the ESLint ecosystem. In this release, we have added back the `id-blacklist` rule and have marked it as deprecated. If you are currently using `id-blacklist`, we recommend switching to `id-denylist` to ensure you receive bug fixes and updates to the rule in future releases.


## Enhancements


* [`6ea3178`](https://github.com/eslint/eslint/commit/6ea3178776eae0e40c3f5498893e8aab0e23686b) Update: optional chaining support (fixes [#12642](https://github.com/eslint/eslint/issues/12642)) ([#13416](https://github.com/eslint/eslint/issues/13416)) (Toru Nagashima)
* [`f4d7b9e`](https://github.com/eslint/eslint/commit/f4d7b9e1a599346b2f21ff9de003b311b51411e6) Update: deprecate [id-blacklist](/docs/rules/id-blacklist) rule ([#13465](https://github.com/eslint/eslint/issues/13465)) (Dimitri Mitropoulos)
* [`c8f9c82`](https://github.com/eslint/eslint/commit/c8f9c8210cf4b9da8f07922093d7b219abad9f10) Update: Improve report location [no-irregular-whitespace](/docs/rules/no-irregular-whitespace) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13462](https://github.com/eslint/eslint/issues/13462)) (Milos Djermanovic)
* [`0af1d28`](https://github.com/eslint/eslint/commit/0af1d2828d27885483737867653ba1659af72005) Update: add allowSeparatedGroups option to [sort-imports](/docs/rules/sort-imports) (fixes [#12951](https://github.com/eslint/eslint/issues/12951)) ([#13455](https://github.com/eslint/eslint/issues/13455)) (Milos Djermanovic)
* [`1050ee7`](https://github.com/eslint/eslint/commit/1050ee78a95da9484ff333dc1c74dac64c05da6f) Update: Improve report location for [no-unneeded-ternary](/docs/rules/no-unneeded-ternary) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13456](https://github.com/eslint/eslint/issues/13456)) (Milos Djermanovic)
* [`b77b420`](https://github.com/eslint/eslint/commit/b77b4202bd1d5d1306f6f645e88d7a41a51715db) Update: Improve report location for [max-len](/docs/rules/max-len) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13458](https://github.com/eslint/eslint/issues/13458)) (Milos Djermanovic)




## Bug Fixes


* [`a96bc5e`](https://github.com/eslint/eslint/commit/a96bc5ec06f3a48bfe458bccd68d4d3b2a280ed9) Fix: [arrow-body-style](/docs/rules/arrow-body-style) fixer for `in` wrap (fixes [#11849](https://github.com/eslint/eslint/issues/11849)) ([#13228](https://github.com/eslint/eslint/issues/13228)) (Anix)
* [`095194c`](https://github.com/eslint/eslint/commit/095194c0fc0eb02aa69fde6b4280696e0e4de214) Fix: add end location to reports in [object-curly-newline](/docs/rules/object-curly-newline) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13460](https://github.com/eslint/eslint/issues/13460)) (Milos Djermanovic)
* [`10251bb`](https://github.com/eslint/eslint/commit/10251bbaeba80ac15244f385fc42cf2f2a30e5d2) Fix: add end location to reports in [keyword-spacing](/docs/rules/keyword-spacing) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13461](https://github.com/eslint/eslint/issues/13461)) (Milos Djermanovic)




## Documentation


* [`885a145`](https://github.com/eslint/eslint/commit/885a1455691265db88dc0befe9b48a69d69e8b9c) Docs: clarify behavior if `meta.fixable` is omitted (refs [#13349](https://github.com/eslint/eslint/issues/13349)) ([#13493](https://github.com/eslint/eslint/issues/13493)) (Milos Djermanovic)
* [`1a01b42`](https://github.com/eslint/eslint/commit/1a01b420eaab0de03dab5cc190a9f2a860c21a84) Docs: Update technology sponsors in README ([#13478](https://github.com/eslint/eslint/issues/13478)) (Nicholas C. Zakas)
* [`f1cc725`](https://github.com/eslint/eslint/commit/f1cc725ba1b8646dcf06a83716d96ad9bb726172) Docs: fix linebreaks between versions in changelog ([#13488](https://github.com/eslint/eslint/issues/13488)) (Milos Djermanovic)
* [`61097fe`](https://github.com/eslint/eslint/commit/61097fe5cc275d414a0c8e19b31c6060cb5568b7) Docs: Update int rule level to string ([#13483](https://github.com/eslint/eslint/issues/13483)) (Brandon Mills)
* [`e951457`](https://github.com/eslint/eslint/commit/e951457b7aaa1b12b135588d36e3f4db4d7b8463) Docs: fix wording in configuring.md ([#13469](https://github.com/eslint/eslint/issues/13469)) (Piper)




## Dependency Upgrades


* [`6ed9e8e`](https://github.com/eslint/eslint/commit/6ed9e8e4ff038c0259b0e7fe7ab7f4fd4ec55801) Upgrade: lodash@4.17.19 ([#13499](https://github.com/eslint/eslint/issues/13499)) (Yohan Siguret)
* [`748734f`](https://github.com/eslint/eslint/commit/748734fdd497fbf61f3a616ff4a09169135b9396) Upgrade: Updated puppeteer version to v4.0.0 ([#13444](https://github.com/eslint/eslint/issues/13444)) (odidev)




## Build Related


* [`f2e68ec`](https://github.com/eslint/eslint/commit/f2e68ec1d6cee6299e8a5cdf76c522c11d3008dd) Build: update webpack resolve.mainFields to match website config ([#13457](https://github.com/eslint/eslint/issues/13457)) (Milos Djermanovic)




## Chores


* [`540b1af`](https://github.com/eslint/eslint/commit/540b1af77278ae649b621aa8d4bf8d6de03c3155) Chore: enable consistent-meta-messages internal rule ([#13487](https://github.com/eslint/eslint/issues/13487)) (Milos Djermanovic)
* [`e14a645`](https://github.com/eslint/eslint/commit/e14a645aa495558081490f990ba221e21aa6b27c) Chore: use espree.latestEcmaVersion in fuzzer ([#13484](https://github.com/eslint/eslint/issues/13484)) (Milos Djermanovic)
