---
layout: post
title: ESLint v7.4.0 released
teaser: "We just pushed ESLint v7.4.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

Shortly after the v7.3.0 release, we received [an issue](https://github.com/eslint/eslint/issues/13427) that [`eslint-config-airbnb` was breaking](https://github.com/airbnb/javascript/issues/2245) because it used `Infinity` in a rule config. `Infinity` should have been forbidden by the [rule's option schema](https://github.com/benmosher/eslint-plugin-import/blob/296262842b52a50c5b107ba91bb2d13c05b2a104/src/rules/no-cycle.js#L17-L21), but [a bug](https://github.com/ajv-validator/ajv/issues/182) in Ajv, the JSON schema validator that ESLint uses, incorrectly allowed `Infinity` when an `integer` was specified. This was finally caught because the v7.3.0 release included [a change](https://github.com/eslint/eslint/pull/13034) that fixed [an unrelated issue](https://github.com/eslint/eslint/issues/12592) by serializing rule configs. ESLint expects rule configs to be JSON-serializable for consistency between all supported JSON, YAML, and JS `.eslintrc` formats, and it relies on this property in the `--cache` and `--print-config` command line options.

Updating `eslint-config-airbnb` to use `Number.MAX_SAFE_INTEGER` instead of `Infinity` is the [ideal solution](https://github.com/eslint/eslint/issues/13427#issuecomment-647733750) but would have taken too long. Since this was the only reported issue and isolated to `eslint-config-airbnb` rather than end-user configs, we [implemented an exception](https://github.com/eslint/eslint/pull/13435) that replaced `Infinity` with `Number.MAX_SAFE_INTEGER` and released it in v7.3.1, which allowed us to preserve the unrelated bug fix.

After the v7.3.1 release, we received [another issue](https://github.com/eslint/eslint/issues/13447) that [an `eslint-plugin-unicorn` rule](https://github.com/sindresorhus/eslint-plugin-unicorn/blob/6c02ce4e32c84702bcd06e90aa91696366036294/docs/rules/filename-case.md#ignore) was directing users to use regular expression instances, which are not JSON-serializable. Unlike `eslint-config-airbnb`, where the non-serializable value was isolated to a single dependency, end user configs for `eslint-plugin-unicorn` include regular expressions, so fixing all of them is not practical.

We're therefore [reverting the original change](https://github.com/eslint/eslint/pull/13449) for the v7.4.0 release and will be finding another solution. This will unblock regular linting for users whose rule configs include non-JSON-serializable values, though the `--cache` and `--print-config` command line options may exhibit undefined behavior in those cases. A future major version of ESLint will enforce that rule configs contain only JSON-serializable values, and we anticipate that enhancements to `RuleTester` will help rule authors prepare their schemas for that.

## Enhancements

* [`ff5317e`](https://github.com/eslint/eslint/commit/ff5317e93425f93cfdf808609551ee67b2032543) Update: Improve [array-callback-return](/docs/rules/array-callback-return) report message ([#13395](https://github.com/eslint/eslint/issues/13395)) (Philip (flip) Kromer)
* [`51e42ec`](https://github.com/eslint/eslint/commit/51e42eca3e87d8259815d736ffe81e604f184057) Update: Add option "ignoreGlobals" to [camelcase](/docs/rules/camelcase) rule (fixes [#11716](https://github.com/eslint/eslint/issues/11716)) ([#12782](https://github.com/eslint/eslint/issues/12782)) (David Gasperoni)
* [`0655f66`](https://github.com/eslint/eslint/commit/0655f66525d167ca1288167b79a77087cfc8fcf6) Update: improve report location in [arrow-body-style](/docs/rules/arrow-body-style) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13424](https://github.com/eslint/eslint/issues/13424)) (YeonJuan)
* [`d53d69a`](https://github.com/eslint/eslint/commit/d53d69af08cfe55f42e0a0ca725b1014dabccc21) Update: prefer-regex-literal detect regex literals (fixes [#12840](https://github.com/eslint/eslint/issues/12840)) ([#12842](https://github.com/eslint/eslint/issues/12842)) (Mathias Schreck)
* [`004adae`](https://github.com/eslint/eslint/commit/004adae3f959414f56e44e5884f6221e9dcda142) Update: rename id-blacklist to [id-denylist](/docs/rules/id-denylist) (fixes [#13407](https://github.com/eslint/eslint/issues/13407)) ([#13408](https://github.com/eslint/eslint/issues/13408)) (Kai Cataldo)




## Bug Fixes


* [`ada2c89`](https://github.com/eslint/eslint/commit/ada2c891298382f82dfabf37cacd59a1057b2bb7) Fix: support typescript generics in [arrow-parens](/docs/rules/arrow-parens) (fixes [#12570](https://github.com/eslint/eslint/issues/12570)) ([#13451](https://github.com/eslint/eslint/issues/13451)) (Milos Djermanovic)
* [`89ee01e`](https://github.com/eslint/eslint/commit/89ee01e083f1e02293bf8d1447f9b0fdb3cb9384) Fix: Revert config cloning (fixes [#13447](https://github.com/eslint/eslint/issues/13447)) ([#13449](https://github.com/eslint/eslint/issues/13449)) (薛定谔的猫)
* [`3f51930`](https://github.com/eslint/eslint/commit/3f51930eea7cddc921a9ee3cb0328c7b649c0f83) Fix: false positive new with member in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#12740](https://github.com/eslint/eslint/issues/12740)) ([#13375](https://github.com/eslint/eslint/issues/13375)) (YeonJuan)
* [`825a5b9`](https://github.com/eslint/eslint/commit/825a5b98d3d84f6eb72b75f7d8519de763cc8898) Fix: Clarify documentation on implicit ignore behavior (fixes [#12348](https://github.com/eslint/eslint/issues/12348)) ([#12600](https://github.com/eslint/eslint/issues/12600)) (Scott Hardin)




## Documentation


* [`f21bad2`](https://github.com/eslint/eslint/commit/f21bad2680406a2671b877f8dba47f4475d0cc64) Docs: fix description for `never` in [multiline-ternary](/docs/rules/multiline-ternary) (fixes [#13368](https://github.com/eslint/eslint/issues/13368)) ([#13452](https://github.com/eslint/eslint/issues/13452)) (Milos Djermanovic)
* [`0a463db`](https://github.com/eslint/eslint/commit/0a463dbf7cc5a77d442879c9117204d4d38db972) Docs: fix [no-multiple-empty-lines](/docs/rules/no-multiple-empty-lines) examples (fixes [#13432](https://github.com/eslint/eslint/issues/13432)) ([#13433](https://github.com/eslint/eslint/issues/13433)) (Milos Djermanovic)
