---
layout: post
title: ESLint v7.2.0 released
teaser: "We just pushed ESLint v7.2.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

ECMAScript 2020 syntax support has landed in ESLint! This release adds support for the following language features in the default parser and core rules:

* [Nullish coalescing operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Nullish_coalescing_operator)
* `export * as ns from "source"`
* [`import.meta`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import.meta)

Note: We are aware that optional chaining support is still missing. If you're interested in following the process of implementing support for this syntax, please subscribe to [this ESTree issue](https://github.com/estree/estree/pull/204).








## Enhancements


* [`b735a48`](https://github.com/eslint/eslint/commit/b735a485e77bcc791e4c4c6b8716801d94e98b2c) Update: add enforceForFunctionPrototypeMethods option to [no-extra-parens](/docs/rules/no-extra-parens) ([#12895](https://github.com/eslint/eslint/issues/12895)) (Milos Djermanovic)
* [`27ef73f`](https://github.com/eslint/eslint/commit/27ef73ffb7428d5eff792d443186a2313e417bda) Update: reporter locr of [func-call-spacing](/docs/rules/func-call-spacing) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13311](https://github.com/eslint/eslint/issues/13311)) (Anix)
* [`353bfe9`](https://github.com/eslint/eslint/commit/353bfe9760ec640f470859855d4018df084a4e88) Update: handle parentheses in [multiline-ternary](/docs/rules/multiline-ternary) (fixes [#13195](https://github.com/eslint/eslint/issues/13195)) ([#13367](https://github.com/eslint/eslint/issues/13367)) (Milos Djermanovic)
* [`a7fd343`](https://github.com/eslint/eslint/commit/a7fd343991cde99d8a219e3b25616db5792fe9a9) Update: [keyword-spacing](/docs/rules/keyword-spacing) unexpected space loc improve (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13377](https://github.com/eslint/eslint/issues/13377)) (Anix)
* [`dd949ae`](https://github.com/eslint/eslint/commit/dd949aedb81fa772e10568920156daf075d25ea2) Update: support `??` operator, import.meta, and `export * as ns` ([#13196](https://github.com/eslint/eslint/issues/13196)) (Toru Nagashima)
* [`d5fce9f`](https://github.com/eslint/eslint/commit/d5fce9fa07e37ce61010a1fbb65964f1f7aefd82) Update: enable es2020 environment in --init ([#13357](https://github.com/eslint/eslint/issues/13357)) (Milos Djermanovic)
* [`b76aef7`](https://github.com/eslint/eslint/commit/b76aef778befb32afe7ad249934b132dc49713d2) Update: Improve report location for [template-tag-spacing](/docs/rules/template-tag-spacing) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13203](https://github.com/eslint/eslint/issues/13203)) (Milos Djermanovic)
* [`cb50b69`](https://github.com/eslint/eslint/commit/cb50b69c08d4393e32d5c42c537d769c51dd34d8) Update: Improve location for [no-mixed-spaces-and-tabs](/docs/rules/no-mixed-spaces-and-tabs) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13365](https://github.com/eslint/eslint/issues/13365)) (Milos Djermanovic)




## Bug Fixes


* [`e49732e`](https://github.com/eslint/eslint/commit/e49732eb41bff6347ca7718c3c5ca1d13f1cd2d3) Fix: Ignore import expressions in [no-unused-expressions](/docs/rules/no-unused-expressions) rule ([#13387](https://github.com/eslint/eslint/issues/13387)) (Veniamin Krol)
* [`426088c`](https://github.com/eslint/eslint/commit/426088c966dc79dc338b33100f3adf827b147d69) Fix: [no-unused-vars](/docs/rules/no-unused-vars) updated location to last reference (fixes [#13181](https://github.com/eslint/eslint/issues/13181)) ([#13354](https://github.com/eslint/eslint/issues/13354)) (Anix)




## Documentation


* [`21b1583`](https://github.com/eslint/eslint/commit/21b15832e326f96d349c063cd7e85e72c3abb670) Docs: fixed broken hash link for working-with-rules.md ([#13386](https://github.com/eslint/eslint/issues/13386)) (Yosuke Ota)








## Chores


* [`220349f`](https://github.com/eslint/eslint/commit/220349f5404060effe02fb5ec176a92e1383c3b5) Chore: Remove duplicate health files ([#13380](https://github.com/eslint/eslint/issues/13380)) (Nicholas C. Zakas)
* [`578efad`](https://github.com/eslint/eslint/commit/578efad331b797e28c0f5f1547ce4769d2ea23ee) Chore: update [no-unused-vars](/docs/rules/no-unused-vars) caughtErrors in eslint-config-eslint ([#13351](https://github.com/eslint/eslint/issues/13351)) (Milos Djermanovic)
* [`f858f2a`](https://github.com/eslint/eslint/commit/f858f2a8f83232484491bd90b0bc5001b5056ad0) Chore: Add Tidelift to funding.yml ([#13371](https://github.com/eslint/eslint/issues/13371)) (Nicholas C. Zakas)
* [`c29bd9f`](https://github.com/eslint/eslint/commit/c29bd9f75582e5b1a403a8ffd0aafd1ffc8c58e1) Chore: Add breaking/core change link to issue templates ([#13344](https://github.com/eslint/eslint/issues/13344)) (Kai Cataldo)


