---
layout: post
title: ESLint v7.1.0 released
teaser: "We just pushed ESLint v7.1.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Features


* [`c636d57`](https://github.com/eslint/eslint/commit/c636d5708c461a8ff1ea55e5df56d4f76f9c4044) New: [no-loss-of-precision](/docs/rules/no-loss-of-precision) (fixes [#11279](https://github.com/eslint/eslint/issues/11279)) ([#12747](https://github.com/eslint/eslint/issues/12747)) (jmoore914)




## Enhancements


* [`df01af1`](https://github.com/eslint/eslint/commit/df01af184d93b3d64b37cee786cad59bd0d7aacb) Update: [padded-blocks](/docs/rules/padded-blocks) loc position changes (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13328](https://github.com/eslint/eslint/issues/13328)) (Anix)
* [`25462b2`](https://github.com/eslint/eslint/commit/25462b23eac4ed1ded97eeae6187b5d8baa58e78) Update: [block-spacing](/docs/rules/block-spacing) changed loc for extra (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13314](https://github.com/eslint/eslint/issues/13314)) (Anix)
* [`a195141`](https://github.com/eslint/eslint/commit/a19514193a42f4f00732559ff828b33a6ec9d7c5) Update: reporting location for [semi-spacing](/docs/rules/semi-spacing) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13285](https://github.com/eslint/eslint/issues/13285)) (Anix)
* [`b0a6b81`](https://github.com/eslint/eslint/commit/b0a6b8134e3b399beeb69432a02232a1037f7c46) Update: Improve report location for [rest-spread-spacing](/docs/rules/rest-spread-spacing) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13313](https://github.com/eslint/eslint/issues/13313)) (Milos Djermanovic)
* [`89e1081`](https://github.com/eslint/eslint/commit/89e10811c4df666216aae58bff5f855cd9df738b) Update: Improve report location for [linebreak-style](/docs/rules/linebreak-style) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13317](https://github.com/eslint/eslint/issues/13317)) (Milos Djermanovic)
* [`742941d`](https://github.com/eslint/eslint/commit/742941d7fdc3fd79ff8c5d2588413e0d3a5a525b) Update: added typescript-eslint/recommended configs for init ([#13235](https://github.com/eslint/eslint/issues/13235)) (Anix)




## Bug Fixes


* [`a93083a`](https://github.com/eslint/eslint/commit/a93083af89c6f9714dcdd4a7f27c8655a0b0dba6) Fix: astUtils.getNextLocation returns invalid location after CRLF ([#13275](https://github.com/eslint/eslint/issues/13275)) (Milos Djermanovic)
* [`bd3f092`](https://github.com/eslint/eslint/commit/bd3f092efa579944f75bfbc277b35f85e6d966ed) Fix: [max-lines-per-function](/docs/rules/max-lines-per-function) flagging arrow IIFEs (fixes [#13332](https://github.com/eslint/eslint/issues/13332)) ([#13336](https://github.com/eslint/eslint/issues/13336)) (cherryblossom000)
* [`de0aab9`](https://github.com/eslint/eslint/commit/de0aab95005f172db72196fc3fd18e91ee9a5880) Fix: report end loc in [one-var-declaration-per-line](/docs/rules/one-var-declaration-per-line) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13326](https://github.com/eslint/eslint/issues/13326)) (YeonJuan)
* [`1710296`](https://github.com/eslint/eslint/commit/1710296082083602a904b080908657bb431fb56c) Fix: [no-new-symbol](/docs/rules/no-new-symbol) false positive with Symbol as an argument ([#13337](https://github.com/eslint/eslint/issues/13337)) (Milos Djermanovic)
* [`cc01451`](https://github.com/eslint/eslint/commit/cc014514c29626e556acb0a528e3478b3725e284) Fix: [arrow-parens](/docs/rules/arrow-parens) no reporting for comments inside (fixes [#12995](https://github.com/eslint/eslint/issues/12995)) ([#13312](https://github.com/eslint/eslint/issues/13312)) (Anix)
* [`e3e4c41`](https://github.com/eslint/eslint/commit/e3e4c41ab625a5af8d4614d1c6d32c656f104f6b) Fix: fix false positives of [no-new-func](/docs/rules/no-new-func) ([#13333](https://github.com/eslint/eslint/issues/13333)) (Pig Fang)
* [`68c8ee3`](https://github.com/eslint/eslint/commit/68c8ee3ab70187972aef4c4e866bcf29da70a207) Fix: Stop path analyzer on unknown nodes ([#13305](https://github.com/eslint/eslint/issues/13305)) (Ilya Volodin)
* [`2c778fb`](https://github.com/eslint/eslint/commit/2c778fb6e31b7943bb27a47a6e15dcbfd8336f39) Fix: remove custom plugins from replacedBy metadata ([#13274](https://github.com/eslint/eslint/issues/13274)) (Kai Cataldo)




## Documentation


* [`611c676`](https://github.com/eslint/eslint/commit/611c676dfd671013d81810724f184e2a9c5ad5d7) Docs: Update new rules policies ([#13343](https://github.com/eslint/eslint/issues/13343)) (Nicholas C. Zakas)
* [`0891379`](https://github.com/eslint/eslint/commit/08913798b4ec420b261b8fbc470504f9f248c840) Docs: Document the "correct" way to build an array with values ([#13246](https://github.com/eslint/eslint/issues/13246)) (Ed S)
* [`7f14846`](https://github.com/eslint/eslint/commit/7f1484690665b4f4b9cd9680ca8bb7b5cf56e48a) Docs: fix broken link in Node.js API docs ([#13307](https://github.com/eslint/eslint/issues/13307)) (Kai Cataldo)
* [`1f17533`](https://github.com/eslint/eslint/commit/1f175338cba29960aab67a540f516051f9d428c8) Docs: Gitter -> Discord URL (refs [#13039](https://github.com/eslint/eslint/issues/13039)) ([#13308](https://github.com/eslint/eslint/issues/13308)) (Nicholas C. Zakas)
* [`82a448a`](https://github.com/eslint/eslint/commit/82a448a7deff24e9207f60dfe77622c00102bd99) Docs: improve documentation of [no-return-await](/docs/rules/no-return-await) ([#13215](https://github.com/eslint/eslint/issues/13215)) (Linus Unnebäck)








## Chores


* [`3a5fbb3`](https://github.com/eslint/eslint/commit/3a5fbb3d634be688615950c0a5fa8aead6ff08b5) Chore: correct fileoverview doc in [accessor-pairs](/docs/rules/accessor-pairs) ([#13335](https://github.com/eslint/eslint/issues/13335)) (YeonJuan)
* [`88127d7`](https://github.com/eslint/eslint/commit/88127d74d56b88cc5a0758856995716050021131) Chore: remove checkbox from PR template prerequesites ([#13330](https://github.com/eslint/eslint/issues/13330)) (Kai Cataldo)
* [`72a4e10`](https://github.com/eslint/eslint/commit/72a4e1044592057c4a3f39dbb1dbe61b00ea8af6) Chore: Mark SourceCode getComments() method as deprecated (fixes [#13293](https://github.com/eslint/eslint/issues/13293)) ([#13296](https://github.com/eslint/eslint/issues/13296)) (SuperOleg39)
* [`f44a6b4`](https://github.com/eslint/eslint/commit/f44a6b4fd92602af8e2c75d5852f796ec064aa8e) Chore: fix invalid syntax in [require-await](/docs/rules/require-await) tests ([#13277](https://github.com/eslint/eslint/issues/13277)) (Milos Djermanovic)


