---
layout: post
title: ESLint v7.0.0 released
teaser: "We just pushed ESLint v7.0.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-major.png
tags:
  - release
  - major
authors:
  - kaicataldo
categories:
  - Release Notes
  - API Changes
---

## Highlights

There are several breaking changes in 7.0.0. We've created a [migration guide](/docs/user-guide/migrating-to-7.0.0) to explain the breaking changes and describe how to upgrade.

### Dropping support for Node.js v8

Node.js 8 reached EOL in December 2019, and we are officially dropping support for it in this release.

### Core rule changes

* The ten Node.js/CommonJS rules in core have been deprecated and moved to the [eslint-plugin-node](https://github.com/mysticatea/eslint-plugin-node) plugin.
* Several rules have been updated to recognize bigint literals and warn on more cases by default.
* `eslint:recommended` has been updated with a few new rules: `no-dupe-else-if`, `no-import-assign`, and `no-setter-return`.

### Improved developer experience

* The default ignore patterns have been updated. ESLint will no longer ignore `.eslintrc.js` and `bower_components/*` by default. Additionally, it will now ignore nested `node_modules` directories by default.
* ESLint will now lint files with extensions other than `.js` if they are explicitly defined in `overrides[].files` - no need to use the `--ext` flag!
* ESLint now supports descriptions in directive comments, so things like disable comments can now be clearly documented!
* Additional validation has been added to the `RuleTester` class to improve testing custom rules in plugins.
* ESLint will now resolve plugins relative to the entry configuration file. This means that shared configuration files that are located outside the project can now be colocated with the plugins they require.
* Starting in ESLint v7, configuration files and ignore files passed to ESLint using the --config path/to/a-config and --ignore-path path/to/a-ignore CLI flags, respectively, will resolve from the current working directory rather than the file location. This allows for users to utilize shared plugins without having to install them directly in their project.

### New `ESLint` class

* The `CLIEngine` class provides a synchronous API that is blocking the implementation of features such as parallel linting, supporting ES modules in shareable configs/parsers/plugins/formatters, and adding the ability to visually display the progress of linting runs. The new `ESLint` class provides an asynchronous API that ESLint core will now using going forward. `CLIEngine` will remain in core for the foreseeable future but may be removed in a future major version.




## Breaking Changes


* [`4ef6158`](https://github.com/eslint/eslint/commit/4ef61580736353f700ab9e4e29f005b5ac552c78) Breaking: espree@7.0.0 ([#13270](https://github.com/eslint/eslint/issues/13270)) (Kai Cataldo)
* [`78c8cda`](https://github.com/eslint/eslint/commit/78c8cda5a5d82f5f8548c4528a6438d29756bb71) Breaking: RuleTester Improvements (refs [eslint/rfcs#25](https://github.com/eslint/rfcs/issues/25)) ([#12955](https://github.com/eslint/eslint/issues/12955)) (Milos Djermanovic)
* [`185982d`](https://github.com/eslint/eslint/commit/185982d5615d325ae8b45c2360d5847df4098bda) Breaking: improve plugin resolving (refs [eslint/rfcs#47](https://github.com/eslint/rfcs/issues/47)) ([#12922](https://github.com/eslint/eslint/issues/12922)) (Toru Nagashima)
* [`48b122f`](https://github.com/eslint/eslint/commit/48b122f450b14dd27afef4c8115c69fca4f02be1) Breaking: change relative paths with --config (refs [eslint/rfcs#37](https://github.com/eslint/rfcs/issues/37)) ([#12887](https://github.com/eslint/eslint/issues/12887)) (Toru Nagashima)
* [`4af06fc`](https://github.com/eslint/eslint/commit/4af06fc49029dac5c9acfd53f01fd9527bfbb4aa) Breaking: Test with an unknown error property should fail in RuleTester ([#12096](https://github.com/eslint/eslint/issues/12096)) (Milos Djermanovic)
* [`afa9aac`](https://github.com/eslint/eslint/commit/afa9aac6de9444e935a55b46311e5b5a58f86063) Breaking: class default `true` [computed-property-spacing](/docs/rules/computed-property-spacing) (fixes [#12812](https://github.com/eslint/eslint/issues/12812)) ([#12915](https://github.com/eslint/eslint/issues/12915)) (Milos Djermanovic)
* [`7d52151`](https://github.com/eslint/eslint/commit/7d52151bcd5d5524f240588436a8808162be187f) Breaking: classes default `true` in [accessor-pairs](/docs/rules/accessor-pairs) (fixes [#12811](https://github.com/eslint/eslint/issues/12811)) ([#12919](https://github.com/eslint/eslint/issues/12919)) (Milos Djermanovic)
* [`78182e4`](https://github.com/eslint/eslint/commit/78182e45e0178d9eac2591944ef4daee21d2cb44) Breaking: Add new rules to eslint:recommended (fixes [#12911](https://github.com/eslint/eslint/issues/12911)) ([#12920](https://github.com/eslint/eslint/issues/12920)) (Milos Djermanovic)
* [`6423e11`](https://github.com/eslint/eslint/commit/6423e11c0bedd3b4e661ab554316bdeb1fc1ee3c) Breaking: check unnamed default export in [func-names](/docs/rules/func-names) (fixes [#12194](https://github.com/eslint/eslint/issues/12194)) ([#12195](https://github.com/eslint/eslint/issues/12195)) (Chiawen Chen)
* [`4293229`](https://github.com/eslint/eslint/commit/4293229709dde105692347241513766e953664dd) Breaking: [use-isnan](/docs/rules/use-isnan) enforceForSwitchCase default `true` (fixes [#12810](https://github.com/eslint/eslint/issues/12810)) ([#12913](https://github.com/eslint/eslint/issues/12913)) (Milos Djermanovic)
* [`cf38d0d`](https://github.com/eslint/eslint/commit/cf38d0d939b62f3670cdd59f0143fd896fccd771) Breaking: change default ignore pattern (refs [eslint/rfcs#51](https://github.com/eslint/rfcs/issues/51)) ([#12888](https://github.com/eslint/eslint/issues/12888)) (Toru Nagashima)
* [`bfe1dc4`](https://github.com/eslint/eslint/commit/bfe1dc4e614640cb69032afbb5851c1493f537e3) Breaking: [no-dupe-class-members](/docs/rules/no-dupe-class-members) checks some computed keys (fixes [#12808](https://github.com/eslint/eslint/issues/12808)) ([#12837](https://github.com/eslint/eslint/issues/12837)) (Milos Djermanovic)
* [`c2217c0`](https://github.com/eslint/eslint/commit/c2217c04d6c82b160a21b00fca39c8acec543403) Breaking: make [`radix`](/docs/rules/radix) rule stricter ([#12608](https://github.com/eslint/eslint/issues/12608)) (fisker Cheung)
* [`1aa021d`](https://github.com/eslint/eslint/commit/1aa021d77fdd2c68d7b7d2f4603252110c414b32) Breaking: lint `overrides` files (fixes [#10828](https://github.com/eslint/eslint/issues/10828), refs [eslint/rfcs#20](https://github.com/eslint/rfcs/issues/20)) ([#12677](https://github.com/eslint/eslint/issues/12677)) (Toru Nagashima)
* [`b50179d`](https://github.com/eslint/eslint/commit/b50179def3fedbd95fdeab25e32c2511867eb760) Breaking: Check assignment targets in [no-extra-parens](/docs/rules/no-extra-parens) ([#12490](https://github.com/eslint/eslint/issues/12490)) (Milos Djermanovic)
* [`d86a5bb`](https://github.com/eslint/eslint/commit/d86a5bbb1987d858d4963f647b0af5c1fd924b4f) Breaking: Check flatMap in [array-callback-return](/docs/rules/array-callback-return) (fixes [#12235](https://github.com/eslint/eslint/issues/12235)) ([#12765](https://github.com/eslint/eslint/issues/12765)) (Milos Djermanovic)
* [`cf46df7`](https://github.com/eslint/eslint/commit/cf46df70158a4ed4c09d5c9d655c07dc6df3ff5e) Breaking: description in directive comments (refs [eslint/rfcs#33](https://github.com/eslint/rfcs/issues/33)) ([#12699](https://github.com/eslint/eslint/issues/12699)) (Toru Nagashima)
* [`7350589`](https://github.com/eslint/eslint/commit/7350589a5bdfc9d75d1ff19364f476eec44c3911) Breaking: some rules recognize bigint literals (fixes [#11803](https://github.com/eslint/eslint/issues/11803)) ([#12701](https://github.com/eslint/eslint/issues/12701)) (Toru Nagashima)
* [`1118fce`](https://github.com/eslint/eslint/commit/1118fceb49af3436b8dcd0c6089f913cedf9a329) Breaking: runtime-deprecation on '~/.eslintrc' (refs [eslint/rfcs#32](https://github.com/eslint/rfcs/issues/32)) ([#12678](https://github.com/eslint/eslint/issues/12678)) (Toru Nagashima)
* [`2c28fbb`](https://github.com/eslint/eslint/commit/2c28fbbb563a44282bef0c9fcc9be29d611cc83b) Breaking: drop Node.js 8 support (refs [eslint/rfcs#44](https://github.com/eslint/rfcs/issues/44)) ([#12700](https://github.com/eslint/eslint/issues/12700)) (Toru Nagashima)




## Features


* [`f9774ec`](https://github.com/eslint/eslint/commit/f9774ec11b0ebe63fb16a97b97890efb84699548) New: Add [default-case-last](/docs/rules/default-case-last) rule (fixes [#12665](https://github.com/eslint/eslint/issues/12665)) ([#12668](https://github.com/eslint/eslint/issues/12668)) (Milos Djermanovic)
* [`a1d999c`](https://github.com/eslint/eslint/commit/a1d999c6b4e51c317ad409110be7be214ff9f7c6) New: Add [no-useless-backreference](/docs/rules/no-useless-backreference) rule (fixes [#12673](https://github.com/eslint/eslint/issues/12673)) ([#12690](https://github.com/eslint/eslint/issues/12690)) (Milos Djermanovic)
* [`985dac3`](https://github.com/eslint/eslint/commit/985dac35e3c367f0f99d1f0e766e06a1d9818dd4) New: Add [no-restricted-exports](/docs/rules/no-restricted-exports) rule (fixes [#10428](https://github.com/eslint/eslint/issues/10428)) ([#12546](https://github.com/eslint/eslint/issues/12546)) (Milos Djermanovic)




## Enhancements


* [`0b1d65a`](https://github.com/eslint/eslint/commit/0b1d65a45aa5dfe08cd596c420490e81b546317e) Update: Improve report location for [array-callback-return](/docs/rules/array-callback-return) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13109](https://github.com/eslint/eslint/issues/13109)) (Milos Djermanovic)
* [`d3aac53`](https://github.com/eslint/eslint/commit/d3aac532f6a24c633f85dedf0e552eabd22d0956) Update: report backtick loc in [no-unexpected-multiline](/docs/rules/no-unexpected-multiline) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13142](https://github.com/eslint/eslint/issues/13142)) (Milos Djermanovic)
* [`bcafd0f`](https://github.com/eslint/eslint/commit/bcafd0f8508e19ab8087a35fac7b97fc4295df3e) Update: Add ESLint API (refs [eslint/rfcs#40](https://github.com/eslint/rfcs/issues/40)) ([#12939](https://github.com/eslint/eslint/issues/12939)) (Kai Cataldo)
* [`5c1bdeb`](https://github.com/eslint/eslint/commit/5c1bdebcf728062fd41583886830c89b65485df9) Update: Improve report location for [getter-return](/docs/rules/getter-return) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13164](https://github.com/eslint/eslint/issues/13164)) (Milos Djermanovic)
* [`e7c1d4b`](https://github.com/eslint/eslint/commit/e7c1d4b2ac56149a517d4b0000230348a641f1d3) Update: deprecate Node.js & CommonJS rules ([#12898](https://github.com/eslint/eslint/issues/12898)) (Kai Cataldo)
* [`af4472f`](https://github.com/eslint/eslint/commit/af4472fed794b86e63730702e4b27294a4118d09) Update: Improve report location for [new-cap](/docs/rules/new-cap) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13136](https://github.com/eslint/eslint/issues/13136)) (Milos Djermanovic)
* [`a784dac`](https://github.com/eslint/eslint/commit/a784dac8bc26f31edbca869b16d6ad91bd4e5cc4) Update: Improve report location [newline-per-chained-call](/docs/rules/newline-per-chained-call) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13116](https://github.com/eslint/eslint/issues/13116)) (Milos Djermanovic)
* [`5e07574`](https://github.com/eslint/eslint/commit/5e07574a91861fdcab6888b4c6829868030c3a39) Update: Improve report location for [space-before-function-paren](/docs/rules/space-before-function-paren) ([#13128](https://github.com/eslint/eslint/issues/13128)) (Chiawen Chen)
* [`17e2fe4`](https://github.com/eslint/eslint/commit/17e2fe425168e675fe7607182615e50527eedf53) Update: Improve error message for fatal fixer errors ([#13120](https://github.com/eslint/eslint/issues/13120)) (Brad Zacher)
* [`438dcbb`](https://github.com/eslint/eslint/commit/438dcbb981214d67e8848006ce45afc0fbfa1705) Update: Improve report location for [comma-style](/docs/rules/comma-style) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13111](https://github.com/eslint/eslint/issues/13111)) (Chiawen Chen)
* [`85b7254`](https://github.com/eslint/eslint/commit/85b72548c0c893499c787b82f404348e1b50354d) Update: [no-inner-declarations](/docs/rules/no-inner-declarations) false negative in non-block (fixes [#12222](https://github.com/eslint/eslint/issues/12222)) ([#13062](https://github.com/eslint/eslint/issues/13062)) (Anix)
* [`6631ef1`](https://github.com/eslint/eslint/commit/6631ef1678bbdd48680fb3025c3692abd0aeec4a) Update: Improve report location for [no-empty-function](/docs/rules/no-empty-function) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13121](https://github.com/eslint/eslint/issues/13121)) (Milos Djermanovic)
* [`e0f1b6c`](https://github.com/eslint/eslint/commit/e0f1b6c3d62f725b99b8c07654603b559ba43ba9) Update: stricter array index check in [no-magic-numbers](/docs/rules/no-magic-numbers) (fixes [#12845](https://github.com/eslint/eslint/issues/12845)) ([#12851](https://github.com/eslint/eslint/issues/12851)) (Milos Djermanovic)
* [`362713c`](https://github.com/eslint/eslint/commit/362713c04aa89092b2b98a77fa94a75b3c933fc6) Update: Improve report location for [template-curly-spacing](/docs/rules/template-curly-spacing) ([#12813](https://github.com/eslint/eslint/issues/12813)) (Milos Djermanovic)
* [`105384c`](https://github.com/eslint/eslint/commit/105384ccc11dcd7303104fb5a347eda1d4d48357) Update: report operator location in [operator-linebreak](/docs/rules/operator-linebreak) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13102](https://github.com/eslint/eslint/issues/13102)) (Milos Djermanovic)
* [`081e240`](https://github.com/eslint/eslint/commit/081e24022a40d9a026ddd2a85c68cb8c3f18dc53) Update: support globalThis in [no-implied-eval](/docs/rules/no-implied-eval) (fixes [#12670](https://github.com/eslint/eslint/issues/12670)) ([#13105](https://github.com/eslint/eslint/issues/13105)) (YeonJuan)
* [`a1370ab`](https://github.com/eslint/eslint/commit/a1370abed72e1fb93e601816d981fa6e46204afb) Update: Report constructor calls in [no-obj-calls](/docs/rules/no-obj-calls) ([#12909](https://github.com/eslint/eslint/issues/12909)) (Milos Djermanovic)
* [`085979f`](https://github.com/eslint/eslint/commit/085979fed9a5e24a87e4d92ee79272b59211d03f) Update: consider env in [no-implied-eval](/docs/rules/no-implied-eval) (fixes [#12733](https://github.com/eslint/eslint/issues/12733)) ([#12757](https://github.com/eslint/eslint/issues/12757)) (YeonJuan)
* [`e90b29b`](https://github.com/eslint/eslint/commit/e90b29bb1f41d4e5767e33d03db5984f036586ed) Update: Allow testing Suggestions with data in RuleTester (fixes [#12606](https://github.com/eslint/eslint/issues/12606)) ([#12635](https://github.com/eslint/eslint/issues/12635)) (Milos Djermanovic)
* [`183e300`](https://github.com/eslint/eslint/commit/183e3006841c29efdd245c45a72e6cefac86ae35) Update: support globalThis (refs [#12670](https://github.com/eslint/eslint/issues/12670)) ([#12774](https://github.com/eslint/eslint/issues/12774)) (YeonJuan)
* [`1299705`](https://github.com/eslint/eslint/commit/12997058626b5167ba4b9d2ae0d0ea965a01c4be) Update: acorn version ([#13016](https://github.com/eslint/eslint/issues/13016)) (Idan Avrahami)
* [`a5b41a7`](https://github.com/eslint/eslint/commit/a5b41a75b57572e97476b06ad39b768e15b9d844) Update: [no-restricted-modules](/docs/rules/no-restricted-modules) handle TemplateLiteral (fixes [#12926](https://github.com/eslint/eslint/issues/12926)) ([#12927](https://github.com/eslint/eslint/issues/12927)) (Michal Piechowiak)
* [`051567a`](https://github.com/eslint/eslint/commit/051567adca7ca56d691bcda76f54ed72e3eae367) Update: check identifier in array pattern in [id-length](/docs/rules/id-length) (fixes [#12832](https://github.com/eslint/eslint/issues/12832)) ([#12839](https://github.com/eslint/eslint/issues/12839)) (YeonJuan)
* [`9038a29`](https://github.com/eslint/eslint/commit/9038a29569548c0563c29dbe9f7dae280ff3addd) Update: [func-names](/docs/rules/func-names) `as-needed` false negative with AssignmentPattern ([#12932](https://github.com/eslint/eslint/issues/12932)) (Milos Djermanovic)
* [`7747177`](https://github.com/eslint/eslint/commit/7747177f8504961059b7c56bdb70a820bd1114c1) Update: report rename id destructuring in [id-blacklist](/docs/rules/id-blacklist) (fixes [#12807](https://github.com/eslint/eslint/issues/12807)) ([#12923](https://github.com/eslint/eslint/issues/12923)) (YeonJuan)
* [`77df505`](https://github.com/eslint/eslint/commit/77df505d9a08496a8eaefeca4f885f54a21d5c5e) Update: check renaming identifier in object destructuring (fixes 12827) ([#12881](https://github.com/eslint/eslint/issues/12881)) (YeonJuan)
* [`41de9df`](https://github.com/eslint/eslint/commit/41de9df41a30a4300243bfe4ca26f716a787b2fc) Update: enforceForLogicalOperands [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) (fixes [#12137](https://github.com/eslint/eslint/issues/12137)) ([#12734](https://github.com/eslint/eslint/issues/12734)) (jmoore914)
* [`1ee6b63`](https://github.com/eslint/eslint/commit/1ee6b6388305a8671c8d4c3cf30c2dbf18a1ff7e) Update: check template literal in [yoda](/docs/rules/yoda) (fixes [#12863](https://github.com/eslint/eslint/issues/12863)) ([#12876](https://github.com/eslint/eslint/issues/12876)) (YeonJuan)
* [`439c833`](https://github.com/eslint/eslint/commit/439c83342c364ba3ce5168d54e165b1fe3e35630) Update: [array-callback-return](/docs/rules/array-callback-return) checks Array.forEach (fixes [#12551](https://github.com/eslint/eslint/issues/12551)) ([#12646](https://github.com/eslint/eslint/issues/12646)) (Gabriel R Sezefredo)
* [`03a69db`](https://github.com/eslint/eslint/commit/03a69dbe86d5b5768a310105416ae726822e3c1c) Update: check template literal in [no-proto](/docs/rules/no-proto), [no-iterator](/docs/rules/no-iterator) (fixes [#12801](https://github.com/eslint/eslint/issues/12801)) ([#12806](https://github.com/eslint/eslint/issues/12806)) (YeonJuan)
* [`562e784`](https://github.com/eslint/eslint/commit/562e7845946a490f2e173a0bcd1af631070a4eef) Update: fix [no-magic-numbers](/docs/rules/no-magic-numbers) false negative with ignoreArrayIndexes ([#12805](https://github.com/eslint/eslint/issues/12805)) (Milos Djermanovic)
* [`0460748`](https://github.com/eslint/eslint/commit/0460748cda67ddc4a4cb0db3cdf187a742d09bf8) Update: check template literal in [no-constant-condition](/docs/rules/no-constant-condition) (fixes [#12815](https://github.com/eslint/eslint/issues/12815)) ([#12816](https://github.com/eslint/eslint/issues/12816)) (YeonJuan)
* [`e59d775`](https://github.com/eslint/eslint/commit/e59d77536bd8db57e8a75cd5245f6f320aa699f8) Update: Separate pattern/expression options for [array-element-newline](/docs/rules/array-element-newline) ([#11796](https://github.com/eslint/eslint/issues/11796)) (jacobparish)
* [`f8f115a`](https://github.com/eslint/eslint/commit/f8f115af6e10539e6cad485588187cb11917f8c9) Update: treat comment tokens in [template-curly-spacing](/docs/rules/template-curly-spacing) (fixes [#12744](https://github.com/eslint/eslint/issues/12744)) ([#12775](https://github.com/eslint/eslint/issues/12775)) (YeonJuan)
* [`9a93d9e`](https://github.com/eslint/eslint/commit/9a93d9ef389c49a133c4df4f9843927f5f806423) Update: fix [no-restricted-imports](/docs/rules/no-restricted-imports) export * false negative (fixes [#12737](https://github.com/eslint/eslint/issues/12737)) ([#12798](https://github.com/eslint/eslint/issues/12798)) (Milos Djermanovic)
* [`68becbd`](https://github.com/eslint/eslint/commit/68becbd84e8a0693409d36f2be10679c483e233a) Update: fix [no-restricted-imports](/docs/rules/no-restricted-imports) importNames reporting (fixes [#12282](https://github.com/eslint/eslint/issues/12282)) ([#12711](https://github.com/eslint/eslint/issues/12711)) (Andrey Alexandrov)
* [`ae959b6`](https://github.com/eslint/eslint/commit/ae959b691fb148ac8b474c924c8cb01ef61c436d) Update: report double extra parens in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#12127](https://github.com/eslint/eslint/issues/12127)) ([#12697](https://github.com/eslint/eslint/issues/12697)) (YeonJuan)
* [`b2c6209`](https://github.com/eslint/eslint/commit/b2c62096a8b318765d618cab222240f87d73063b) Update: fix [no-extra-parens](/docs/rules/no-extra-parens) CallExpression#callee false negatives ([#12743](https://github.com/eslint/eslint/issues/12743)) (Milos Djermanovic)
* [`14b42c3`](https://github.com/eslint/eslint/commit/14b42c386be3387c415267b789f277e1294d4567) Update: fix counting jsx comment len in [max-len](/docs/rules/max-len) (fixes [#12213](https://github.com/eslint/eslint/issues/12213)) ([#12661](https://github.com/eslint/eslint/issues/12661)) (YeonJuan)
* [`313f70a`](https://github.com/eslint/eslint/commit/313f70ac9a3cf5d1558d2427b00dd75666e18cf4) Update: add outerIIFEBody: "off" to [indent](/docs/rules/indent) rule (fixes [#11377](https://github.com/eslint/eslint/issues/11377)) ([#12706](https://github.com/eslint/eslint/issues/12706)) (Kai Cataldo)
* [`3fa39a6`](https://github.com/eslint/eslint/commit/3fa39a633b37544fec7cedfc1f2b0e62e9312a72) Update: Handle locally unsupported regex in computed property keys ([#12056](https://github.com/eslint/eslint/issues/12056)) (Milos Djermanovic)
* [`8f1020f`](https://github.com/eslint/eslint/commit/8f1020ff711b0c57d590bf666e2841f64186d083) Update: [no-void](/docs/rules/no-void) add an option to allow void as a statement ([#12613](https://github.com/eslint/eslint/issues/12613)) (Brad Zacher)
* [`bb6cf50`](https://github.com/eslint/eslint/commit/bb6cf5082623ffb67bb1495fee52c0610ee5f421) Update: Add offsetTernaryExpressions option for [indent](/docs/rules/indent) rule ([#12556](https://github.com/eslint/eslint/issues/12556)) (Adam Stankiewicz)




## Bug Fixes


* [`4c0b028`](https://github.com/eslint/eslint/commit/4c0b028c55fc1674b374efe0bc6dd22c02b4ac88) Fix: remove Node.js and CommonJS category from build process ([#13242](https://github.com/eslint/eslint/issues/13242)) (Kai Cataldo)
* [`d85e291`](https://github.com/eslint/eslint/commit/d85e291d1b56960373031f2562547df7285444f7) Fix: [yoda](/docs/rules/yoda) left string fix for exceptRange (fixes [#12883](https://github.com/eslint/eslint/issues/12883)) ([#13052](https://github.com/eslint/eslint/issues/13052)) (Anix)
* [`8e7a2d9`](https://github.com/eslint/eslint/commit/8e7a2d93595cfe0c1597af0e7873853369251c0b) Fix: [func-call-spacing](/docs/rules/func-call-spacing) "never" reports wrong message (fixes [#13190](https://github.com/eslint/eslint/issues/13190)) ([#13193](https://github.com/eslint/eslint/issues/13193)) (Milos Djermanovic)
* [`ebc28d7`](https://github.com/eslint/eslint/commit/ebc28d76658f1f3e4e8d56e70a25752b5d4a6686) Fix: Remove default .js from --ext CLI option ([#13176](https://github.com/eslint/eslint/issues/13176)) (Brandon Mills)
* [`c9a5035`](https://github.com/eslint/eslint/commit/c9a503571a4662f6c2d31cabc7fd7819ec388150) Fix: newBasePath should be an absolute path (fixes [#12850](https://github.com/eslint/eslint/issues/12850)) ([#13078](https://github.com/eslint/eslint/issues/13078)) (Nick Harris)
* [`301b450`](https://github.com/eslint/eslint/commit/301b450ecd1985ae84d1915124f4638ab2a2e6de) Fix: [no-extra-parens](/docs/rules/no-extra-parens) export default sequence expression false positive ([#13096](https://github.com/eslint/eslint/issues/13096)) (Milos Djermanovic)
* [`bfa811c`](https://github.com/eslint/eslint/commit/bfa811ceee801fe8ba212a5c879e13743146e909) Fix: init error in extending recommended config (fixes [#12707](https://github.com/eslint/eslint/issues/12707)) ([#12738](https://github.com/eslint/eslint/issues/12738)) (YeonJuan)
* [`7551f0c`](https://github.com/eslint/eslint/commit/7551f0c6fd12f0295cc7d6377bf1899c092e79d8) Fix: no check for shadowed Object (fixes [#12809](https://github.com/eslint/eslint/issues/12809)) ([#13115](https://github.com/eslint/eslint/issues/13115)) (Anix)
* [`988d842`](https://github.com/eslint/eslint/commit/988d8428811934943ce13b2d8b833d795ac2bb4a) Fix: add end location to report in [no-useless-concat](/docs/rules/no-useless-concat) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13110](https://github.com/eslint/eslint/issues/13110)) (Milos Djermanovic)
* [`29f32db`](https://github.com/eslint/eslint/commit/29f32db68c921a857e17ae627923d87b9c8708de) Fix: Change error message logic for implicit file ignore (fixes [#12873](https://github.com/eslint/eslint/issues/12873)) ([#12878](https://github.com/eslint/eslint/issues/12878)) (Scott Hardin)
* [`eb1a43c`](https://github.com/eslint/eslint/commit/eb1a43ce3113c906800192c3ef766d2ff188776f) Fix: [require-await](/docs/rules/require-await) ignore async generators (fixes [#12459](https://github.com/eslint/eslint/issues/12459)) ([#13048](https://github.com/eslint/eslint/issues/13048)) (Anix)
* [`920465b`](https://github.com/eslint/eslint/commit/920465b5d8d291df8bce7eef8a066b1dd43d8cae) Fix: getNameLocationInGlobalDirectiveComment end location (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13086](https://github.com/eslint/eslint/issues/13086)) (Milos Djermanovic)
* [`ae14a02`](https://github.com/eslint/eslint/commit/ae14a021bbea5117fe366ae4ed235e8f08dc65a8) Fix: add end location to report in [no-extra-bind](/docs/rules/no-extra-bind) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13083](https://github.com/eslint/eslint/issues/13083)) (Milos Djermanovic)
* [`0c20bc0`](https://github.com/eslint/eslint/commit/0c20bc068e608869981a10711bba88ffde1539d8) Fix: check assignment property target in [camelcase](/docs/rules/camelcase) (fixes [#13025](https://github.com/eslint/eslint/issues/13025)) ([#13027](https://github.com/eslint/eslint/issues/13027)) (YeonJuan)
* [`8d50a7d`](https://github.com/eslint/eslint/commit/8d50a7d82244d4912f3eab62a66c81c76c44a9da) Fix: add end location to report in [no-prototype-builtins](/docs/rules/no-prototype-builtins) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13087](https://github.com/eslint/eslint/issues/13087)) (Milos Djermanovic)
* [`3e4e7f8`](https://github.com/eslint/eslint/commit/3e4e7f8d429dc70b78c0aefaa37f9c22a1e5fc0f) Fix: incorrect logic for required parens in [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) fixer ([#13061](https://github.com/eslint/eslint/issues/13061)) (Milos Djermanovic)
* [`aef9488`](https://github.com/eslint/eslint/commit/aef9488c07d3da4becff6e8d6918824b53086d86) Fix: allow references to external globals in [id-blacklist](/docs/rules/id-blacklist) (fixes [#12567](https://github.com/eslint/eslint/issues/12567)) ([#12987](https://github.com/eslint/eslint/issues/12987)) (Milos Djermanovic)
* [`4955c50`](https://github.com/eslint/eslint/commit/4955c50dc9e89b4077b28e35f065d45e89bdccd7) Fix: remove type arguments in [prefer-object-spread](/docs/rules/prefer-object-spread) (fixes [#13058](https://github.com/eslint/eslint/issues/13058)) ([#13063](https://github.com/eslint/eslint/issues/13063)) (Milos Djermanovic)
* [`dbe357d`](https://github.com/eslint/eslint/commit/dbe357de199620675446464f6fd0e35064c4d247) Fix: check template literal in [prefer-numeric-literals](/docs/rules/prefer-numeric-literals) (fixes [#13045](https://github.com/eslint/eslint/issues/13045)) ([#13046](https://github.com/eslint/eslint/issues/13046)) (YeonJuan)
* [`2260611`](https://github.com/eslint/eslint/commit/2260611e616bdc2a0bf16d508b60a50772ce7fbb) Fix: added async in allow method in [no-empty-function](/docs/rules/no-empty-function) (fixes [#12768](https://github.com/eslint/eslint/issues/12768)) ([#13036](https://github.com/eslint/eslint/issues/13036)) (Anix)
* [`7224eee`](https://github.com/eslint/eslint/commit/7224eee3ff4b4378d3439deb038bf34b116fa48b) Fix: [no-plusplus](/docs/rules/no-plusplus) allow comma operands in for afterthought (fixes [#13005](https://github.com/eslint/eslint/issues/13005)) ([#13024](https://github.com/eslint/eslint/issues/13024)) (Milos Djermanovic)
* [`7598cf8`](https://github.com/eslint/eslint/commit/7598cf816bd854de1dd7d96cf00dec6ecc4564ac) Fix: Newline before eof when creating config via --init ([#12952](https://github.com/eslint/eslint/issues/12952)) (Andreas Lind)
* [`0243549`](https://github.com/eslint/eslint/commit/0243549db4d237cb78e720d55a9cae89b91f6830) Fix: [camelcase](/docs/rules/camelcase) false positive with computed property (fixes [#13022](https://github.com/eslint/eslint/issues/13022)) ([#13023](https://github.com/eslint/eslint/issues/13023)) (Milos Djermanovic)
* [`6cef0d5`](https://github.com/eslint/eslint/commit/6cef0d50a0d131bc8897799a54e1af1d38606db4) Fix: Check division operator in astUtils.canTokensBeAdjacent ([#12879](https://github.com/eslint/eslint/issues/12879)) (Milos Djermanovic)
* [`afde78b`](https://github.com/eslint/eslint/commit/afde78b125747ce5ad9e5f871122a0d370dd0152) Fix: [curly](/docs/rules/curly) removes necessary braces between if and else (fixes [#12928](https://github.com/eslint/eslint/issues/12928)) ([#12943](https://github.com/eslint/eslint/issues/12943)) (Milos Djermanovic)
* [`4797fb2`](https://github.com/eslint/eslint/commit/4797fb2c29db97bc5cd23b40e5a9235fef1ea06a) Fix: [arrow-body-style](/docs/rules/arrow-body-style) crash with object literal body (fixes [#12884](https://github.com/eslint/eslint/issues/12884)) ([#12886](https://github.com/eslint/eslint/issues/12886)) (Milos Djermanovic)
* [`de14d1c`](https://github.com/eslint/eslint/commit/de14d1ce0cf422b4100a686abb906f53fbf905b3) Fix: [wrap-iife](/docs/rules/wrap-iife) autofix removes mandatory parentheses ([#12905](https://github.com/eslint/eslint/issues/12905)) (Milos Djermanovic)
* [`5775b06`](https://github.com/eslint/eslint/commit/5775b06a74573cbe068bea56b1d2376421f5e831) Fix: Optionally allow underscores in member names ([#11972](https://github.com/eslint/eslint/issues/11972)) (Edgardo Avilés)
* [`0dfc3ff`](https://github.com/eslint/eslint/commit/0dfc3ff9fb228e1d9b1df99de50033ce9140ac24) Fix: add end location to report in [no-eval](/docs/rules/no-eval) ([#12960](https://github.com/eslint/eslint/issues/12960)) (Milos Djermanovic)
* [`1f1424c`](https://github.com/eslint/eslint/commit/1f1424cb200e609d58645f6c54739e11469e6265) Fix: fix inconsistently works option in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#12717](https://github.com/eslint/eslint/issues/12717)) ([#12843](https://github.com/eslint/eslint/issues/12843)) (YeonJuan)
* [`b5adcaa`](https://github.com/eslint/eslint/commit/b5adcaab93f388f1d8e9d35d6f5e8c2994240850) Fix: make YieldExpression throwable (fixes [#12880](https://github.com/eslint/eslint/issues/12880)) ([#12897](https://github.com/eslint/eslint/issues/12897)) (YeonJuan)
* [`95e0586`](https://github.com/eslint/eslint/commit/95e0586c95e6953d11983d1d11891ed30318109a) Fix: [id-blacklist](/docs/rules/id-blacklist) false positives on renamed imports ([#12831](https://github.com/eslint/eslint/issues/12831)) (Milos Djermanovic)
* [`dadc892`](https://github.com/eslint/eslint/commit/dadc8927820576c60b48bcbc7d5a9056a6279d30) Fix: [operator-assignment](/docs/rules/operator-assignment) crash on adjacent division assignment ([#12844](https://github.com/eslint/eslint/issues/12844)) (Milos Djermanovic)
* [`a9d92f9`](https://github.com/eslint/eslint/commit/a9d92f991d69902a9150db373590e2ed54dec988) Fix: [radix](/docs/rules/radix) rule crash on disabled globals ([#12824](https://github.com/eslint/eslint/issues/12824)) (Milos Djermanovic)
* [`533c114`](https://github.com/eslint/eslint/commit/533c1140dc98bebdc3ae8334ab2e6c27c7df0c21) Fix: [multiline-comment-style](/docs/rules/multiline-comment-style) rule add extra space after * (fixes [#12785](https://github.com/eslint/eslint/issues/12785)) ([#12823](https://github.com/eslint/eslint/issues/12823)) (Karthik Priyadarshan)
* [`80309c3`](https://github.com/eslint/eslint/commit/80309c3791188ac5d1c4eebc99ede323a55336e6) Fix: [no-constant-condition](/docs/rules/no-constant-condition) doesn't introspect arrays (fixes [#12225](https://github.com/eslint/eslint/issues/12225)) ([#12307](https://github.com/eslint/eslint/issues/12307)) (Sean Gray)
* [`de4fa7c`](https://github.com/eslint/eslint/commit/de4fa7c65c7befefa64d1605550267071ee56a5d) Fix: wrong [indent](/docs/rules/indent) at tagged template in [indent](/docs/rules/indent) (fixes [#12122](https://github.com/eslint/eslint/issues/12122)) ([#12596](https://github.com/eslint/eslint/issues/12596)) (YeonJuan)
* [`16a1c1f`](https://github.com/eslint/eslint/commit/16a1c1f79bc0a4cc1c3a87e98d220041de88bb93) Fix: [prefer-object-spread](/docs/rules/prefer-object-spread) false positives with accessors (fixes [#12086](https://github.com/eslint/eslint/issues/12086)) ([#12784](https://github.com/eslint/eslint/issues/12784)) (Milos Djermanovic)
* [`0d8c0af`](https://github.com/eslint/eslint/commit/0d8c0affe1ae7ecf228cdf91b490921f7e9d1fdb) Fix: improve report location for [computed-property-spacing](/docs/rules/computed-property-spacing) ([#12795](https://github.com/eslint/eslint/issues/12795)) (Milos Djermanovic)
* [`756b95d`](https://github.com/eslint/eslint/commit/756b95d59fb97cd9b3f3adf98cebf529fe4842a2) Fix: [id-blacklist](/docs/rules/id-blacklist) should ignore ObjectPatterns (fixes [#12787](https://github.com/eslint/eslint/issues/12787)) ([#12792](https://github.com/eslint/eslint/issues/12792)) (JP Ramassini)
* [`01ff791`](https://github.com/eslint/eslint/commit/01ff7910af86fc45b76e883bc9ab00c9be3b50ac) Fix: Display pipe character correctly in test output ([#12771](https://github.com/eslint/eslint/issues/12771)) (Brad Zacher)
* [`00ddfff`](https://github.com/eslint/eslint/commit/00ddfffe6b4b4244e4680b0f92f2c6697fad136f) Fix: Windows path parsing for JUnit (fixes [#12507](https://github.com/eslint/eslint/issues/12507)) ([#12509](https://github.com/eslint/eslint/issues/12509)) (Michael Wall)
* [`1aff21b`](https://github.com/eslint/eslint/commit/1aff21bb54da44cef0b6e378a34a74265863b930) Fix: [no-mixed-spaces-and-tabs](/docs/rules/no-mixed-spaces-and-tabs) reports multiline strings ([#12566](https://github.com/eslint/eslint/issues/12566)) (Milos Djermanovic)




## Documentation


* [`b5c8d73`](https://github.com/eslint/eslint/commit/b5c8d7389bb2c5d4eae850b866832d099187818b) Docs: update 7.0.0 migration guide for consistency ([#13267](https://github.com/eslint/eslint/issues/13267)) (Kai Cataldo)
* [`356fdb4`](https://github.com/eslint/eslint/commit/356fdb46aa118ba3d81cee93e8c058a7c98acaf9) Docs: add migration guide ([#12692](https://github.com/eslint/eslint/issues/12692)) (Toru Nagashima)
* [`56d2bee`](https://github.com/eslint/eslint/commit/56d2beea0ea0b6395a6d4a3e116ea6a964ff92f3) Docs: fix typos ([#13204](https://github.com/eslint/eslint/issues/13204)) (Nitin Kumar)
* [`516f253`](https://github.com/eslint/eslint/commit/516f253729daeeb9da5de5e9b38606ff9c1aae71) Docs: Adds import example for [object-curly-newline](/docs/rules/object-curly-newline) rule (refs [#12018](https://github.com/eslint/eslint/issues/12018)) ([#13177](https://github.com/eslint/eslint/issues/13177)) (Luke Lewis)
* [`b398e0b`](https://github.com/eslint/eslint/commit/b398e0b9ff455e4e7d70f19d5ccea5819c21eb86) Docs: add rule comment in [prefer-rest-params](/docs/rules/prefer-rest-params) doc ([#13191](https://github.com/eslint/eslint/issues/13191)) (YeonJuan)
* [`c41de38`](https://github.com/eslint/eslint/commit/c41de382a330d4789488fd2dcf6db5a3163bb5d2) Docs: fix [curly](/docs/rules/curly) multi-or-nest examples with comments (refs [#12972](https://github.com/eslint/eslint/issues/12972)) ([#13151](https://github.com/eslint/eslint/issues/13151)) (Milos Djermanovic)
* [`57221d5`](https://github.com/eslint/eslint/commit/57221d58c60e757062242f30ed574e0502fc7c31) Docs: fix eslint comment in [no-inner-declarations](/docs/rules/no-inner-declarations) examples ([#13152](https://github.com/eslint/eslint/issues/13152)) (Milos Djermanovic)
* [`5dfd4eb`](https://github.com/eslint/eslint/commit/5dfd4eb50d84077a57950f119e5de8976070e49a) Docs: examples with arrow functions in [no-return-assign](/docs/rules/no-return-assign) (fixes [#13135](https://github.com/eslint/eslint/issues/13135)) ([#13138](https://github.com/eslint/eslint/issues/13138)) (Anix)
* [`adc8fa8`](https://github.com/eslint/eslint/commit/adc8fa88c9f223b984a3519ed159a055bf933b18) Docs: clarify exceptions in [spaced-comment](/docs/rules/spaced-comment) (fixes [#13032](https://github.com/eslint/eslint/issues/13032)) ([#13126](https://github.com/eslint/eslint/issues/13126)) (Anix)
* [`b228f95`](https://github.com/eslint/eslint/commit/b228f958afaf507d6f6f99c90b2075b395733839) Docs: Update README team and sponsors (ESLint Jenkins)
* [`6c069f9`](https://github.com/eslint/eslint/commit/6c069f907a04268b671c7f949c04a508df9d42a3) Docs: Add comments to code block in example ([#13089](https://github.com/eslint/eslint/issues/13089)) (Kibeom Kwon)
* [`ee1f053`](https://github.com/eslint/eslint/commit/ee1f0531aa534ef9182cf8586f55ad82aaa55e75) Docs: Fix typo ([#13092](https://github.com/eslint/eslint/issues/13092)) (Max Coplan)
* [`76324ac`](https://github.com/eslint/eslint/commit/76324ace67893c3d7e38a369114d6128df9ffb65) Docs: Add further reading to rule ([#13084](https://github.com/eslint/eslint/issues/13084)) (Max Coplan)
* [`3f7c9bf`](https://github.com/eslint/eslint/commit/3f7c9bf19615122fb776cdd13da532d860bd945a) Docs: clarify variables option in [no-use-before-define](/docs/rules/no-use-before-define) (fixes [#12986](https://github.com/eslint/eslint/issues/12986)) ([#13017](https://github.com/eslint/eslint/issues/13017)) (Anix)
* [`9ac5b9e`](https://github.com/eslint/eslint/commit/9ac5b9edf06d16a9216c2c9b02bb20b6aa8ed0ab) Docs: Clarify node_modules is ignored by default (fixes [#13006](https://github.com/eslint/eslint/issues/13006)) ([#13054](https://github.com/eslint/eslint/issues/13054)) (Mika Kuijpers)
* [`0de91f3`](https://github.com/eslint/eslint/commit/0de91f39a97cdf530cb64edbadde57a2bb41ca86) Docs: removed correct code from incorrect eg ([#13060](https://github.com/eslint/eslint/issues/13060)) (Anix)
* [`af7af9d`](https://github.com/eslint/eslint/commit/af7af9d32ea8073d2d0d726cc8551351261a170f) Docs: Update governance ([#13055](https://github.com/eslint/eslint/issues/13055)) (Nicholas C. Zakas)
* [`79ac6cd`](https://github.com/eslint/eslint/commit/79ac6cd2d8e4c32e03dfea10a957806845058573) Docs: added less confusing explanation for [func-style](/docs/rules/func-style) (fixes [#12900](https://github.com/eslint/eslint/issues/12900)) ([#13004](https://github.com/eslint/eslint/issues/13004)) (Anix)
* [`b8e20d3`](https://github.com/eslint/eslint/commit/b8e20d33b7d6645266beef09cd231afaf5054328) Docs: Mention TypeScript's compiler check ([#12903](https://github.com/eslint/eslint/issues/12903)) (Benny Neugebauer)
* [`e997f32`](https://github.com/eslint/eslint/commit/e997f32b936463ac38e8b0034f764c47502e56a8) Docs: Updated [arrow-parens](/docs/rules/arrow-parens) for minor grammar issue ([#12962](https://github.com/eslint/eslint/issues/12962)) (Tom)
* [`cf14355`](https://github.com/eslint/eslint/commit/cf14355e34a6757e15806f8e493553bd7110fb36) Docs: Fix links to custom parsers doc ([#12965](https://github.com/eslint/eslint/issues/12965)) (Brandon Mills)
* [`f479f6f`](https://github.com/eslint/eslint/commit/f479f6fe2eb95156e22bebfccb39a7fc1f19e9c0) Docs: References correct config file name ([#12885](https://github.com/eslint/eslint/issues/12885)) (Patrick Kilgore)
* [`8d5c434`](https://github.com/eslint/eslint/commit/8d5c434f721142be74c7515aaa935668a15b79b1) Docs: fix category descriptions for site generation (fixes [#12894](https://github.com/eslint/eslint/issues/12894)) ([#12930](https://github.com/eslint/eslint/issues/12930)) (Kai Cataldo)
* [`05380e6`](https://github.com/eslint/eslint/commit/05380e6e7e19a79d26ea6d6b44a8d5ee7cde51c8) Docs: Remove claim about semicolons from docs ([#12944](https://github.com/eslint/eslint/issues/12944)) (Luke Sikina)
* [`824d235`](https://github.com/eslint/eslint/commit/824d23585c205f2993716585cb6f55dfbe4a33f0) Docs: add errorOnUnmatchedPattern option to CLIEngine ([#12834](https://github.com/eslint/eslint/issues/12834)) (Arthur Denner)
* [`33efd71`](https://github.com/eslint/eslint/commit/33efd71d7c3496b4b9cbfe006280527064940826) Docs: Fix spelling mistakes ([#12861](https://github.com/eslint/eslint/issues/12861)) (Bryan Mishkin)
* [`a5b3c5f`](https://github.com/eslint/eslint/commit/a5b3c5fa4edc2312534af0d9f0911f68144f8baf) Docs: Update README team and sponsors (ESLint Jenkins)
* [`d6c313d`](https://github.com/eslint/eslint/commit/d6c313de794ea0671d35b5027288cd2ea456c0b5) Docs: add missing eslint comments in [prefer-regex-literals](/docs/rules/prefer-regex-literals) examples ([#12858](https://github.com/eslint/eslint/issues/12858)) (Milos Djermanovic)
* [`aea1729`](https://github.com/eslint/eslint/commit/aea172998ec4e2af1d9186b6767c3f34428945f4) Docs: Fix anchor links in Node.js API TOC ([#12821](https://github.com/eslint/eslint/issues/12821)) (Matija Marohnić)
* [`02fcc05`](https://github.com/eslint/eslint/commit/02fcc055710e8d69d986f1e682cae2014ad881e2) Docs: Improve [sort-keys](/docs/rules/sort-keys) ([#12791](https://github.com/eslint/eslint/issues/12791)) (Steven Vachon)
* [`25eb703`](https://github.com/eslint/eslint/commit/25eb703c8758563988ffb497a53f89a3ed345399) Docs: fix dead link in [max-lines](/docs/rules/max-lines) rule docs ([#12766](https://github.com/eslint/eslint/issues/12766)) (Christian Bundy)
* [`098b67d`](https://github.com/eslint/eslint/commit/098b67d04a4b4dc8ef4faa6434c6ef5abbde3ed3) Docs: fix minor typo in [brace-style](/docs/rules/brace-style).md ([#12749](https://github.com/eslint/eslint/issues/12749)) (Marko Kaznovac)
* [`b23ad0d`](https://github.com/eslint/eslint/commit/b23ad0d789a909baf8d7c41a35bc53df932eaf30) Docs: change a broken link in working-with-rules.md ([#12732](https://github.com/eslint/eslint/issues/12732)) (Damien Cassou)




## Dependency Upgrades


* [`b98d8bd`](https://github.com/eslint/eslint/commit/b98d8bda4630fe8278c5aa2b6650630770568fe5) Upgrade: eslint-release@2.0.0 ([#13271](https://github.com/eslint/eslint/issues/13271)) (Kai Cataldo)
* [`3eeae56`](https://github.com/eslint/eslint/commit/3eeae565bfb0834a31e5d3a253a17bbf4027cf88) Upgrade: some (dev) deps ([#13155](https://github.com/eslint/eslint/issues/13155)) (薛定谔的猫)
* [`95e1c70`](https://github.com/eslint/eslint/commit/95e1c70cebde210a990ee786ec7ab1c8e522edb8) Upgrade: levn@0.4.1 (fixes [#9366](https://github.com/eslint/eslint/issues/9366)) ([#13140](https://github.com/eslint/eslint/issues/13140)) (Kai Cataldo)
* [`2111c52`](https://github.com/eslint/eslint/commit/2111c52443e7641caad291e0daaea8e2fe6c4562) Upgrade: esquery@1.2.0 ([#13076](https://github.com/eslint/eslint/issues/13076)) (Milos Djermanovic)
* [`95613d4`](https://github.com/eslint/eslint/commit/95613d46b7900b3d9757a7f6959d5dfb262f29fc) Upgrade: espree@6.2.1 ([#13026](https://github.com/eslint/eslint/issues/13026)) (Kai Cataldo)
* [`e632c31`](https://github.com/eslint/eslint/commit/e632c31d7e5363f1347b787702ecd4a85f5c11a2) Upgrade: several dependencies ([#12753](https://github.com/eslint/eslint/issues/12753)) (Toru Nagashima)




## Build Related


* [`8d1b4db`](https://github.com/eslint/eslint/commit/8d1b4db9932cf7c3289187afbb3866a83f9b3f8c) Build: changelog update for 7.0.0-rc.0 (ESLint Jenkins)
* [`2531b80`](https://github.com/eslint/eslint/commit/2531b802a1527ea1084905641a17befcb50350c7) Build: changelog update for 7.0.0-alpha.3 (ESLint Jenkins)
* [`2e8f193`](https://github.com/eslint/eslint/commit/2e8f193ebc970f07ea37d267c8bce02d74c285a8) Build: changelog update for 7.0.0-alpha.2 (ESLint Jenkins)
* [`e9f1073`](https://github.com/eslint/eslint/commit/e9f1073f748f8c22f754d145b1ba193e7ce82215) Build: changelog update for 7.0.0-alpha.1 (ESLint Jenkins)
* [`c8c1b2b`](https://github.com/eslint/eslint/commit/c8c1b2b2efadfcd3c04aaf15bd793c5b4dd84cb6) Build: changelog update for 7.0.0-alpha.0 (ESLint Jenkins)
* [`4e16957`](https://github.com/eslint/eslint/commit/4e169576a526023ee297d5bc8b37eedba229f63d) Build: update browser build ([#12693](https://github.com/eslint/eslint/issues/12693)) (Toru Nagashima)
* [`827259e`](https://github.com/eslint/eslint/commit/827259ea009f98a0fdf3f7ebf1bfb6cd661ce28d) Build: package.json update for eslint-config-eslint release (ESLint Jenkins)




## Chores


* [`401a687`](https://github.com/eslint/eslint/commit/401a68799d9d15145e1c7d92ee04644abec2f15a) Chore: fix rules list for prereleases ([#13230](https://github.com/eslint/eslint/issues/13230)) (Kai Cataldo)
* [`2ce6bed`](https://github.com/eslint/eslint/commit/2ce6bed04cad376003f70447ece4b6578c142bfd) Chore: added tests for nested arrays ([#13145](https://github.com/eslint/eslint/issues/13145)) (Anix)
* [`6b7030b`](https://github.com/eslint/eslint/commit/6b7030b1a1e1e3d1a3953cfa9722074d6a6fc1a9) Chore: Run tests on Node.js v14 ([#13210](https://github.com/eslint/eslint/issues/13210)) (fisker Cheung)
* [`e13256e`](https://github.com/eslint/eslint/commit/e13256e395cc413ce45a66c8562621d48440d8f4) Chore: use espree.latestEcmaVersion in config-initializer ([#13157](https://github.com/eslint/eslint/issues/13157)) (Kai Cataldo)
* [`e4f57b7`](https://github.com/eslint/eslint/commit/e4f57b7d7b8b7441a2217a217dcda1e7bfff516a) Chore: add nested array tests for [array-element-newline](/docs/rules/array-element-newline) ([#13161](https://github.com/eslint/eslint/issues/13161)) (Anix)
* [`bc0c02c`](https://github.com/eslint/eslint/commit/bc0c02cd0368559c7a7b1510eb4620022a4cc31c) Chore: added lock files to gitignore ([#13015](https://github.com/eslint/eslint/issues/13015)) (Anix)
* [`26267ed`](https://github.com/eslint/eslint/commit/26267ed70270ef746b785c09e267f815bf7c596a) Chore: update GitHub Actions ([#12984](https://github.com/eslint/eslint/issues/12984)) (Pig Fang)
* [`472025f`](https://github.com/eslint/eslint/commit/472025f2814d0360fe8d4cddbcba049982e1cd43) Chore: update [space-before-function-paren](/docs/rules/space-before-function-paren) in eslint-config-eslint ([#12966](https://github.com/eslint/eslint/issues/12966)) (Kai Cataldo)
* [`1907e57`](https://github.com/eslint/eslint/commit/1907e57362f7d5f7a02a5a78f24ac3347f868e93) Chore: add Twitter and Open Collective badge ([#12877](https://github.com/eslint/eslint/issues/12877)) (Kai Cataldo)
* [`b7f0d20`](https://github.com/eslint/eslint/commit/b7f0d200c125b3d233ccafaabdaa61c66dc60e3c) Chore: Use consistent badge style ([#12825](https://github.com/eslint/eslint/issues/12825)) (fisker Cheung)
* [`3734a66`](https://github.com/eslint/eslint/commit/3734a669983de7d5107ba8f39b291c6e3116489f) Chore: use ids for messages ([#12859](https://github.com/eslint/eslint/issues/12859)) (Gareth Jones)
* [`0cae920`](https://github.com/eslint/eslint/commit/0cae9203a8077184ad6beb00028fd376cc806f34) Chore: rename shadowed global ([#12862](https://github.com/eslint/eslint/issues/12862)) (Tony Brix)
* [`055b80d`](https://github.com/eslint/eslint/commit/055b80dc89bba2a5ab22f7a27deb40135b5cacfa) Chore: Fix typo in [complexity](/docs/rules/complexity).js ([#12864](https://github.com/eslint/eslint/issues/12864)) (Kyle Shevlin)
* [`9f39ef0`](https://github.com/eslint/eslint/commit/9f39ef0d4b398c7c09ceef89128da448680d587c) Chore: typo in PULL_REQUEST_TEMPLATE.md ([#12848](https://github.com/eslint/eslint/issues/12848)) (Balázs Orbán)
* [`a60d5cd`](https://github.com/eslint/eslint/commit/a60d5cd2325ca72fa1b272b0b90ccd7904b92062) Chore: typo in [no-irregular-whitespace](/docs/rules/no-irregular-whitespace).js ([#12847](https://github.com/eslint/eslint/issues/12847)) (Balázs Orbán)
* [`691d19a`](https://github.com/eslint/eslint/commit/691d19a2872bffab50c0024d488b8cb33504cc83) Chore: add missing `ecmaVersion` 2020/11 type value ([#12833](https://github.com/eslint/eslint/issues/12833)) (Piotr Błażejewicz (Peter Blazejewicz))
* [`f5b9656`](https://github.com/eslint/eslint/commit/f5b96564f732962f46755adbb33c49fae9af6a92) Chore: add test for [no-constant-condition](/docs/rules/no-constant-condition) ([#12836](https://github.com/eslint/eslint/issues/12836)) (Milos Djermanovic)
* [`10a79a6`](https://github.com/eslint/eslint/commit/10a79a672b42d51539bcd6ace482be7afa5f34f8) Chore: Adopt `eslint-plugin/require-meta-docs-description` internally ([#12762](https://github.com/eslint/eslint/issues/12762)) (Bryan Mishkin)
* [`561b6d4`](https://github.com/eslint/eslint/commit/561b6d4726f3e77dd40ba0d340ca7f08429cd2eb) Chore: add prerequisites checklist to PR template ([#12790](https://github.com/eslint/eslint/issues/12790)) (Kai Cataldo)
* [`9dfc850`](https://github.com/eslint/eslint/commit/9dfc8501fb1956c90dc11e6377b4cb38a6bea65d) Chore: Refactor to use messageId in a number of rules ([#12715](https://github.com/eslint/eslint/issues/12715)) (Brad Zacher)
* [`b77b858`](https://github.com/eslint/eslint/commit/b77b8585e33fc4bb438a0e11ca8177c7eb91dbd8) Chore: fix separateRequires tests for [one-var](/docs/rules/one-var) rule ([#12709](https://github.com/eslint/eslint/issues/12709)) (Milos Djermanovic)
* [`e4df7df`](https://github.com/eslint/eslint/commit/e4df7dfb0199badb61d2c03ff4f7e4be735279d9) Chore: add JSDoc types for RuleTester test cases ([#12325](https://github.com/eslint/eslint/issues/12325)) (Chiawen Chen)
* [`4744397`](https://github.com/eslint/eslint/commit/474439720258b1a64b305c31588f803104fa4aaf) Chore: remove unused code in [max-lines-per-function](/docs/rules/max-lines-per-function) ([#12659](https://github.com/eslint/eslint/issues/12659)) (YeonJuan)
* [`39f5a45`](https://github.com/eslint/eslint/commit/39f5a453579b2ad732212edeb71f84ecb0991f97) Chore: add test cases for [for-direction](/docs/rules/for-direction) ([#12698](https://github.com/eslint/eslint/issues/12698)) (YeonJuan)
* [`b340304`](https://github.com/eslint/eslint/commit/b3403045e535921df6d34785a4ce053e14ba27fd) Chore: Add extra test, improve docs ([#12492](https://github.com/eslint/eslint/issues/12492)) (Kevin Partington)


