---
layout: post
title: ESLint v7.0.0-rc.0 released
teaser: "We just pushed ESLint v8.0.0-rc.0, which is a new prerelease version for ESLint v8. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-beta.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

1. This release includes a new asynchronous [ESLint API](https://eslint.org/docs/7.0.0/developer-guide/nodejs-api#eslint-class) for use in Node.js environments. This will allow for the support of ES Module configuration files and plugins and is a prerequisite for implementing [parallel linting](https://github.com/eslint/rfcs/pull/42).
1. Node.js and CommonJS core rules have been deprecated in favor of [eslint-plugin-node](https://github.com/mysticatea/eslint-plugin-node).
1. The reported error location has been fine-tuned in a number of core rules.


### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@7.0.0-rc.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/7.0.0/user-guide/migrating-to-7.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.








## Enhancements


* [`0b1d65a`](https://github.com/eslint/eslint/commit/0b1d65a45aa5dfe08cd596c420490e81b546317e) Update: Improve report location for [array-callback-return](/docs/rules/array-callback-return) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13109](https://github.com/eslint/eslint/issues/13109)) (Milos Djermanovic)
* [`d3aac53`](https://github.com/eslint/eslint/commit/d3aac532f6a24c633f85dedf0e552eabd22d0956) Update: report backtick loc in [no-unexpected-multiline](/docs/rules/no-unexpected-multiline) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13142](https://github.com/eslint/eslint/issues/13142)) (Milos Djermanovic)
* [`bcafd0f`](https://github.com/eslint/eslint/commit/bcafd0f8508e19ab8087a35fac7b97fc4295df3e) Update: Add ESLint API (refs [eslint/rfcs#40](https://github.com/eslint/rfcs/issues/40)) ([#12939](https://github.com/eslint/eslint/issues/12939)) (Kai Cataldo)
* [`5c1bdeb`](https://github.com/eslint/eslint/commit/5c1bdebcf728062fd41583886830c89b65485df9) Update: Improve report location for [getter-return](/docs/rules/getter-return) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13164](https://github.com/eslint/eslint/issues/13164)) (Milos Djermanovic)
* [`e7c1d4b`](https://github.com/eslint/eslint/commit/e7c1d4b2ac56149a517d4b0000230348a641f1d3) Update: deprecate Node.js & CommonJS rules ([#12898](https://github.com/eslint/eslint/issues/12898)) (Kai Cataldo)
* [`af4472f`](https://github.com/eslint/eslint/commit/af4472fed794b86e63730702e4b27294a4118d09) Update: Improve report location for [new-cap](/docs/rules/new-cap) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13136](https://github.com/eslint/eslint/issues/13136)) (Milos Djermanovic)
* [`a784dac`](https://github.com/eslint/eslint/commit/a784dac8bc26f31edbca869b16d6ad91bd4e5cc4) Update: Improve report location [newline-per-chained-call](/docs/rules/newline-per-chained-call) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13116](https://github.com/eslint/eslint/issues/13116)) (Milos Djermanovic)
* [`5e07574`](https://github.com/eslint/eslint/commit/5e07574a91861fdcab6888b4c6829868030c3a39) Update: Improve report location for [space-before-function-paren](/docs/rules/space-before-function-paren) ([#13128](https://github.com/eslint/eslint/issues/13128)) (Chiawen Chen)
* [`17e2fe4`](https://github.com/eslint/eslint/commit/17e2fe425168e675fe7607182615e50527eedf53) Update: Improve error message for fatal fixer errors ([#13120](https://github.com/eslint/eslint/issues/13120)) (Brad Zacher)
* [`438dcbb`](https://github.com/eslint/eslint/commit/438dcbb981214d67e8848006ce45afc0fbfa1705) Update: Improve report location for [comma-style](/docs/rules/comma-style) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13111](https://github.com/eslint/eslint/issues/13111)) (Chiawen Chen)
* [`85b7254`](https://github.com/eslint/eslint/commit/85b72548c0c893499c787b82f404348e1b50354d) Update: [no-inner-declarations](/docs/rules/no-inner-declarations) false negative in non-block (fixes [#12222](https://github.com/eslint/eslint/issues/12222)) ([#13062](https://github.com/eslint/eslint/issues/13062)) (Anix)
* [`6631ef1`](https://github.com/eslint/eslint/commit/6631ef1678bbdd48680fb3025c3692abd0aeec4a) Update: Improve report location for [no-empty-function](/docs/rules/no-empty-function) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13121](https://github.com/eslint/eslint/issues/13121)) (Milos Djermanovic)




## Bug Fixes


* [`d85e291`](https://github.com/eslint/eslint/commit/d85e291d1b56960373031f2562547df7285444f7) Fix: [yoda](/docs/rules/yoda) left string fix for exceptRange (fixes [#12883](https://github.com/eslint/eslint/issues/12883)) ([#13052](https://github.com/eslint/eslint/issues/13052)) (Anix)
* [`8e7a2d9`](https://github.com/eslint/eslint/commit/8e7a2d93595cfe0c1597af0e7873853369251c0b) Fix: [func-call-spacing](/docs/rules/func-call-spacing) "never" reports wrong message (fixes [#13190](https://github.com/eslint/eslint/issues/13190)) ([#13193](https://github.com/eslint/eslint/issues/13193)) (Milos Djermanovic)
* [`ebc28d7`](https://github.com/eslint/eslint/commit/ebc28d76658f1f3e4e8d56e70a25752b5d4a6686) Fix: Remove default .js from --ext CLI option ([#13176](https://github.com/eslint/eslint/issues/13176)) (Brandon Mills)
* [`c9a5035`](https://github.com/eslint/eslint/commit/c9a503571a4662f6c2d31cabc7fd7819ec388150) Fix: newBasePath should be an absolute path (fixes [#12850](https://github.com/eslint/eslint/issues/12850)) ([#13078](https://github.com/eslint/eslint/issues/13078)) (Nick Harris)
* [`301b450`](https://github.com/eslint/eslint/commit/301b450ecd1985ae84d1915124f4638ab2a2e6de) Fix: [no-extra-parens](/docs/rules/no-extra-parens) export default sequence expression false positive ([#13096](https://github.com/eslint/eslint/issues/13096)) (Milos Djermanovic)
* [`bfa811c`](https://github.com/eslint/eslint/commit/bfa811ceee801fe8ba212a5c879e13743146e909) Fix: init error in extending recommended config (fixes [#12707](https://github.com/eslint/eslint/issues/12707)) ([#12738](https://github.com/eslint/eslint/issues/12738)) (YeonJuan)
* [`7551f0c`](https://github.com/eslint/eslint/commit/7551f0c6fd12f0295cc7d6377bf1899c092e79d8) Fix: no check for shadowed Object (fixes [#12809](https://github.com/eslint/eslint/issues/12809)) ([#13115](https://github.com/eslint/eslint/issues/13115)) (Anix)
* [`988d842`](https://github.com/eslint/eslint/commit/988d8428811934943ce13b2d8b833d795ac2bb4a) Fix: add end location to report in [no-useless-concat](/docs/rules/no-useless-concat) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13110](https://github.com/eslint/eslint/issues/13110)) (Milos Djermanovic)




## Documentation


* [`56d2bee`](https://github.com/eslint/eslint/commit/56d2beea0ea0b6395a6d4a3e116ea6a964ff92f3) Docs: fix typos ([#13204](https://github.com/eslint/eslint/issues/13204)) (Nitin Kumar)
* [`516f253`](https://github.com/eslint/eslint/commit/516f253729daeeb9da5de5e9b38606ff9c1aae71) Docs: Adds import example for [object-curly-newline](/docs/rules/object-curly-newline) rule (refs [#12018](https://github.com/eslint/eslint/issues/12018)) ([#13177](https://github.com/eslint/eslint/issues/13177)) (Luke Lewis)
* [`b398e0b`](https://github.com/eslint/eslint/commit/b398e0b9ff455e4e7d70f19d5ccea5819c21eb86) Docs: add rule comment in [prefer-rest-params](/docs/rules/prefer-rest-params) doc ([#13191](https://github.com/eslint/eslint/issues/13191)) (YeonJuan)
* [`c41de38`](https://github.com/eslint/eslint/commit/c41de382a330d4789488fd2dcf6db5a3163bb5d2) Docs: fix [curly](/docs/rules/curly) multi-or-nest examples with comments (refs [#12972](https://github.com/eslint/eslint/issues/12972)) ([#13151](https://github.com/eslint/eslint/issues/13151)) (Milos Djermanovic)
* [`57221d5`](https://github.com/eslint/eslint/commit/57221d58c60e757062242f30ed574e0502fc7c31) Docs: fix eslint comment in [no-inner-declarations](/docs/rules/no-inner-declarations) examples ([#13152](https://github.com/eslint/eslint/issues/13152)) (Milos Djermanovic)
* [`5dfd4eb`](https://github.com/eslint/eslint/commit/5dfd4eb50d84077a57950f119e5de8976070e49a) Docs: examples with arrow functions in [no-return-assign](/docs/rules/no-return-assign) (fixes [#13135](https://github.com/eslint/eslint/issues/13135)) ([#13138](https://github.com/eslint/eslint/issues/13138)) (Anix)
* [`adc8fa8`](https://github.com/eslint/eslint/commit/adc8fa88c9f223b984a3519ed159a055bf933b18) Docs: clarify exceptions in [spaced-comment](/docs/rules/spaced-comment) (fixes [#13032](https://github.com/eslint/eslint/issues/13032)) ([#13126](https://github.com/eslint/eslint/issues/13126)) (Anix)
* [`b228f95`](https://github.com/eslint/eslint/commit/b228f958afaf507d6f6f99c90b2075b395733839) Docs: Update README team and sponsors (ESLint Jenkins)




## Dependency Upgrades


* [`3eeae56`](https://github.com/eslint/eslint/commit/3eeae565bfb0834a31e5d3a253a17bbf4027cf88) Upgrade: some (dev) deps ([#13155](https://github.com/eslint/eslint/issues/13155)) (薛定谔的猫)
* [`95e1c70`](https://github.com/eslint/eslint/commit/95e1c70cebde210a990ee786ec7ab1c8e522edb8) Upgrade: levn@0.4.1 (fixes [#9366](https://github.com/eslint/eslint/issues/9366)) ([#13140](https://github.com/eslint/eslint/issues/13140)) (Kai Cataldo)






## Chores


* [`2ce6bed`](https://github.com/eslint/eslint/commit/2ce6bed04cad376003f70447ece4b6578c142bfd) Chore: added tests for nested arrays ([#13145](https://github.com/eslint/eslint/issues/13145)) (Anix)
* [`6b7030b`](https://github.com/eslint/eslint/commit/6b7030b1a1e1e3d1a3953cfa9722074d6a6fc1a9) Chore: Run tests on Node.js v14 ([#13210](https://github.com/eslint/eslint/issues/13210)) (fisker Cheung)
* [`e13256e`](https://github.com/eslint/eslint/commit/e13256e395cc413ce45a66c8562621d48440d8f4) Chore: use espree.latestEcmaVersion in config-initializer ([#13157](https://github.com/eslint/eslint/issues/13157)) (Kai Cataldo)
* [`e4f57b7`](https://github.com/eslint/eslint/commit/e4f57b7d7b8b7441a2217a217dcda1e7bfff516a) Chore: add nested array tests for [array-element-newline](/docs/rules/array-element-newline) ([#13161](https://github.com/eslint/eslint/issues/13161)) (Anix)


