---
layout: post
title: ESLint v7.0.0-alpha.3 released
teaser: "We just pushed ESLint v7.0.0-alpha.3, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

This release contains the following breaking changes:

1. [Making RuleTester checks stricter](https://eslint.org/blog/2020/02/whats-coming-in-eslint-7.0.0#stricter-ruletester).
1. [Plugins are now loaded relative to the configs that reference them](https://eslint.org/blog/2020/02/whats-coming-in-eslint-7.0.0#plugins-loaded-from-config-file-directory).
1. [Use the current working directory as base path when using `--config`](https://eslint.org/blog/2020/02/whats-coming-in-eslint-7.0.0#updating-the-base-path-when-using-config-or-ignore-path).

It also adds support for the following new language features:

1. Core rules now support `globalThis`.


### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@7.0.0-alpha.3 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](https://github.com/eslint/eslint/pull/12692) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`78c8cda`](https://github.com/eslint/eslint/commit/78c8cda5a5d82f5f8548c4528a6438d29756bb71) Breaking: RuleTester Improvements (refs [eslint/rfcs#25](https://github.com/eslint/rfcs/issues/25)) ([#12955](https://github.com/eslint/eslint/issues/12955)) (Milos Djermanovic)
* [`185982d`](https://github.com/eslint/eslint/commit/185982d5615d325ae8b45c2360d5847df4098bda) Breaking: improve plugin resolving (refs [eslint/rfcs#47](https://github.com/eslint/rfcs/issues/47)) ([#12922](https://github.com/eslint/eslint/issues/12922)) (Toru Nagashima)
* [`48b122f`](https://github.com/eslint/eslint/commit/48b122f450b14dd27afef4c8115c69fca4f02be1) Breaking: change relative paths with --config (refs [eslint/rfcs#37](https://github.com/eslint/rfcs/issues/37)) ([#12887](https://github.com/eslint/eslint/issues/12887)) (Toru Nagashima)






## Enhancements


* [`e0f1b6c`](https://github.com/eslint/eslint/commit/e0f1b6c3d62f725b99b8c07654603b559ba43ba9) Update: stricter array index check in [no-magic-numbers](/docs/rules/no-magic-numbers) (fixes [#12845](https://github.com/eslint/eslint/issues/12845)) ([#12851](https://github.com/eslint/eslint/issues/12851)) (Milos Djermanovic)
* [`362713c`](https://github.com/eslint/eslint/commit/362713c04aa89092b2b98a77fa94a75b3c933fc6) Update: Improve report location for [template-curly-spacing](/docs/rules/template-curly-spacing) ([#12813](https://github.com/eslint/eslint/issues/12813)) (Milos Djermanovic)
* [`105384c`](https://github.com/eslint/eslint/commit/105384ccc11dcd7303104fb5a347eda1d4d48357) Update: report operator location in [operator-linebreak](/docs/rules/operator-linebreak) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13102](https://github.com/eslint/eslint/issues/13102)) (Milos Djermanovic)
* [`081e240`](https://github.com/eslint/eslint/commit/081e24022a40d9a026ddd2a85c68cb8c3f18dc53) Update: support globalThis in [no-implied-eval](/docs/rules/no-implied-eval) (fixes [#12670](https://github.com/eslint/eslint/issues/12670)) ([#13105](https://github.com/eslint/eslint/issues/13105)) (YeonJuan)
* [`a1370ab`](https://github.com/eslint/eslint/commit/a1370abed72e1fb93e601816d981fa6e46204afb) Update: Report constructor calls in [no-obj-calls](/docs/rules/no-obj-calls) ([#12909](https://github.com/eslint/eslint/issues/12909)) (Milos Djermanovic)
* [`085979f`](https://github.com/eslint/eslint/commit/085979fed9a5e24a87e4d92ee79272b59211d03f) Update: consider env in [no-implied-eval](/docs/rules/no-implied-eval) (fixes [#12733](https://github.com/eslint/eslint/issues/12733)) ([#12757](https://github.com/eslint/eslint/issues/12757)) (YeonJuan)
* [`e90b29b`](https://github.com/eslint/eslint/commit/e90b29bb1f41d4e5767e33d03db5984f036586ed) Update: Allow testing Suggestions with data in RuleTester (fixes [#12606](https://github.com/eslint/eslint/issues/12606)) ([#12635](https://github.com/eslint/eslint/issues/12635)) (Milos Djermanovic)
* [`183e300`](https://github.com/eslint/eslint/commit/183e3006841c29efdd245c45a72e6cefac86ae35) Update: support globalThis (refs [#12670](https://github.com/eslint/eslint/issues/12670)) ([#12774](https://github.com/eslint/eslint/issues/12774)) (YeonJuan)
* [`1299705`](https://github.com/eslint/eslint/commit/12997058626b5167ba4b9d2ae0d0ea965a01c4be) Update: acorn version ([#13016](https://github.com/eslint/eslint/issues/13016)) (Idan Avrahami)




## Bug Fixes


* [`29f32db`](https://github.com/eslint/eslint/commit/29f32db68c921a857e17ae627923d87b9c8708de) Fix: Change error message logic for implicit file ignore (fixes [#12873](https://github.com/eslint/eslint/issues/12873)) ([#12878](https://github.com/eslint/eslint/issues/12878)) (Scott Hardin)
* [`eb1a43c`](https://github.com/eslint/eslint/commit/eb1a43ce3113c906800192c3ef766d2ff188776f) Fix: [require-await](/docs/rules/require-await) ignore async generators (fixes [#12459](https://github.com/eslint/eslint/issues/12459)) ([#13048](https://github.com/eslint/eslint/issues/13048)) (Anix)
* [`920465b`](https://github.com/eslint/eslint/commit/920465b5d8d291df8bce7eef8a066b1dd43d8cae) Fix: getNameLocationInGlobalDirectiveComment end location (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13086](https://github.com/eslint/eslint/issues/13086)) (Milos Djermanovic)
* [`ae14a02`](https://github.com/eslint/eslint/commit/ae14a021bbea5117fe366ae4ed235e8f08dc65a8) Fix: add end location to report in [no-extra-bind](/docs/rules/no-extra-bind) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13083](https://github.com/eslint/eslint/issues/13083)) (Milos Djermanovic)
* [`0c20bc0`](https://github.com/eslint/eslint/commit/0c20bc068e608869981a10711bba88ffde1539d8) Fix: check assignment property target in [camelcase](/docs/rules/camelcase) (fixes [#13025](https://github.com/eslint/eslint/issues/13025)) ([#13027](https://github.com/eslint/eslint/issues/13027)) (YeonJuan)
* [`8d50a7d`](https://github.com/eslint/eslint/commit/8d50a7d82244d4912f3eab62a66c81c76c44a9da) Fix: add end location to report in [no-prototype-builtins](/docs/rules/no-prototype-builtins) (refs [#12334](https://github.com/eslint/eslint/issues/12334)) ([#13087](https://github.com/eslint/eslint/issues/13087)) (Milos Djermanovic)
* [`3e4e7f8`](https://github.com/eslint/eslint/commit/3e4e7f8d429dc70b78c0aefaa37f9c22a1e5fc0f) Fix: incorrect logic for required parens in [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) fixer ([#13061](https://github.com/eslint/eslint/issues/13061)) (Milos Djermanovic)
* [`aef9488`](https://github.com/eslint/eslint/commit/aef9488c07d3da4becff6e8d6918824b53086d86) Fix: allow references to external globals in [id-blacklist](/docs/rules/id-blacklist) (fixes [#12567](https://github.com/eslint/eslint/issues/12567)) ([#12987](https://github.com/eslint/eslint/issues/12987)) (Milos Djermanovic)
* [`4955c50`](https://github.com/eslint/eslint/commit/4955c50dc9e89b4077b28e35f065d45e89bdccd7) Fix: remove type arguments in [prefer-object-spread](/docs/rules/prefer-object-spread) (fixes [#13058](https://github.com/eslint/eslint/issues/13058)) ([#13063](https://github.com/eslint/eslint/issues/13063)) (Milos Djermanovic)
* [`dbe357d`](https://github.com/eslint/eslint/commit/dbe357de199620675446464f6fd0e35064c4d247) Fix: check template literal in [prefer-numeric-literals](/docs/rules/prefer-numeric-literals) (fixes [#13045](https://github.com/eslint/eslint/issues/13045)) ([#13046](https://github.com/eslint/eslint/issues/13046)) (YeonJuan)
* [`2260611`](https://github.com/eslint/eslint/commit/2260611e616bdc2a0bf16d508b60a50772ce7fbb) Fix: added async in allow method in [no-empty-function](/docs/rules/no-empty-function) (fixes [#12768](https://github.com/eslint/eslint/issues/12768)) ([#13036](https://github.com/eslint/eslint/issues/13036)) (Anix)
* [`7224eee`](https://github.com/eslint/eslint/commit/7224eee3ff4b4378d3439deb038bf34b116fa48b) Fix: [no-plusplus](/docs/rules/no-plusplus) allow comma operands in for afterthought (fixes [#13005](https://github.com/eslint/eslint/issues/13005)) ([#13024](https://github.com/eslint/eslint/issues/13024)) (Milos Djermanovic)
* [`7598cf8`](https://github.com/eslint/eslint/commit/7598cf816bd854de1dd7d96cf00dec6ecc4564ac) Fix: Newline before eof when creating config via --init ([#12952](https://github.com/eslint/eslint/issues/12952)) (Andreas Lind)
* [`0243549`](https://github.com/eslint/eslint/commit/0243549db4d237cb78e720d55a9cae89b91f6830) Fix: [camelcase](/docs/rules/camelcase) false positive with computed property (fixes [#13022](https://github.com/eslint/eslint/issues/13022)) ([#13023](https://github.com/eslint/eslint/issues/13023)) (Milos Djermanovic)
* [`6cef0d5`](https://github.com/eslint/eslint/commit/6cef0d50a0d131bc8897799a54e1af1d38606db4) Fix: Check division operator in astUtils.canTokensBeAdjacent ([#12879](https://github.com/eslint/eslint/issues/12879)) (Milos Djermanovic)




## Documentation


* [`6c069f9`](https://github.com/eslint/eslint/commit/6c069f907a04268b671c7f949c04a508df9d42a3) Docs: Add comments to code block in example ([#13089](https://github.com/eslint/eslint/issues/13089)) (Kibeom Kwon)
* [`ee1f053`](https://github.com/eslint/eslint/commit/ee1f0531aa534ef9182cf8586f55ad82aaa55e75) Docs: Fix typo ([#13092](https://github.com/eslint/eslint/issues/13092)) (Max Coplan)
* [`76324ac`](https://github.com/eslint/eslint/commit/76324ace67893c3d7e38a369114d6128df9ffb65) Docs: Add further reading to rule ([#13084](https://github.com/eslint/eslint/issues/13084)) (Max Coplan)
* [`3f7c9bf`](https://github.com/eslint/eslint/commit/3f7c9bf19615122fb776cdd13da532d860bd945a) Docs: clarify variables option in [no-use-before-define](/docs/rules/no-use-before-define) (fixes [#12986](https://github.com/eslint/eslint/issues/12986)) ([#13017](https://github.com/eslint/eslint/issues/13017)) (Anix)
* [`9ac5b9e`](https://github.com/eslint/eslint/commit/9ac5b9edf06d16a9216c2c9b02bb20b6aa8ed0ab) Docs: Clarify node_modules is ignored by default (fixes [#13006](https://github.com/eslint/eslint/issues/13006)) ([#13054](https://github.com/eslint/eslint/issues/13054)) (Mika Kuijpers)
* [`0de91f3`](https://github.com/eslint/eslint/commit/0de91f39a97cdf530cb64edbadde57a2bb41ca86) Docs: removed correct code from incorrect eg ([#13060](https://github.com/eslint/eslint/issues/13060)) (Anix)
* [`af7af9d`](https://github.com/eslint/eslint/commit/af7af9d32ea8073d2d0d726cc8551351261a170f) Docs: Update governance ([#13055](https://github.com/eslint/eslint/issues/13055)) (Nicholas C. Zakas)
* [`79ac6cd`](https://github.com/eslint/eslint/commit/79ac6cd2d8e4c32e03dfea10a957806845058573) Docs: added less confusing explanation for [func-style](/docs/rules/func-style) (fixes [#12900](https://github.com/eslint/eslint/issues/12900)) ([#13004](https://github.com/eslint/eslint/issues/13004)) (Anix)




## Dependency Upgrades


* [`2111c52`](https://github.com/eslint/eslint/commit/2111c52443e7641caad291e0daaea8e2fe6c4562) Upgrade: esquery@1.2.0 ([#13076](https://github.com/eslint/eslint/issues/13076)) (Milos Djermanovic)
* [`95613d4`](https://github.com/eslint/eslint/commit/95613d46b7900b3d9757a7f6959d5dfb262f29fc) Upgrade: espree@6.2.1 ([#13026](https://github.com/eslint/eslint/issues/13026)) (Kai Cataldo)






## Chores


* [`bc0c02c`](https://github.com/eslint/eslint/commit/bc0c02cd0368559c7a7b1510eb4620022a4cc31c) Chore: added lock files to gitignore ([#13015](https://github.com/eslint/eslint/issues/13015)) (Anix)
* [`26267ed`](https://github.com/eslint/eslint/commit/26267ed70270ef746b785c09e267f815bf7c596a) Chore: update GitHub Actions ([#12984](https://github.com/eslint/eslint/issues/12984)) (Pig Fang)
* [`472025f`](https://github.com/eslint/eslint/commit/472025f2814d0360fe8d4cddbcba049982e1cd43) Chore: update [space-before-function-paren](/docs/rules/space-before-function-paren) in eslint-config-eslint ([#12966](https://github.com/eslint/eslint/issues/12966)) (Kai Cataldo)


