---
layout: post
title: ESLint v7.0.0-alpha.1 released
teaser: "We just pushed ESLint v7.0.0-alpha.1, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

Most of the highlights of this release are breaking changes, and are discussed further in the [migration guide](https://github.com/eslint/eslint/pull/12692).

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@7.0.0-alpha.1 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](https://github.com/eslint/eslint/pull/12692) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`4293229`](https://github.com/eslint/eslint/commit/4293229709dde105692347241513766e953664dd) Breaking: [use-isnan](/docs/rules/use-isnan) enforceForSwitchCase default `true` (fixes [#12810](https://github.com/eslint/eslint/issues/12810)) ([#12913](https://github.com/eslint/eslint/issues/12913)) (Milos Djermanovic)
* [`cf38d0d`](https://github.com/eslint/eslint/commit/cf38d0d939b62f3670cdd59f0143fd896fccd771) Breaking: change default ignore pattern (refs [eslint/rfcs#51](https://github.com/eslint/rfcs/issues/51)) ([#12888](https://github.com/eslint/eslint/issues/12888)) (Toru Nagashima)
* [`bfe1dc4`](https://github.com/eslint/eslint/commit/bfe1dc4e614640cb69032afbb5851c1493f537e3) Breaking: [no-dupe-class-members](/docs/rules/no-dupe-class-members) checks some computed keys (fixes [#12808](https://github.com/eslint/eslint/issues/12808)) ([#12837](https://github.com/eslint/eslint/issues/12837)) (Milos Djermanovic)
* [`c2217c0`](https://github.com/eslint/eslint/commit/c2217c04d6c82b160a21b00fca39c8acec543403) Breaking: make [`radix`](/docs/rules/radix) rule stricter ([#12608](https://github.com/eslint/eslint/issues/12608)) (fisker Cheung)






## Enhancements


* [`1ee6b63`](https://github.com/eslint/eslint/commit/1ee6b6388305a8671c8d4c3cf30c2dbf18a1ff7e) Update: check template literal in [yoda](/docs/rules/yoda) (fixes [#12863](https://github.com/eslint/eslint/issues/12863)) ([#12876](https://github.com/eslint/eslint/issues/12876)) (YeonJuan)
* [`439c833`](https://github.com/eslint/eslint/commit/439c83342c364ba3ce5168d54e165b1fe3e35630) Update: [array-callback-return](/docs/rules/array-callback-return) checks Array.forEach (fixes [#12551](https://github.com/eslint/eslint/issues/12551)) ([#12646](https://github.com/eslint/eslint/issues/12646)) (Gabriel R Sezefredo)
* [`03a69db`](https://github.com/eslint/eslint/commit/03a69dbe86d5b5768a310105416ae726822e3c1c) Update: check template literal in [no-proto](/docs/rules/no-proto), [no-iterator](/docs/rules/no-iterator) (fixes [#12801](https://github.com/eslint/eslint/issues/12801)) ([#12806](https://github.com/eslint/eslint/issues/12806)) (YeonJuan)
* [`562e784`](https://github.com/eslint/eslint/commit/562e7845946a490f2e173a0bcd1af631070a4eef) Update: fix [no-magic-numbers](/docs/rules/no-magic-numbers) false negative with ignoreArrayIndexes ([#12805](https://github.com/eslint/eslint/issues/12805)) (Milos Djermanovic)
* [`0460748`](https://github.com/eslint/eslint/commit/0460748cda67ddc4a4cb0db3cdf187a742d09bf8) Update: check template literal in [no-constant-condition](/docs/rules/no-constant-condition) (fixes [#12815](https://github.com/eslint/eslint/issues/12815)) ([#12816](https://github.com/eslint/eslint/issues/12816)) (YeonJuan)




## Bug Fixes


* [`1f1424c`](https://github.com/eslint/eslint/commit/1f1424cb200e609d58645f6c54739e11469e6265) Fix: fix inconsistently works option in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#12717](https://github.com/eslint/eslint/issues/12717)) ([#12843](https://github.com/eslint/eslint/issues/12843)) (YeonJuan)
* [`b5adcaa`](https://github.com/eslint/eslint/commit/b5adcaab93f388f1d8e9d35d6f5e8c2994240850) Fix: make YieldExpression throwable (fixes [#12880](https://github.com/eslint/eslint/issues/12880)) ([#12897](https://github.com/eslint/eslint/issues/12897)) (YeonJuan)
* [`95e0586`](https://github.com/eslint/eslint/commit/95e0586c95e6953d11983d1d11891ed30318109a) Fix: [id-blacklist](/docs/rules/id-blacklist) false positives on renamed imports ([#12831](https://github.com/eslint/eslint/issues/12831)) (Milos Djermanovic)
* [`dadc892`](https://github.com/eslint/eslint/commit/dadc8927820576c60b48bcbc7d5a9056a6279d30) Fix: [operator-assignment](/docs/rules/operator-assignment) crash on adjacent division assignment ([#12844](https://github.com/eslint/eslint/issues/12844)) (Milos Djermanovic)
* [`a9d92f9`](https://github.com/eslint/eslint/commit/a9d92f991d69902a9150db373590e2ed54dec988) Fix: [radix](/docs/rules/radix) rule crash on disabled globals ([#12824](https://github.com/eslint/eslint/issues/12824)) (Milos Djermanovic)
* [`533c114`](https://github.com/eslint/eslint/commit/533c1140dc98bebdc3ae8334ab2e6c27c7df0c21) Fix: [multiline-comment-style](/docs/rules/multiline-comment-style) rule add extra space after * (fixes [#12785](https://github.com/eslint/eslint/issues/12785)) ([#12823](https://github.com/eslint/eslint/issues/12823)) (Karthik Priyadarshan)
* [`80309c3`](https://github.com/eslint/eslint/commit/80309c3791188ac5d1c4eebc99ede323a55336e6) Fix: [no-constant-condition](/docs/rules/no-constant-condition) doesn't introspect arrays (fixes [#12225](https://github.com/eslint/eslint/issues/12225)) ([#12307](https://github.com/eslint/eslint/issues/12307)) (Sean Gray)




## Documentation


* [`f702b1a`](https://github.com/eslint/eslint/commit/f702b1a54820d2b4e4993dcded99f551a98b490f) Docs: Add missing plugin reference ([#12796](https://github.com/eslint/eslint/issues/12796)) (Eduard Bardají Puig)
* [`824d235`](https://github.com/eslint/eslint/commit/824d23585c205f2993716585cb6f55dfbe4a33f0) Docs: add errorOnUnmatchedPattern option to CLIEngine ([#12834](https://github.com/eslint/eslint/issues/12834)) (Arthur Denner)
* [`33efd71`](https://github.com/eslint/eslint/commit/33efd71d7c3496b4b9cbfe006280527064940826) Docs: Fix spelling mistakes ([#12861](https://github.com/eslint/eslint/issues/12861)) (Bryan Mishkin)
* [`a5b3c5f`](https://github.com/eslint/eslint/commit/a5b3c5fa4edc2312534af0d9f0911f68144f8baf) Docs: Update README team and sponsors (ESLint Jenkins)
* [`d6c313d`](https://github.com/eslint/eslint/commit/d6c313de794ea0671d35b5027288cd2ea456c0b5) Docs: add missing eslint comments in [prefer-regex-literals](/docs/rules/prefer-regex-literals) examples ([#12858](https://github.com/eslint/eslint/issues/12858)) (Milos Djermanovic)
* [`aea1729`](https://github.com/eslint/eslint/commit/aea172998ec4e2af1d9186b6767c3f34428945f4) Docs: Fix anchor links in Node.js API TOC ([#12821](https://github.com/eslint/eslint/issues/12821)) (Matija Marohnić)








## Chores


* [`1907e57`](https://github.com/eslint/eslint/commit/1907e57362f7d5f7a02a5a78f24ac3347f868e93) Chore: add Twitter and Open Collective badge ([#12877](https://github.com/eslint/eslint/issues/12877)) (Kai Cataldo)
* [`b7f0d20`](https://github.com/eslint/eslint/commit/b7f0d200c125b3d233ccafaabdaa61c66dc60e3c) Chore: Use consistent badge style ([#12825](https://github.com/eslint/eslint/issues/12825)) (fisker Cheung)
* [`3734a66`](https://github.com/eslint/eslint/commit/3734a669983de7d5107ba8f39b291c6e3116489f) Chore: use ids for messages ([#12859](https://github.com/eslint/eslint/issues/12859)) (Gareth Jones)
* [`0cae920`](https://github.com/eslint/eslint/commit/0cae9203a8077184ad6beb00028fd376cc806f34) Chore: rename shadowed global ([#12862](https://github.com/eslint/eslint/issues/12862)) (Tony Brix)
* [`055b80d`](https://github.com/eslint/eslint/commit/055b80dc89bba2a5ab22f7a27deb40135b5cacfa) Chore: Fix typo in [complexity](/docs/rules/complexity).js ([#12864](https://github.com/eslint/eslint/issues/12864)) (Kyle Shevlin)
* [`9f39ef0`](https://github.com/eslint/eslint/commit/9f39ef0d4b398c7c09ceef89128da448680d587c) Chore: typo in PULL_REQUEST_TEMPLATE.md ([#12848](https://github.com/eslint/eslint/issues/12848)) (Balázs Orbán)
* [`a60d5cd`](https://github.com/eslint/eslint/commit/a60d5cd2325ca72fa1b272b0b90ccd7904b92062) Chore: typo in [no-irregular-whitespace](/docs/rules/no-irregular-whitespace).js ([#12847](https://github.com/eslint/eslint/issues/12847)) (Balázs Orbán)
* [`691d19a`](https://github.com/eslint/eslint/commit/691d19a2872bffab50c0024d488b8cb33504cc83) Chore: add missing `ecmaVersion` 2020/11 type value ([#12833](https://github.com/eslint/eslint/issues/12833)) (Piotr Błażejewicz (Peter Blazejewicz))
* [`f5b9656`](https://github.com/eslint/eslint/commit/f5b96564f732962f46755adbb33c49fae9af6a92) Chore: add test for [no-constant-condition](/docs/rules/no-constant-condition) ([#12836](https://github.com/eslint/eslint/issues/12836)) (Milos Djermanovic)
* [`10a79a6`](https://github.com/eslint/eslint/commit/10a79a672b42d51539bcd6ace482be7afa5f34f8) Chore: Adopt `eslint-plugin/require-meta-docs-description` internally ([#12762](https://github.com/eslint/eslint/issues/12762)) (Bryan Mishkin)
