---
layout: post
title: ESLint v7.0.0-alpha.0 released
teaser: "We just pushed ESLint v7.0.0-alpha.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

Most of the highlights of this release are breaking changes, and are discussed further in the [migration guide](https://github.com/eslint/eslint/pull/12692).

In addition to the breaking changes, we have three new rules:

* [default-case-last](/docs/7.0.0/rules/default-case-last)
* [no-useless-backreference](/docs/7.0.0/rules/no-useless-backreference)
* [no-restricted-exports](/docs/7.0.0/rules/no-restricted-exports)

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@7.0.0-alpha.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we're working on a [migration guide](https://github.com/eslint/eslint/pull/12692) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`1aa021d`](https://github.com/eslint/eslint/commit/1aa021d77fdd2c68d7b7d2f4603252110c414b32) Breaking: lint `overrides` files (fixes [#10828](https://github.com/eslint/eslint/issues/10828), refs [eslint/rfcs#20](https://github.com/eslint/rfcs/issues/20)) ([#12677](https://github.com/eslint/eslint/issues/12677)) (Toru Nagashima)
* [`b50179d`](https://github.com/eslint/eslint/commit/b50179def3fedbd95fdeab25e32c2511867eb760) Breaking: Check assignment targets in [no-extra-parens](/docs/rules/no-extra-parens) ([#12490](https://github.com/eslint/eslint/issues/12490)) (Milos Djermanovic)
* [`d86a5bb`](https://github.com/eslint/eslint/commit/d86a5bbb1987d858d4963f647b0af5c1fd924b4f) Breaking: Check flatMap in [array-callback-return](/docs/rules/array-callback-return) (fixes [#12235](https://github.com/eslint/eslint/issues/12235)) ([#12765](https://github.com/eslint/eslint/issues/12765)) (Milos Djermanovic)
* [`cf46df7`](https://github.com/eslint/eslint/commit/cf46df70158a4ed4c09d5c9d655c07dc6df3ff5e) Breaking: description in directive comments (refs [eslint/rfcs#33](https://github.com/eslint/rfcs/issues/33)) ([#12699](https://github.com/eslint/eslint/issues/12699)) (Toru Nagashima)
* [`7350589`](https://github.com/eslint/eslint/commit/7350589a5bdfc9d75d1ff19364f476eec44c3911) Breaking: some rules recognize bigint literals (fixes [#11803](https://github.com/eslint/eslint/issues/11803)) ([#12701](https://github.com/eslint/eslint/issues/12701)) (Toru Nagashima)
* [`1118fce`](https://github.com/eslint/eslint/commit/1118fceb49af3436b8dcd0c6089f913cedf9a329) Breaking: runtime-deprecation on '~/.eslintrc' (refs [eslint/rfcs#32](https://github.com/eslint/rfcs/issues/32)) ([#12678](https://github.com/eslint/eslint/issues/12678)) (Toru Nagashima)
* [`2c28fbb`](https://github.com/eslint/eslint/commit/2c28fbbb563a44282bef0c9fcc9be29d611cc83b) Breaking: drop Node.js 8 support (refs [eslint/rfcs#44](https://github.com/eslint/rfcs/issues/44)) ([#12700](https://github.com/eslint/eslint/issues/12700)) (Toru Nagashima)




## Features


* [`f9774ec`](https://github.com/eslint/eslint/commit/f9774ec11b0ebe63fb16a97b97890efb84699548) New: Add [default-case-last](/docs/rules/default-case-last) rule (fixes [#12665](https://github.com/eslint/eslint/issues/12665)) ([#12668](https://github.com/eslint/eslint/issues/12668)) (Milos Djermanovic)
* [`a1d999c`](https://github.com/eslint/eslint/commit/a1d999c6b4e51c317ad409110be7be214ff9f7c6) New: Add [no-useless-backreference](/docs/rules/no-useless-backreference) rule (fixes [#12673](https://github.com/eslint/eslint/issues/12673)) ([#12690](https://github.com/eslint/eslint/issues/12690)) (Milos Djermanovic)
* [`985dac3`](https://github.com/eslint/eslint/commit/985dac35e3c367f0f99d1f0e766e06a1d9818dd4) New: Add [no-restricted-exports](/docs/rules/no-restricted-exports) rule (fixes [#10428](https://github.com/eslint/eslint/issues/10428)) ([#12546](https://github.com/eslint/eslint/issues/12546)) (Milos Djermanovic)




## Enhancements


* [`e59d775`](https://github.com/eslint/eslint/commit/e59d77536bd8db57e8a75cd5245f6f320aa699f8) Update: Separate pattern/expression options for [array-element-newline](/docs/rules/array-element-newline) ([#11796](https://github.com/eslint/eslint/issues/11796)) (jacobparish)
* [`f8f115a`](https://github.com/eslint/eslint/commit/f8f115af6e10539e6cad485588187cb11917f8c9) Update: treat comment tokens in [template-curly-spacing](/docs/rules/template-curly-spacing) (fixes [#12744](https://github.com/eslint/eslint/issues/12744)) ([#12775](https://github.com/eslint/eslint/issues/12775)) (YeonJuan)
* [`9a93d9e`](https://github.com/eslint/eslint/commit/9a93d9ef389c49a133c4df4f9843927f5f806423) Update: fix [no-restricted-imports](/docs/rules/no-restricted-imports) export * false negative (fixes [#12737](https://github.com/eslint/eslint/issues/12737)) ([#12798](https://github.com/eslint/eslint/issues/12798)) (Milos Djermanovic)
* [`68becbd`](https://github.com/eslint/eslint/commit/68becbd84e8a0693409d36f2be10679c483e233a) Update: fix [no-restricted-imports](/docs/rules/no-restricted-imports) importNames reporting (fixes [#12282](https://github.com/eslint/eslint/issues/12282)) ([#12711](https://github.com/eslint/eslint/issues/12711)) (Andrey Alexandrov)
* [`ae959b6`](https://github.com/eslint/eslint/commit/ae959b691fb148ac8b474c924c8cb01ef61c436d) Update: report double extra parens in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#12127](https://github.com/eslint/eslint/issues/12127)) ([#12697](https://github.com/eslint/eslint/issues/12697)) (YeonJuan)
* [`b2c6209`](https://github.com/eslint/eslint/commit/b2c62096a8b318765d618cab222240f87d73063b) Update: fix [no-extra-parens](/docs/rules/no-extra-parens) CallExpression#callee false negatives ([#12743](https://github.com/eslint/eslint/issues/12743)) (Milos Djermanovic)
* [`14b42c3`](https://github.com/eslint/eslint/commit/14b42c386be3387c415267b789f277e1294d4567) Update: fix counting jsx comment len in [max-len](/docs/rules/max-len) (fixes [#12213](https://github.com/eslint/eslint/issues/12213)) ([#12661](https://github.com/eslint/eslint/issues/12661)) (YeonJuan)
* [`313f70a`](https://github.com/eslint/eslint/commit/313f70ac9a3cf5d1558d2427b00dd75666e18cf4) Update: add outerIIFEBody: "off" to [indent](/docs/rules/indent) rule (fixes [#11377](https://github.com/eslint/eslint/issues/11377)) ([#12706](https://github.com/eslint/eslint/issues/12706)) (Kai Cataldo)
* [`3fa39a6`](https://github.com/eslint/eslint/commit/3fa39a633b37544fec7cedfc1f2b0e62e9312a72) Update: Handle locally unsupported regex in computed property keys ([#12056](https://github.com/eslint/eslint/issues/12056)) (Milos Djermanovic)
* [`8f1020f`](https://github.com/eslint/eslint/commit/8f1020ff711b0c57d590bf666e2841f64186d083) Update: [no-void](/docs/rules/no-void) add an option to allow void as a statement ([#12613](https://github.com/eslint/eslint/issues/12613)) (Brad Zacher)
* [`bb6cf50`](https://github.com/eslint/eslint/commit/bb6cf5082623ffb67bb1495fee52c0610ee5f421) Update: Add offsetTernaryExpressions option for [indent](/docs/rules/indent) rule ([#12556](https://github.com/eslint/eslint/issues/12556)) (Adam Stankiewicz)




## Bug Fixes


* [`de4fa7c`](https://github.com/eslint/eslint/commit/de4fa7c65c7befefa64d1605550267071ee56a5d) Fix: wrong [indent](/docs/rules/indent) at tagged template in [indent](/docs/rules/indent) (fixes [#12122](https://github.com/eslint/eslint/issues/12122)) ([#12596](https://github.com/eslint/eslint/issues/12596)) (YeonJuan)
* [`16a1c1f`](https://github.com/eslint/eslint/commit/16a1c1f79bc0a4cc1c3a87e98d220041de88bb93) Fix: [prefer-object-spread](/docs/rules/prefer-object-spread) false positives with accessors (fixes [#12086](https://github.com/eslint/eslint/issues/12086)) ([#12784](https://github.com/eslint/eslint/issues/12784)) (Milos Djermanovic)
* [`0d8c0af`](https://github.com/eslint/eslint/commit/0d8c0affe1ae7ecf228cdf91b490921f7e9d1fdb) Fix: improve report location for [computed-property-spacing](/docs/rules/computed-property-spacing) ([#12795](https://github.com/eslint/eslint/issues/12795)) (Milos Djermanovic)
* [`756b95d`](https://github.com/eslint/eslint/commit/756b95d59fb97cd9b3f3adf98cebf529fe4842a2) Fix: [id-blacklist](/docs/rules/id-blacklist) should ignore ObjectPatterns (fixes [#12787](https://github.com/eslint/eslint/issues/12787)) ([#12792](https://github.com/eslint/eslint/issues/12792)) (JP Ramassini)
* [`01ff791`](https://github.com/eslint/eslint/commit/01ff7910af86fc45b76e883bc9ab00c9be3b50ac) Fix: Display pipe character correctly in test output ([#12771](https://github.com/eslint/eslint/issues/12771)) (Brad Zacher)
* [`00ddfff`](https://github.com/eslint/eslint/commit/00ddfffe6b4b4244e4680b0f92f2c6697fad136f) Fix: Windows path parsing for JUnit (fixes [#12507](https://github.com/eslint/eslint/issues/12507)) ([#12509](https://github.com/eslint/eslint/issues/12509)) (Michael Wall)
* [`1aff21b`](https://github.com/eslint/eslint/commit/1aff21bb54da44cef0b6e378a34a74265863b930) Fix: [no-mixed-spaces-and-tabs](/docs/rules/no-mixed-spaces-and-tabs) reports multiline strings ([#12566](https://github.com/eslint/eslint/issues/12566)) (Milos Djermanovic)




## Documentation


* [`02fcc05`](https://github.com/eslint/eslint/commit/02fcc055710e8d69d986f1e682cae2014ad881e2) Docs: Improve [sort-keys](/docs/rules/sort-keys) ([#12791](https://github.com/eslint/eslint/issues/12791)) (Steven Vachon)
* [`25eb703`](https://github.com/eslint/eslint/commit/25eb703c8758563988ffb497a53f89a3ed345399) Docs: fix dead link in [max-lines](/docs/rules/max-lines) rule docs ([#12766](https://github.com/eslint/eslint/issues/12766)) (Christian Bundy)
* [`098b67d`](https://github.com/eslint/eslint/commit/098b67d04a4b4dc8ef4faa6434c6ef5abbde3ed3) Docs: fix minor typo in [brace-style](/docs/rules/brace-style).md ([#12749](https://github.com/eslint/eslint/issues/12749)) (Marko Kaznovac)
* [`b23ad0d`](https://github.com/eslint/eslint/commit/b23ad0d789a909baf8d7c41a35bc53df932eaf30) Docs: change a broken link in working-with-rules.md ([#12732](https://github.com/eslint/eslint/issues/12732)) (Damien Cassou)




## Dependency Upgrades


* [`e632c31`](https://github.com/eslint/eslint/commit/e632c31d7e5363f1347b787702ecd4a85f5c11a2) Upgrade: several dependencies ([#12753](https://github.com/eslint/eslint/issues/12753)) (Toru Nagashima)




## Build Related


* [`4e16957`](https://github.com/eslint/eslint/commit/4e169576a526023ee297d5bc8b37eedba229f63d) Build: update browser build ([#12693](https://github.com/eslint/eslint/issues/12693)) (Toru Nagashima)
* [`827259e`](https://github.com/eslint/eslint/commit/827259ea009f98a0fdf3f7ebf1bfb6cd661ce28d) Build: package.json update for eslint-config-eslint release (ESLint Jenkins)




## Chores


* [`561b6d4`](https://github.com/eslint/eslint/commit/561b6d4726f3e77dd40ba0d340ca7f08429cd2eb) Chore: add prerequisites checklist to PR template ([#12790](https://github.com/eslint/eslint/issues/12790)) (Kai Cataldo)
* [`9dfc850`](https://github.com/eslint/eslint/commit/9dfc8501fb1956c90dc11e6377b4cb38a6bea65d) Chore: Refactor to use messageId in a number of rules ([#12715](https://github.com/eslint/eslint/issues/12715)) (Brad Zacher)
* [`b77b858`](https://github.com/eslint/eslint/commit/b77b8585e33fc4bb438a0e11ca8177c7eb91dbd8) Chore: fix separateRequires tests for [one-var](/docs/rules/one-var) rule ([#12709](https://github.com/eslint/eslint/issues/12709)) (Milos Djermanovic)
* [`e4df7df`](https://github.com/eslint/eslint/commit/e4df7dfb0199badb61d2c03ff4f7e4be735279d9) Chore: add JSDoc types for RuleTester test cases ([#12325](https://github.com/eslint/eslint/issues/12325)) (Chiawen Chen)
* [`4744397`](https://github.com/eslint/eslint/commit/474439720258b1a64b305c31588f803104fa4aaf) Chore: remove unused code in [max-lines-per-function](/docs/rules/max-lines-per-function) ([#12659](https://github.com/eslint/eslint/issues/12659)) (YeonJuan)
* [`39f5a45`](https://github.com/eslint/eslint/commit/39f5a453579b2ad732212edeb71f84ecb0991f97) Chore: add test cases for [for-direction](/docs/rules/for-direction) ([#12698](https://github.com/eslint/eslint/issues/12698)) (YeonJuan)
* [`b340304`](https://github.com/eslint/eslint/commit/b3403045e535921df6d34785a4ce053e14ba27fd) Chore: Add extra test, improve docs ([#12492](https://github.com/eslint/eslint/issues/12492)) (Kevin Partington)
