---
layout: post
title: ESLint v6.7.0 released
teaser: "We just pushed ESLint v6.7.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

### Suggestions API

This release contains a new Suggestions API for rule authors and integrations. You can read more about this exciting new feature [here](/docs/developer-guide/working-with-rules#providing-suggestions).

### `ignorePatterns` in config files

This release adds a new `ignorePatterns` property in config files (including shareable configs) in order to control the files ESLint ignores. See also [documentation](https://eslint.org/docs/user-guide/configuring#ignoring-files-and-directories).

### New Rules

* [grouped-accessor-pairs](/docs/rules/grouped-accessor-pairs)
* [no-constructor-return](/docs/rules/no-constructor-return)
* [no-dupe-else-if](/docs/rules/no-dupe-else-if)
* [no-setter-return](/docs/rules/no-setter-return)
* [prefer-exponentiation-operator](/docs/rules/prefer-exponentiation-operator)

### Deprecations

Please note that these deprecated features may be removed in a future major release of ESLint.

* [Personal configuration files](/docs/user-guide/configuring#personal-configuration-file-deprecated)
* [`sourceCode#isSpaceBetweenTokens()` has been deprecated in favor of `sourceCode#isSpaceBetween()`.](/docs/developer-guide/working-with-rules#deprecated)

## Features

* [`312a88f`](https://github.com/eslint/eslint/commit/312a88f2230082d898b7d8d82f8af63cb352e55a) New: Add [grouped-accessor-pairs](/docs/rules/grouped-accessor-pairs) rule (fixes [#12277](https://github.com/eslint/eslint/issues/12277)) ([#12331](https://github.com/eslint/eslint/issues/12331)) (Milos Djermanovic)
* [`6eaad96`](https://github.com/eslint/eslint/commit/6eaad964ff159d0a38de96c1104782ffe6858c78) New: Add suggestions API ([#12384](https://github.com/eslint/eslint/issues/12384)) (Will Douglas)
* [`1a2eb99`](https://github.com/eslint/eslint/commit/1a2eb99f11c65813bba11d6576a06cff2b823cc9) New: new rule [no-constructor-return](/docs/rules/no-constructor-return) (fixes [#12481](https://github.com/eslint/eslint/issues/12481)) ([#12529](https://github.com/eslint/eslint/issues/12529)) (Pig Fang)
* [`ca3b2a6`](https://github.com/eslint/eslint/commit/ca3b2a62c9e829dc4534bca3643d6bc729b46df0) New: ignorePatterns in config files (refs [eslint/rfcs#22](https://github.com/eslint/rfcs/issues/22)) ([#12274](https://github.com/eslint/eslint/issues/12274)) (Toru Nagashima)
* [`17a8849`](https://github.com/eslint/eslint/commit/17a8849491a983f6cb8e98da8c0c9d52ff5f2aa6) New: Add [no-dupe-else-if](/docs/rules/no-dupe-else-if) rule (fixes [#12469](https://github.com/eslint/eslint/issues/12469)) ([#12504](https://github.com/eslint/eslint/issues/12504)) (Milos Djermanovic)
* [`45aa6a3`](https://github.com/eslint/eslint/commit/45aa6a3ba3486f1b116c5daab6432d144e5ea574) New: Add [no-setter-return](/docs/rules/no-setter-return) rule (fixes [#12285](https://github.com/eslint/eslint/issues/12285)) ([#12346](https://github.com/eslint/eslint/issues/12346)) (Milos Djermanovic)
* [`41b1e43`](https://github.com/eslint/eslint/commit/41b1e4308c1cb01c8b00cc8adc36440e77854117) New: add option for [camelcase](/docs/rules/camelcase) (fixes [#12527](https://github.com/eslint/eslint/issues/12527)) ([#12528](https://github.com/eslint/eslint/issues/12528)) (Pig Fang)
* [`de65de6`](https://github.com/eslint/eslint/commit/de65de6e488112a602949e6a5d27dd4c754b003c) New: Add [prefer-exponentiation-operator](/docs/rules/prefer-exponentiation-operator) rule (fixes [#10482](https://github.com/eslint/eslint/issues/10482)) ([#12360](https://github.com/eslint/eslint/issues/12360)) (Milos Djermanovic)
* [`e17fb90`](https://github.com/eslint/eslint/commit/e17fb90f5817d16081e690eb06b7720afcb9fa2a) New: allowAfterThisConstructor for [no-underscore-dangle](/docs/rules/no-underscore-dangle) (fixes [#11488](https://github.com/eslint/eslint/issues/11488)) ([#11489](https://github.com/eslint/eslint/issues/11489)) (sripberger)




## Enhancements


* [`5c68f5f`](https://github.com/eslint/eslint/commit/5c68f5feeb4a6c0cb53ff76b2fd255b5bfa69c93) Update: Add 'lexicalBindings' to [no-implicit-globals](/docs/rules/no-implicit-globals) and change messages ([#11996](https://github.com/eslint/eslint/issues/11996)) (Milos Djermanovic)
* [`97c745d`](https://github.com/eslint/eslint/commit/97c745dc277febbea82552a4d9186e3df847f860) Update: Report assignment expression location in [no-cond-assign](/docs/rules/no-cond-assign) ([#12465](https://github.com/eslint/eslint/issues/12465)) (Milos Djermanovic)
* [`0f01f3d`](https://github.com/eslint/eslint/commit/0f01f3d0807c580631c2fdcff29192a64a870637) Update: Check member expressions with `this` in [operator-assignment](/docs/rules/operator-assignment) ([#12495](https://github.com/eslint/eslint/issues/12495)) (Milos Djermanovic)
* [`4f8a1ee`](https://github.com/eslint/eslint/commit/4f8a1ee1c26ccb5882e5e83ea7eab2f406c7476b) Update: Add enforceForClassMembers option to [no-useless-computed-key](/docs/rules/no-useless-computed-key) ([#12110](https://github.com/eslint/eslint/issues/12110)) (ark120202)
* [`41a78fd`](https://github.com/eslint/eslint/commit/41a78fd7ce245cad8ff6a96c42f5840688849427) Update: improve location for [semi](/docs/rules/semi) and [comma-dangle](/docs/rules/comma-dangle) ([#12380](https://github.com/eslint/eslint/issues/12380)) (Chiawen Chen)
* [`b8030fc`](https://github.com/eslint/eslint/commit/b8030fc23e88f57a04d955b3befd1ab0fc2c5d10) Update: deprecate personal config (fixes [#11914](https://github.com/eslint/eslint/issues/11914), refs [eslint/rfcs#32](https://github.com/eslint/rfcs/issues/32)) ([#12426](https://github.com/eslint/eslint/issues/12426)) (Toru Nagashima)
* [`6503cb8`](https://github.com/eslint/eslint/commit/6503cb8d99e549fece53b80b110e890a7978b9fd) Update: Fix uglified object align in [key-spacing](/docs/rules/key-spacing) (fixes [#11414](https://github.com/eslint/eslint/issues/11414)) ([#12472](https://github.com/eslint/eslint/issues/12472)) (YeonJuan)
* [`0f7edef`](https://github.com/eslint/eslint/commit/0f7edefdc1576d5e3e7ef89083002b0a4a31f039) Update: add react plugin config for eslint init ([#12446](https://github.com/eslint/eslint/issues/12446)) (Ibrahim Rouis)
* [`448ff1e`](https://github.com/eslint/eslint/commit/448ff1e53734c503fb9e7e6802c1c7e441d4c019) Update: Report '\08' and '\09' in [no-octal-escape](/docs/rules/no-octal-escape) (fixes [#12080](https://github.com/eslint/eslint/issues/12080)) ([#12526](https://github.com/eslint/eslint/issues/12526)) (Milos Djermanovic)
* [`90305e0`](https://github.com/eslint/eslint/commit/90305e017c2c5fba0b4b62f41b180910b4baeedb) Update: Depcrecate isSpaceBetweenTokens() ([#12519](https://github.com/eslint/eslint/issues/12519)) (Kai Cataldo)
* [`990065e`](https://github.com/eslint/eslint/commit/990065e5f58b6cc6922ab6cee5b97bfc56a6237a) Update: [curly](/docs/rules/curly) multi-or-nest flagging semis on next line (fixes [#12370](https://github.com/eslint/eslint/issues/12370)) ([#12378](https://github.com/eslint/eslint/issues/12378)) (cherryblossom000)
* [`7e41355`](https://github.com/eslint/eslint/commit/7e41355b19a8ef347620dd7c0dde491c3460937b) Update: improve report location for [space-infix-ops](/docs/rules/space-infix-ops) ([#12324](https://github.com/eslint/eslint/issues/12324)) (Chiawen Chen)
* [`94ff921`](https://github.com/eslint/eslint/commit/94ff921689115f856578159564ee1968b4b914be) Update: Add capIsConstructor option to [no-invalid-this](/docs/rules/no-invalid-this) (fixes [#12271](https://github.com/eslint/eslint/issues/12271)) ([#12308](https://github.com/eslint/eslint/issues/12308)) (Milos Djermanovic)
* [`c78f4a7`](https://github.com/eslint/eslint/commit/c78f4a73de68f81cd41132b46d4840b91599d599) Update: Allow JSX exception in [no-inline-comments](/docs/rules/no-inline-comments) (fixes [#11270](https://github.com/eslint/eslint/issues/11270)) ([#12388](https://github.com/eslint/eslint/issues/12388)) (Milos Djermanovic)




## Bug Fixes


* [`b336fbe`](https://github.com/eslint/eslint/commit/b336fbedecd85731611fdc2dfd8edb635a8b1c39) Fix: [indent](/docs/rules/indent) rule with JSX spread props ([#12581](https://github.com/eslint/eslint/issues/12581)) (Nathan Woltman)
* [`62c7038`](https://github.com/eslint/eslint/commit/62c7038a493d89e4a7b14ac673a063d09d04057b) Fix: invalid token checking in [computed-property-spacing](/docs/rules/computed-property-spacing) (fixes [#12198](https://github.com/eslint/eslint/issues/12198)) ([#12533](https://github.com/eslint/eslint/issues/12533)) (YeonJuan)
* [`62623f9`](https://github.com/eslint/eslint/commit/62623f9f611a3adb79696304760a2fd14be8afbc) Fix: preserve whitespace in [multiline-comment-style](/docs/rules/multiline-comment-style) (fixes [#12312](https://github.com/eslint/eslint/issues/12312)) ([#12316](https://github.com/eslint/eslint/issues/12316)) (Kai Cataldo)
* [`fed20bb`](https://github.com/eslint/eslint/commit/fed20bb039cf9f53adfcf93e467f418c5e958f45) Fix: [require-await](/docs/rules/require-await) crash on global await ([#12571](https://github.com/eslint/eslint/issues/12571)) (Brad Zacher)
* [`40c8c32`](https://github.com/eslint/eslint/commit/40c8c3264c7c383d98c9faf9c4cb4f8b75aee40f) Fix: improve report location for [object-curly-spacing](/docs/rules/object-curly-spacing) ([#12563](https://github.com/eslint/eslint/issues/12563)) (Milos Djermanovic)
* [`1110045`](https://github.com/eslint/eslint/commit/1110045e0d28a461e75d2f57d5f01533d59ef239) Fix: ignore marker-only comments in [spaced-comment](/docs/rules/spaced-comment) (fixes [#12036](https://github.com/eslint/eslint/issues/12036)) ([#12558](https://github.com/eslint/eslint/issues/12558)) (Milos Djermanovic)
* [`0afb518`](https://github.com/eslint/eslint/commit/0afb518d1f139376245613dddd8eaef32b52d619) Fix: invalid autofix in [function-call-argument-newline](/docs/rules/function-call-argument-newline) (fixes [#12454](https://github.com/eslint/eslint/issues/12454)) ([#12539](https://github.com/eslint/eslint/issues/12539)) (YeonJuan)
* [`9e29e18`](https://github.com/eslint/eslint/commit/9e29e189752f06362fd1956659e07834efb746a5) Fix: sourceCode#isSpaceBetweenTokens() checks non-adjacent tokens ([#12491](https://github.com/eslint/eslint/issues/12491)) (Kai Cataldo)
* [`bb556d5`](https://github.com/eslint/eslint/commit/bb556d5fd735ad2dcea322082edcc07a58105ce9) Fix: [curly](/docs/rules/curly) `multi` reports single lexical declarations (fixes [#11908](https://github.com/eslint/eslint/issues/11908)) ([#12513](https://github.com/eslint/eslint/issues/12513)) (Milos Djermanovic)
* [`ac60621`](https://github.com/eslint/eslint/commit/ac606217d4beebc35b865d14a7f9723fd21faa48) Fix: unexpected autofix in [prefer-const](/docs/rules/prefer-const) (fixes [#12514](https://github.com/eslint/eslint/issues/12514)) ([#12521](https://github.com/eslint/eslint/issues/12521)) (YeonJuan)
* [`084a8a6`](https://github.com/eslint/eslint/commit/084a8a63a749232681fefe9bdac6802efdcdc8a8) Fix: [no-cond-assign](/docs/rules/no-cond-assign) with `always` option reports switch case clauses ([#12470](https://github.com/eslint/eslint/issues/12470)) (Milos Djermanovic)




## Documentation


* [`60204a3`](https://github.com/eslint/eslint/commit/60204a3620e33a078c1c35fa2e5d839a16c627ff) Docs: Added another Textmate 2 bundle. ([#12580](https://github.com/eslint/eslint/issues/12580)) (Ryan Fitzer)
* [`0a480f8`](https://github.com/eslint/eslint/commit/0a480f8307a0e438032f484254941e6426748143) Docs: Change "Code Conventions" link in pull-requests.md ([#12401](https://github.com/eslint/eslint/issues/12401)) (Denis Sikuler)
* [`40791af`](https://github.com/eslint/eslint/commit/40791af69efde1701690637603ad37d41e15a727) Docs: clarify ignoreDestructuring option in the [camelcase](/docs/rules/camelcase) rule ([#12553](https://github.com/eslint/eslint/issues/12553)) (Milos Djermanovic)
* [`0286b57`](https://github.com/eslint/eslint/commit/0286b5730501b391c74e069db46849f0de0885d2) Docs: Clean up Getting Started Guide ([#12544](https://github.com/eslint/eslint/issues/12544)) (Nicholas C. Zakas)
* [`5868550`](https://github.com/eslint/eslint/commit/586855060afb3201f4752be8820dc85703b523a6) Docs: add notice about `function` keyword in [keyword-spacing](/docs/rules/keyword-spacing) ([#12524](https://github.com/eslint/eslint/issues/12524)) (Pig Fang)
* [`4e142ea`](https://github.com/eslint/eslint/commit/4e142ea411dfb692b6e2a69cd5f1204ade4dd58a) Docs: Update README team and sponsors (ESLint Jenkins)




## Dependency Upgrades


* [`f49f1e0`](https://github.com/eslint/eslint/commit/f49f1e0a69afa49f6548af7b2c0e6347e1ea022d) Upgrade: upgrade optionator to avoid license issue (fixes [#11536](https://github.com/eslint/eslint/issues/11536)) ([#12537](https://github.com/eslint/eslint/issues/12537)) (Pig Fang)
* [`98e1d50`](https://github.com/eslint/eslint/commit/98e1d50273f31c2a7b59772298280ed7305274c8) Upgrade: globals to v12.1.0 ([#12296](https://github.com/eslint/eslint/issues/12296)) (Tony Brix)




## Build Related


* [`287ca56`](https://github.com/eslint/eslint/commit/287ca562811d037bde09a47af7f5b9c7b741e022) Build: update CI for Node.js 13 ([#12496](https://github.com/eslint/eslint/issues/12496)) (Toru Nagashima)




## Chores


* [`07d398d`](https://github.com/eslint/eslint/commit/07d398d91d5b6d0247e58b1f8ea64bb5acd570a8) Chore: Add GitHub organization to Sponsor button ([#12562](https://github.com/eslint/eslint/issues/12562)) (Brandon Mills)
* [`a477707`](https://github.com/eslint/eslint/commit/a47770706ac59633dcd73e886d1a7282b324ee06) Chore: Format style guide links so they can be clicked ([#12189](https://github.com/eslint/eslint/issues/12189)) (Ivan V)
* [`575a98d`](https://github.com/eslint/eslint/commit/575a98d724b2688f1e9c83744c5dc9ffe9a7bfb4) Chore: Add funding field to package.json ([#12543](https://github.com/eslint/eslint/issues/12543)) (Nicholas C. Zakas)
