---
layout: post
title: 'Funding ESLint''s Future: November Update'
teaser: "We are happy to announce that we are currently sponsored at just under $10,000 per month. We share how we've used the money and what our sponsors are telling us. Thanks to the ESLint Collective, we are looking forward to a brighter future for ESLint."
tags:
  - Open Source
  - Funding
  - Open Collective
  - Sponsors
  - Backers
authors:
  - kaicataldo
categories:
  - Financials
---

Back in February, we [announced](https://eslint.org/blog/2019/02/funding-eslint-future) the creation of the [ESLint Collective](https://opencollective.com/eslint) to raise funds for the ongoing maintenance and development of ESLint. Our goal was to raise $20,000 each month to support the project, and since then, we've been grateful for contributions from nearly 150 companies, projects, and individuals towards that goal.

We are happy to share that we are currently sponsored at just under $10,000 per month, almost 50% of our goal! At this level, we've been able to start paying team members for their time (more about this below), ensuring ESLint gets the ongoing support it needs.

## How we've used the money

As mentioned above, the most exciting thing we've been able to do with the money you've donated is pay a team member to work on ESLint part-time. [Kai Cataldo](https://github.com/kaicataldo) has been involved with ESLint for several years and for the past two months has been working part-time on ESLint. Having Kai consistently working on the project has meant faster response times to issues and pull requests, and better coordination across the team. Here's what Kai said about this experience:

> As a long-time maintainer of ESLint, I'm both humbled and grateful to be able to be paid to work on the project. Instead of eking out a few minutes between other activities, it has allowed me to carve out blocks of time to dedicate to consistent, focused work. In practical terms, it has allowed me to better prioritize the time I spend on the project, and I've been able to be more active, from finding more time to write code, to reviewing pull requests, to  managing bug reports and feature requests from the community. So much of the software we use every day relies on projects like ESLint to deliver value and improve our lives, and the resources we spend on these projects have an enormous ripple effect. Money certainly isn't everything, but there is a big difference between volunteer work and a job, and investment from the community has in turn allowed me to invest more focused time and energy into ESLint.
>
> -- Kai Cataldo, ESLint team member

Our hope is that as we continue raising money, we will be able to bring on at least one more part-time maintainer to keep the ESLint project running smoothly.

## What our sponsors are telling us

We also reached out to our sponsors to ask them how they use ESLint internally and why they decided to sponsor the ESLint project. [Shopify](https://shopify.com) is one of our more recent sponsors, and here's what they had to say:

> We use ESLint to push developers towards patterns that are better for the long-term maintainability of the codebase. We've written many custom rules to avoid vagueness in tests, ensure that all content is translated, prevent code from reaching for implementation details of its dependencies, and much more. We also use great community plugins that offer many additional rules around React, TypeScript, and GraphQL. All of these rules run on every commit, in every app, offering a consistent set of stylistic guidelines no matter what project a developer is working on.
>
> -- Chris Sauve, Web Developer at Shopify

One of our initial sponsors, [Facebook](https://facebook.com), also makes use of ESLint internally:

> ESLint is a valued part of the JS ecosystem and developer community. ESLint is used in production systems. Thanks to you and the community for all the dedication and hard work.
>
> The FB OSS program supports communities in many ways. Direct community sponsorships is one area where it is experimenting.
>
> -- Erik Nakagawa, Head of Open Source at Calibra (Facebook)

Another of our initial sponsors, [Salesforce](https://salesforce.com), makes extensive use of ESLint as part of their larger development ecosystem:

> We have been using ESLint for many years, specially on our core platform, where it has become one of the most fundamental pieces of our pipeline.
>
> To name some of our most important use cases of ESLint:
>
> - We use it to validate and enforce specific rules and semantics every time a customer pushes components to our platform. That helps us scale and guarantee correctness on all the code that we serve.
> - We use it to give all our developers a recommended set of rules, patterns and stylistic principles that allow us to keep a healthy and maintainable code base.
> - We use it to guard specific API usages that will prevent the code from running in different conditions or host environments.
> - We use it to help our customers write performant code, specially in IE11 where we have rules to prevent specific grammar that will transpile down to very inefficient code (ex. async-await, default function parameters).
>
> Given that ESLint is such a core part of our platform and ecosystem, we are really proud to be part of the community by sponsoring and contributing in any way we can to the future of an amazing project.
>
> -- Diego Ferreiro Val, Principal Architect at Salesforce

## Help us reach our goal

If your company also uses ESLint to find and fix problems in your JavaScript code, please ask them to join these fantastic companies in [sponsoring ESLint](https://opencollective.com/eslint). (All sponsors above $200 per month get their logos on both the ESLint README and on the homepage of eslint.org.)
