---
layout: post
title: ESLint v6.6.0 released
teaser: "We just pushed ESLint v6.6.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights


* Rules can now access `context.getCwd()` to get the current working directory
* The [use-isnan](/docs/rules/use-isnan) rule has a new `enforceForIndexOf` option
* The [no-param-reassign](/docs/rules/no-param-reassign) rule has a new `ignorePropertyModificationsForRegex` option
* The [no-unsafe-negation](/docs/rules/no-unsafe-negation) rule has a new `enforceForOrderingRelations` option
* The [no-extra-parens](/docs/rules/no-extra-parens) has a new `enforceForNewInMemberExpressions` option

In addition, we have improved the error report locations for a number of rules with this release.


## Features


* [`874fe16`](https://github.com/eslint/eslint/commit/874fe1642a10a0fb937ccccdd4d22343b84f80dc) New: pass cwd from cli engine ([#12389](https://github.com/eslint/eslint/issues/12389)) (Eric Wang)


## Enhancements


* [`39dfe08`](https://github.com/eslint/eslint/commit/39dfe0880fa934e287e8ea1f7b56d5cba8d43765) Update: false positives in [function-call-argument-newline](/docs/rules/function-call-argument-newline) (fixes [#12123](https://github.com/eslint/eslint/issues/12123)) ([#12280](https://github.com/eslint/eslint/issues/12280)) (Scott O'Hara)
* [`4d84210`](https://github.com/eslint/eslint/commit/4d842105c9c82026be668d7425213138903d4d41) Update: improve report location for [no-trailing-spaces](/docs/rules/no-trailing-spaces) (fixes [#12315](https://github.com/eslint/eslint/issues/12315)) ([#12477](https://github.com/eslint/eslint/issues/12477)) (Milos Djermanovic)
* [`c6a7745`](https://github.com/eslint/eslint/commit/c6a7745a1371a85932bfae5fec039d1b6fcfc128) Update: [no-trailing-spaces](/docs/rules/no-trailing-spaces) false negatives after comments (fixes [#12479](https://github.com/eslint/eslint/issues/12479)) ([#12480](https://github.com/eslint/eslint/issues/12480)) (Milos Djermanovic)
* [`c6a9a3b`](https://github.com/eslint/eslint/commit/c6a9a3bc58b69dbf9be9cd09b0283c081ca211e7) Update: Add enforceForIndexOf option to [use-isnan](/docs/rules/use-isnan) (fixes [#12207](https://github.com/eslint/eslint/issues/12207)) ([#12379](https://github.com/eslint/eslint/issues/12379)) (Milos Djermanovic)
* [`364877b`](https://github.com/eslint/eslint/commit/364877b2504e8f7ece04770b93d517e2f27458d0) Update: measure plugin loading time and output in debug message ([#12395](https://github.com/eslint/eslint/issues/12395)) (Victor Homyakov)
* [`aac3be4`](https://github.com/eslint/eslint/commit/aac3be435cccc241781150fcac728df04d086fa8) Update: Add ignored prop regex [no-param-reassign](/docs/rules/no-param-reassign) ([#11275](https://github.com/eslint/eslint/issues/11275)) (Luke Bennett)
* [`7dffe48`](https://github.com/eslint/eslint/commit/7dffe482d646d4e5f94fa87a22f3b5b2e0a4b189) Update: Enable function string option in [comma-dangle](/docs/rules/comma-dangle) (fixes [#12058](https://github.com/eslint/eslint/issues/12058)) ([#12462](https://github.com/eslint/eslint/issues/12462)) (YeonJuan)
* [`7c8bbe0`](https://github.com/eslint/eslint/commit/7c8bbe0391944e1f92e083a04715bf4b3fe6be5d) Update: enforceForOrderingRelations [no-unsafe-negation](/docs/rules/no-unsafe-negation) (fixes [#12163](https://github.com/eslint/eslint/issues/12163)) ([#12414](https://github.com/eslint/eslint/issues/12414)) (Sam Rae)
* [`349ed67`](https://github.com/eslint/eslint/commit/349ed6700e1155384597e1e6035550a96cb8a42d) Update: improve report location for [no-mixed-operators](/docs/rules/no-mixed-operators) ([#12328](https://github.com/eslint/eslint/issues/12328)) (Chiawen Chen)
* [`6e7c18d`](https://github.com/eslint/eslint/commit/6e7c18ddb30b32ee5b2e842cc8258aa7aebb7445) Update: enforceForNewInMemberExpressions [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#12428](https://github.com/eslint/eslint/issues/12428)) ([#12436](https://github.com/eslint/eslint/issues/12436)) (Milos Djermanovic)
* [`2d6e345`](https://github.com/eslint/eslint/commit/2d6e345e3c2626b0f2252f22cfaffdf53ea0871a) Update: make isSpaceBetweenTokens() ignore newline in comments ([#12407](https://github.com/eslint/eslint/issues/12407)) (YeonJuan)
* [`84f71de`](https://github.com/eslint/eslint/commit/84f71de0e686e0fe37b83d6728ce1825caaa44fb) Update: remove default overrides in [keyword-spacing](/docs/rules/keyword-spacing) (fixes [#12369](https://github.com/eslint/eslint/issues/12369)) ([#12411](https://github.com/eslint/eslint/issues/12411)) (YeonJuan)
* [`18a0b0e`](https://github.com/eslint/eslint/commit/18a0b0e3df927428a22b5b5295f9faee4bd57246) Update: improve report location for no-[space-in-parens](/docs/rules/space-in-parens) ([#12364](https://github.com/eslint/eslint/issues/12364)) (Chiawen Chen)
* [`d61c8a5`](https://github.com/eslint/eslint/commit/d61c8a5a75447a36276f2d4f84afb3e1129618da) Update: improve report location for [no-multi-spaces](/docs/rules/no-multi-spaces) ([#12329](https://github.com/eslint/eslint/issues/12329)) (Chiawen Chen)
* [`b962775`](https://github.com/eslint/eslint/commit/b962775b8cb7c90985a5ab63e56744bb2ba79644) Update: [no-self-assign](/docs/rules/no-self-assign) should detect member expression with this ([#12279](https://github.com/eslint/eslint/issues/12279)) (Tibor Blenessy)


## Bug Fixes


* [`0bffe95`](https://github.com/eslint/eslint/commit/0bffe953d2752dd2d3045f2f8771c96b6cee8fc4) Fix: [no-misleading-character-class](/docs/rules/no-misleading-character-class) crash on invalid regex (fixes [#12169](https://github.com/eslint/eslint/issues/12169)) ([#12347](https://github.com/eslint/eslint/issues/12347)) (Milos Djermanovic)
* [`1744fab`](https://github.com/eslint/eslint/commit/1744faba3c93c869f7dbbf0a704d32e2692d6856) Fix: [operator-assignment](/docs/rules/operator-assignment) removes and duplicates comments ([#12485](https://github.com/eslint/eslint/issues/12485)) (Milos Djermanovic)
* [`52ca11a`](https://github.com/eslint/eslint/commit/52ca11a66ab6c2fb5a71d8b9869482f14f98cb9d) Fix: [operator-assignment](/docs/rules/operator-assignment) invalid autofix with adjacent tokens ([#12483](https://github.com/eslint/eslint/issues/12483)) (Milos Djermanovic)
* [`0f6d0dc`](https://github.com/eslint/eslint/commit/0f6d0dcdf5adc30079a7379bbf605a4ef3887a85) Fix: CLIEngine#addPlugin reset lastConfigArrays (fixes [#12425](https://github.com/eslint/eslint/issues/12425)) ([#12468](https://github.com/eslint/eslint/issues/12468)) (Toru Nagashima)
* [`49faefb`](https://github.com/eslint/eslint/commit/49faefbee3fc7daaf2482d9d7d23513d6ffda9e8) Fix: [no-obj-calls](/docs/rules/no-obj-calls) false positive (fixes [#12437](https://github.com/eslint/eslint/issues/12437)) ([#12467](https://github.com/eslint/eslint/issues/12467)) (Toru Nagashima)
* [`b3dbd96`](https://github.com/eslint/eslint/commit/b3dbd9657bbeac6571111a4429b03fc085ba6655) Fix: problematic installation issue (fixes [#11018](https://github.com/eslint/eslint/issues/11018)) ([#12309](https://github.com/eslint/eslint/issues/12309)) (Toru Nagashima)
* [`89e8aaf`](https://github.com/eslint/eslint/commit/89e8aafcc622a4763bed6b9d62f148ef95798f38) Fix: improve report location for [no-tabs](/docs/rules/no-tabs) ([#12471](https://github.com/eslint/eslint/issues/12471)) (Milos Djermanovic)
* [`a102eaa`](https://github.com/eslint/eslint/commit/a102eaa9ac19e1c6d92f79a4033e9048cfb64c0d) Fix: [prefer-numeric-literals](/docs/rules/prefer-numeric-literals) invalid autofix with adjacent tokens ([#12387](https://github.com/eslint/eslint/issues/12387)) (Milos Djermanovic)
* [`51fbbd7`](https://github.com/eslint/eslint/commit/51fbbd78f98f223d17071650f5117d07f60dadc2) Fix: [array-bracket-newline](/docs/rules/array-bracket-newline) consistent error with comments (fixes [#12416](https://github.com/eslint/eslint/issues/12416)) ([#12441](https://github.com/eslint/eslint/issues/12441)) (Milos Djermanovic)
* [`e657d4c`](https://github.com/eslint/eslint/commit/e657d4ccb9f3dd5cacceaaa40ffe24ac29a1349a) Fix: report full dot location in [dot-location](/docs/rules/dot-location) ([#12452](https://github.com/eslint/eslint/issues/12452)) (Milos Djermanovic)


## Documentation


* [`8233873`](https://github.com/eslint/eslint/commit/8233873b8e5facd80ab7b172bff1e896a9c5fd39) Docs: Add note about Node.js requiring SSL support (fixes [#11413](https://github.com/eslint/eslint/issues/11413)) ([#12475](https://github.com/eslint/eslint/issues/12475)) (Nicholas C. Zakas)
* [`e15e1f9`](https://github.com/eslint/eslint/commit/e15e1f933f287d274a726e7f0f0a1dd80f0964af) Docs: fix doc for [no-unneeded-ternary](/docs/rules/no-unneeded-ternary) rule (fixes [#12098](https://github.com/eslint/eslint/issues/12098)) ([#12410](https://github.com/eslint/eslint/issues/12410)) (Sam Rae)
* [`02977f2`](https://github.com/eslint/eslint/commit/02977f25a922dd0b8617c16116bb4364d0f30e94) Docs: Clarify `eslint:recommended` semver policy ([#12429](https://github.com/eslint/eslint/issues/12429)) (Kevin Partington)
* [`97045ae`](https://github.com/eslint/eslint/commit/97045ae0805e6503887eef0b131dcb9e70b6d185) Docs: Fixes object type for `rules` in "Use a Plugin" ([#12409](https://github.com/eslint/eslint/issues/12409)) (Daisy Develops)
* [`24ca088`](https://github.com/eslint/eslint/commit/24ca088fdc901feef8f10b050414fbde64b55c7d) Docs: Fix typo in v6 migration guide ([#12412](https://github.com/eslint/eslint/issues/12412)) (Benjamim Sonntag)
* [`84467c0`](https://github.com/eslint/eslint/commit/84467c07461cc47ee43807ba9014e13700473c5c) Docs: fix wrong [max-depth](/docs/rules/max-depth) example (fixes [#11991](https://github.com/eslint/eslint/issues/11991)) ([#12358](https://github.com/eslint/eslint/issues/12358)) (Gabriel R Sezefredo)
* [`3642342`](https://github.com/eslint/eslint/commit/364234262efabd91fa8bd53161d9d3e1e37e7944) Docs: Fix minor formatting/grammar errors ([#12371](https://github.com/eslint/eslint/issues/12371)) (cherryblossom000)
* [`c47fa0d`](https://github.com/eslint/eslint/commit/c47fa0dfc76211b3b0e5649c63acdd9606ce0eca) Docs: Fix missing word in sentence ([#12361](https://github.com/eslint/eslint/issues/12361)) (Dan Boulet)


## Dependency Upgrades


* [`561093f`](https://github.com/eslint/eslint/commit/561093fc4267a4ae317d63bc9f103020fad88802) Upgrade: bump inquirer to ^7.0.0 ([#12440](https://github.com/eslint/eslint/issues/12440)) (Joe Graham)


## Chores


* [`923a8cb`](https://github.com/eslint/eslint/commit/923a8cb752b8dee1e622c5fd36f3f53288e30602) Chore: Fix lint failure in JSDoc comment ([#12489](https://github.com/eslint/eslint/issues/12489)) (Brandon Mills)
* [`e5382d6`](https://github.com/eslint/eslint/commit/e5382d6e4eb1344f537b6f107535269e9939fcb8) Chore: Remove unused parameter in [dot-location](/docs/rules/dot-location) ([#12464](https://github.com/eslint/eslint/issues/12464)) (Milos Djermanovic)
* [`61749c9`](https://github.com/eslint/eslint/commit/61749c94bd8a2ebcdfb89e0cd48c4a029a945079) Chore: Provide debug log for parser errors ([#12474](https://github.com/eslint/eslint/issues/12474)) (Brad Zacher)
* [`fb633b2`](https://github.com/eslint/eslint/commit/fb633b2bbd0a390b247047524fdd1f612dbab803) Chore: Add a script for testing with more control ([#12444](https://github.com/eslint/eslint/issues/12444)) (Eric Wang)
* [`b094008`](https://github.com/eslint/eslint/commit/b094008fb196dc1de5b4c27b7dbf0bcbb4b7b352) Chore: update version parameter name ([#12402](https://github.com/eslint/eslint/issues/12402)) (Toru Nagashima)
* [`e5637ba`](https://github.com/eslint/eslint/commit/e5637badd42f087d115f81575b832097fe6fe554) Chore: enable jsdoc/require-description ([#12365](https://github.com/eslint/eslint/issues/12365)) (Kai Cataldo)
* [`7ffb22f`](https://github.com/eslint/eslint/commit/7ffb22f61cf1622511a7fe42b5ead7c3b216df5e) Chore: Clean up inline directive parsing ([#12375](https://github.com/eslint/eslint/issues/12375)) (Jordan Eldredge)
* [`8108f49`](https://github.com/eslint/eslint/commit/8108f49f9fa0c2de80b3b66c847551beff585951) Chore: enable additional eslint-plugin-jsdoc rules ([#12336](https://github.com/eslint/eslint/issues/12336)) (Kai Cataldo)
* [`b718d2e`](https://github.com/eslint/eslint/commit/b718d2e6c9fe3fc56aa7cfc68b1a40b5cd8a7c01) Chore: update issue template with --eslint-fix flag ([#12352](https://github.com/eslint/eslint/issues/12352)) (James George)
