---
layout: post
title: ESLint v6.5.0 released
teaser: "We just pushed ESLint v6.5.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

* We have added a new `--env-info` CLI option, which provides a lot of information that is useful for GitHub issues.
* The [`use-isnan`](/docs/rules/use-isnan) rule supports a new option, `enforceForSwitchCase`.
* The [`indent`](/docs/rules/indent) rule now supports JSXFragment nodes.

In addition, many rules that removed comments during autofix have been modified to avoid removing comments. Please open an issue if you find any more cases that need to be fixed.

## Features


* [`a7894eb`](https://github.com/eslint/eslint/commit/a7894ebb43523152d36720efa770bb1fe8b58c07) New: add --env-info flag to CLI ([#12270](https://github.com/eslint/eslint/issues/12270)) (Kai Cataldo)


## Enhancements


* [`73596cb`](https://github.com/eslint/eslint/commit/73596cbdf0a12e2878b2994783f9b969b0c5fbeb) Update: Add enforceForSwitchCase option to [use-isnan](/docs/rules/use-isnan) ([#12106](https://github.com/eslint/eslint/issues/12106)) (Milos Djermanovic)
* [`334ca7c`](https://github.com/eslint/eslint/commit/334ca7c8b9c18ac097849c1cefaa43097a4e51dc) Update: [no-useless-rename](/docs/rules/no-useless-rename) also reports default values (fixes [#12301](https://github.com/eslint/eslint/issues/12301)) ([#12322](https://github.com/eslint/eslint/issues/12322)) (Kai Cataldo)
* [`41bfe91`](https://github.com/eslint/eslint/commit/41bfe919c06932b7e58cd9ead20157e06656160a) Update: Fix handling of chained new expressions in [new-parens](/docs/rules/new-parens) ([#12303](https://github.com/eslint/eslint/issues/12303)) (Milos Djermanovic)
* [`11ae6fc`](https://github.com/eslint/eslint/commit/11ae6fcb5d5503e5dea41c02780369efe51f0bb9) Update: Fix call, new and member expressions in [no-extra-parens](/docs/rules/no-extra-parens) ([#12302](https://github.com/eslint/eslint/issues/12302)) (Milos Djermanovic)
* [`d4f9a16`](https://github.com/eslint/eslint/commit/d4f9a16af7e00021e2ed63823d9c2f149bc985d6) Update: add support for JSXFragments in [indent](/docs/rules/indent) rule (fixes [#12208](https://github.com/eslint/eslint/issues/12208)) ([#12210](https://github.com/eslint/eslint/issues/12210)) (Kai Cataldo)


## Bug Fixes


* [`d592a24`](https://github.com/eslint/eslint/commit/d592a248d67920f7200925c003f10853d29f1f8d) Fix: exclude `\u000d` so new line won't convert to text (fixes [#12027](https://github.com/eslint/eslint/issues/12027)) ([#12031](https://github.com/eslint/eslint/issues/12031)) (zamboney)
* [`e85d27a`](https://github.com/eslint/eslint/commit/e85d27af427d6185ac553a0d801b5103153426d4) Fix: [no-regex-spaces](/docs/rules/no-regex-spaces) false positives and invalid autofix (fixes [#12226](https://github.com/eslint/eslint/issues/12226)) ([#12231](https://github.com/eslint/eslint/issues/12231)) (Milos Djermanovic)
* [`b349bf7`](https://github.com/eslint/eslint/commit/b349bf79ad56dded826bc99cb52c3551af34fa63) Fix: [prefer-named-capture-group](/docs/rules/prefer-named-capture-group) incorrect locations (fixes [#12233](https://github.com/eslint/eslint/issues/12233)) ([#12247](https://github.com/eslint/eslint/issues/12247)) (Milos Djermanovic)
* [`7dc1ea9`](https://github.com/eslint/eslint/commit/7dc1ea9a1b9a21daaffcf712ba9c0e91af81b906) Fix: [no-useless-return](/docs/rules/no-useless-return) autofix removes comments ([#12292](https://github.com/eslint/eslint/issues/12292)) (Milos Djermanovic)
* [`0e68677`](https://github.com/eslint/eslint/commit/0e68677ec0aaf060a071ecf71e4af954dddb6af0) Fix: [no-extra-bind](/docs/rules/no-extra-bind) autofix removes comments ([#12293](https://github.com/eslint/eslint/issues/12293)) (Milos Djermanovic)
* [`6ad7e86`](https://github.com/eslint/eslint/commit/6ad7e864303e56a39c89569d50c6caf80752ee21) Fix: [no-extra-label](/docs/rules/no-extra-label) autofix removes comments ([#12298](https://github.com/eslint/eslint/issues/12298)) (Milos Djermanovic)
* [`acec201`](https://github.com/eslint/eslint/commit/acec201f06df780791179ad92cfc484f9b6d23d4) Fix: [no-undef-init](/docs/rules/no-undef-init) autofix removes comments ([#12299](https://github.com/eslint/eslint/issues/12299)) (Milos Djermanovic)
* [`d89390b`](https://github.com/eslint/eslint/commit/d89390b75e3e9993f347387a49b0ac5550f45c7f) Fix: use async reading of stdin in bin/eslint.js (fixes [#12212](https://github.com/eslint/eslint/issues/12212)) ([#12230](https://github.com/eslint/eslint/issues/12230)) (Barrie Treloar)
* [`8316e7b`](https://github.com/eslint/eslint/commit/8316e7be5a9429513d7ecf2ee2afc40ab4415b8f) Fix: [no-useless-rename](/docs/rules/no-useless-rename) autofix removes comments ([#12300](https://github.com/eslint/eslint/issues/12300)) (Milos Djermanovic)
* [`f5537b2`](https://github.com/eslint/eslint/commit/f5537b2ed0b0b5e51a34c22cdd4ebfd024eaea3d) Fix: [prefer-numeric-literals](/docs/rules/prefer-numeric-literals) autofix removes comments ([#12313](https://github.com/eslint/eslint/issues/12313)) (Milos Djermanovic)


## Documentation


* [`9b86167`](https://github.com/eslint/eslint/commit/9b86167e6f053e4a72bf68ebc79db53903f7f8c3) Docs: Add new ES environments to Configuring ESLint ([#12289](https://github.com/eslint/eslint/issues/12289)) (Milos Djermanovic)
* [`c9aeab2`](https://github.com/eslint/eslint/commit/c9aeab21a71c6743f51163b7a8fdf4f0cbfcdbde) Docs: Add supported ECMAScript version to README ([#12290](https://github.com/eslint/eslint/issues/12290)) (Milos Djermanovic)
* [`2c6bf8e`](https://github.com/eslint/eslint/commit/2c6bf8ea9c8a8f94746f980bd5bea0a8c5c4d6b7) Docs: English fix ([#12306](https://github.com/eslint/eslint/issues/12306)) (Daniel Nixon)
* [`2e202ca`](https://github.com/eslint/eslint/commit/2e202ca2228846e6226aa8dd99c614d572fb86a8) Docs: fix links in [array-callback-return](/docs/rules/array-callback-return) ([#12288](https://github.com/eslint/eslint/issues/12288)) (Milos Djermanovic)
* [`e39c631`](https://github.com/eslint/eslint/commit/e39c6318af0fd27edd5fd2aaf2b24a3e204005dd) Docs: add example for CLIEngine#executeOnText 3rd arg ([#12286](https://github.com/eslint/eslint/issues/12286)) (Kai Cataldo)
* [`9984c3e`](https://github.com/eslint/eslint/commit/9984c3e27c92de76b8c05a58525dbcea12b10b83) Docs: Update README team and sponsors (ESLint Jenkins)


## Chores


* [`160b7c4`](https://github.com/eslint/eslint/commit/160b7c46b556ccb6023eb411a8be8801a4bda6df) Chore: add autofix npm script ([#12330](https://github.com/eslint/eslint/issues/12330)) (Kai Cataldo)
* [`04b6adb`](https://github.com/eslint/eslint/commit/04b6adb7f1bcb2b6cb3fa377b1ca4cecd810630e) Chore: enable eslint-plugin-jsdoc (refs [#11146](https://github.com/eslint/eslint/issues/11146)) ([#12332](https://github.com/eslint/eslint/issues/12332)) (Kai Cataldo)
* [`29c12f1`](https://github.com/eslint/eslint/commit/29c12f18726a3afb21fc89ab1bdacc6972d49e68) Chore: cache results in runtime-info ([#12320](https://github.com/eslint/eslint/issues/12320)) (Kai Cataldo)
* [`f9fc695`](https://github.com/eslint/eslint/commit/f9fc695d77c19cd5ecb3f0e97e1ea124c8543409) Chore: enable [default-param-last](/docs/rules/default-param-last) ([#12244](https://github.com/eslint/eslint/issues/12244)) (薛定谔的猫)
