---
layout: post
title: ESLint v6.4.0 released
teaser: "We just pushed ESLint v6.4.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

* Three new rules: [no-import-assign](/docs/rules/no-import-assign), [prefer-regex-literals](/docs/rules/prefer-regex-literals), [default-param-last](/docs/rules/default-param-last)
* [accessor-pairs](/docs/rules/accessor-pairs) and [computed-property-spacing](/docs/rules/computed-property-spacing) rules has been updated with a new option `enforceForClassMembers`




## Features


* [`1c921c6`](https://github.com/eslint/eslint/commit/1c921c6dfd7ddfb0308c8103e53d32c1241475f0) New: add [no-import-assign](/docs/rules/no-import-assign) (fixes [#12237](https://github.com/eslint/eslint/issues/12237)) ([#12252](https://github.com/eslint/eslint/issues/12252)) (Toru Nagashima)
* [`3be04fd`](https://github.com/eslint/eslint/commit/3be04fd6a4e7b3f5a5ecb845a29cf29b71fe2dfb) New: Add [prefer-regex-literals](/docs/rules/prefer-regex-literals) rule (fixes [#12238](https://github.com/eslint/eslint/issues/12238)) ([#12254](https://github.com/eslint/eslint/issues/12254)) (Milos Djermanovic)
* [`0313441`](https://github.com/eslint/eslint/commit/0313441d016c8aa0674c135f9da67a676e766ec5) New: add rule [default-param-last](/docs/rules/default-param-last) (fixes [#11361](https://github.com/eslint/eslint/issues/11361)) ([#12188](https://github.com/eslint/eslint/issues/12188)) (Chiawen Chen)




## Enhancements


* [`540296f`](https://github.com/eslint/eslint/commit/540296fcecd232a09dc873a5a22f5839b59b7842) Update: enforceForClassMembers option to [accessor-pairs](/docs/rules/accessor-pairs) (fixes [#12063](https://github.com/eslint/eslint/issues/12063)) ([#12192](https://github.com/eslint/eslint/issues/12192)) (Milos Djermanovic)
* [`d3c2334`](https://github.com/eslint/eslint/commit/d3c2334646eae9287d5be9e457d041e445efb512) Update: flag nested block with declaration as error ([#12193](https://github.com/eslint/eslint/issues/12193)) (David Waller)
* [`b2498d2`](https://github.com/eslint/eslint/commit/b2498d284b9c30ed1543429c2f45d9014e12fe22) Update: Fix handling of property names in [no-self-assign](/docs/rules/no-self-assign) ([#12105](https://github.com/eslint/eslint/issues/12105)) (Milos Djermanovic)
* [`1ee61b0`](https://github.com/eslint/eslint/commit/1ee61b06715fcc750be2c923034a1e59ba663287) Update: enforceForClassMembers [computed-property-spacing](/docs/rules/computed-property-spacing) (fixes [#12049](https://github.com/eslint/eslint/issues/12049)) ([#12214](https://github.com/eslint/eslint/issues/12214)) (Milos Djermanovic)
* [`db2a29b`](https://github.com/eslint/eslint/commit/db2a29beb0fa28183f65bf9e659c66c03a8918b5) Update: indentation of comment followed by semicolon (fixes [#12232](https://github.com/eslint/eslint/issues/12232)) ([#12243](https://github.com/eslint/eslint/issues/12243)) (Kai Cataldo)
* [`37c0fde`](https://github.com/eslint/eslint/commit/37c0fdeb87b92a0b779b125adf45535b79b65757) Update: Report global Atomics calls in [no-obj-calls](/docs/rules/no-obj-calls) (fixes [#12234](https://github.com/eslint/eslint/issues/12234)) ([#12258](https://github.com/eslint/eslint/issues/12258)) (Milos Djermanovic)
* [`e38f5fd`](https://github.com/eslint/eslint/commit/e38f5fdfc786363a3eae642f1a69a8725600aa61) Update: fix [no-octal-escape](/docs/rules/no-octal-escape) false negatives after \0 ([#12079](https://github.com/eslint/eslint/issues/12079)) (Milos Djermanovic)
* [`7621f5d`](https://github.com/eslint/eslint/commit/7621f5d2aa7d87e798b75ca47d6889c280597e99) Update: add more specific linting messages to [space-in-parens](/docs/rules/space-in-parens) ([#11121](https://github.com/eslint/eslint/issues/11121)) (Che Fisher)




## Bug Fixes


* [`f826eab`](https://github.com/eslint/eslint/commit/f826eabbeecddb047f58f4e7308a14c18148d369) Fix: Allow line comment exception in [object-curly-spacing](/docs/rules/object-curly-spacing) (fixes [#11902](https://github.com/eslint/eslint/issues/11902)) ([#12216](https://github.com/eslint/eslint/issues/12216)) (Milos Djermanovic)
* [`ae17d1c`](https://github.com/eslint/eslint/commit/ae17d1ca59dd466aa64da0680ec2453c2dc3b80d) Fix: [no-sequences](/docs/rules/no-sequences) is reporting incorrect locations ([#12241](https://github.com/eslint/eslint/issues/12241)) (Milos Djermanovic)
* [`365331a`](https://github.com/eslint/eslint/commit/365331a42e22af5a77ac9cfa9673d6a8f653eb5a) Fix: [object-shorthand](/docs/rules/object-shorthand) providing invalid fixes for typescript ([#12260](https://github.com/eslint/eslint/issues/12260)) (Brad Zacher)
* [`985c9e5`](https://github.com/eslint/eslint/commit/985c9e5eba351965a8a1491a41dbdcc78154b8f4) Fix: [space-before-function-paren](/docs/rules/space-before-function-paren) autofix removes comments (fixes [#12259](https://github.com/eslint/eslint/issues/12259)) ([#12264](https://github.com/eslint/eslint/issues/12264)) (Milos Djermanovic)
* [`01da7d0`](https://github.com/eslint/eslint/commit/01da7d04c4e5a7376cf241ec02db7971726a1bf9) Fix: [eqeqeq](/docs/rules/eqeqeq) rule reports incorrect locations ([#12265](https://github.com/eslint/eslint/issues/12265)) (Milos Djermanovic)
* [`a41fdc0`](https://github.com/eslint/eslint/commit/a41fdc07404a7675d14183fab245fb8f49dcb858) Fix: Remove autofixer for [no-unsafe-negation](/docs/rules/no-unsafe-negation) ([#12157](https://github.com/eslint/eslint/issues/12157)) (Milos Djermanovic)
* [`21eb904`](https://github.com/eslint/eslint/commit/21eb9044135c01b6c12188517bba840614483fc6) Fix: basePath of OverrideTester (fixes [#12032](https://github.com/eslint/eslint/issues/12032)) ([#12205](https://github.com/eslint/eslint/issues/12205)) (Toru Nagashima)
* [`2b1a13f`](https://github.com/eslint/eslint/commit/2b1a13fa0de8360586857f3ced8da514c971297d) Fix: [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) reports wrong negation node (fixes [#11324](https://github.com/eslint/eslint/issues/11324)) ([#12197](https://github.com/eslint/eslint/issues/12197)) (Milos Djermanovic)
* [`e10eeba`](https://github.com/eslint/eslint/commit/e10eebab4abd193dee697c4de7fb2d95bbab2d8c) Fix: [quotes](/docs/rules/quotes) autofix produces syntax error with octal escape sequences ([#12118](https://github.com/eslint/eslint/issues/12118)) (Milos Djermanovic)




## Documentation


* [`e915fff`](https://github.com/eslint/eslint/commit/e915fffb6089a23ff1cae926cc607f9b87dc1819) Docs: Improve examples and clarify default option ([#12067](https://github.com/eslint/eslint/issues/12067)) (Yuping Zuo)
* [`520c922`](https://github.com/eslint/eslint/commit/520c92270eed6e90c1a796e8af275980f01705e0) Docs: Added naming convention details to plugin usage ([#12202](https://github.com/eslint/eslint/issues/12202)) (Henrique Barcelos)
* [`319e4d8`](https://github.com/eslint/eslint/commit/319e4d8386ea846928f0f906c251b46043a53491) Docs: adding finally example ([#12256](https://github.com/eslint/eslint/issues/12256)) (Jens Melgaard)
* [`d52328f`](https://github.com/eslint/eslint/commit/d52328f012f3704c7d1ce39427e63f80531c7979) Docs: fix [no-sequences](/docs/rules/no-sequences) `with` examples ([#12239](https://github.com/eslint/eslint/issues/12239)) (Milos Djermanovic)
* [`a0a9746`](https://github.com/eslint/eslint/commit/a0a9746724ccd22c721ddc1b25c566aa9acea154) Docs: Fix link in [no-irregular-whitespace](/docs/rules/no-irregular-whitespace).md ([#12196](https://github.com/eslint/eslint/issues/12196)) (Timo Tijhof)
