---
layout: post
title: ESLint v6.2.1 released
teaser: "We just pushed ESLint v6.2.1, which is a patch release upgrade of ESLint. This release fixes several bugs found in the previous release."
image: release-notes-patch.png
tags:
  - release
  - patch
authors:
  - kaicataldo
categories:
  - Release Notes
---

 This release includes a [security fix](https://github.com/mysticatea/eslint-utils/security/advisories/GHSA-3gx7-xhv7-5mx3) in the `eslint-utils` package, which is a dependency of ESLint. The security issue affects users that run ESLint on untrusted source code (e.g. servers that lint the user's project as a service). By taking advantage of a bug in a certain piece of analysis, a user could supply malicious source text that causes arbitrary code to be executed in the linting process.

* This issue affects versions of `eslint-utils` between v1.2.0 and v1.4.0.
* ESLint versions between v5.3.0 and v6.2.0 are potentially vulnerable (their allowed dependencies include vulnerable `eslint-utils` versions). However, these versions of ESLint can still be used safely if the `eslint-utils` dependency is updated to the latest version (e.g. by updating `eslint-utils` in a lockfile, or purging `node_modules` and reinstalling).
* ESLint v6.2.1 is not vulnerable to the issue.


## Documentation


* [`4aeeeed`](https://github.com/eslint/eslint/commit/4aeeeedb656ee3519ea82ebf0cb41ca801215046) Docs: update docs for ecmaVersion 2020 ([#12120](https://github.com/eslint/eslint/issues/12120)) (silverwind)
* [`6886148`](https://github.com/eslint/eslint/commit/6886148d1f528659ec3e125f61ef7a5f4c67556d) Docs: Add duplicate keys limitation to [accessor-pairs](/docs/rules/accessor-pairs) ([#12124](https://github.com/eslint/eslint/issues/12124)) (Milos Djermanovic)




## Dependency Upgrades


* [`8c021b5`](https://github.com/eslint/eslint/commit/8c021b5917b3aa3c578ffe3972106d0a6bcf0838) Upgrade: eslint-utils 1.4.2 ([#12131](https://github.com/eslint/eslint/issues/12131)) (Toru Nagashima)
