---
layout: post
title: ESLint v6.2.0 released
teaser: "We just pushed ESLint v6.2.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

* This release adds support for ES2020 syntax, which includes support for Dynamic Imports and `BigInt`. This can be enabled using `ecmaVersion: 2020` in your configuration file.
* A new rule, `function-call-argument-newline`, has been added.
* Many bug fixes thanks to [@mdjermanovic](https://github.com/mdjermanovic)!

## Features


* [`afd8012`](https://github.com/eslint/eslint/commit/afd8012c2797f2f5bf3c360cb241ea2ba6e1a489) New: noInlineConfig setting (refs [eslint/rfcs#22](https://github.com/eslint/rfcs/pull/22)) ([#12091](https://github.com/eslint/eslint/issues/12091)) (Toru Nagashima)
* [`8cd00b3`](https://github.com/eslint/eslint/commit/8cd00b308987e0db0bdb2e242bf13b2b07b350bd) New: [function-call-argument-newline](/docs/rules/function-call-argument-newline) ([#12024](https://github.com/eslint/eslint/issues/12024)) (finico)




## Enhancements


* [`fee6acb`](https://github.com/eslint/eslint/commit/fee6acbe13cecd4c028e681e185fc6a6d6ba9452) Update: support bigint and dynamic import (refs [#11803](https://github.com/eslint/eslint/issues/11803)) ([#11983](https://github.com/eslint/eslint/issues/11983)) (Toru Nagashima)
* [`3d12378`](https://github.com/eslint/eslint/commit/3d12378221961439c27ddae0ecda9845ac575107) Update: Fix [accessor-pairs](/docs/rules/accessor-pairs) to enforce pairs per property in literals ([#12062](https://github.com/eslint/eslint/issues/12062)) (Milos Djermanovic)
* [`2dc23b8`](https://github.com/eslint/eslint/commit/2dc23b81e54defbce7a70a7f26c2e4c7b692cf58) Update: fix [no-dupe-keys](/docs/rules/no-dupe-keys) false negatives on empty string names ([#12069](https://github.com/eslint/eslint/issues/12069)) (Milos Djermanovic)
* [`d642150`](https://github.com/eslint/eslint/commit/d642150fe016608e71a1df2a72960e915b3cfbad) Update: Check empty string property names in [sort-keys](/docs/rules/sort-keys) ([#12073](https://github.com/eslint/eslint/issues/12073)) (Milos Djermanovic)
* [`1aff8fc`](https://github.com/eslint/eslint/commit/1aff8fc4f9394cd9126654a55f7f3a43ab1cf8f0) Update: warn about mixing ternary and logical operators (fixes [#11704](https://github.com/eslint/eslint/issues/11704)) ([#12001](https://github.com/eslint/eslint/issues/12001)) (Karthik Priyadarshan)
* [`fbec99e`](https://github.com/eslint/eslint/commit/fbec99ea3e39316791685652c66e522d698f52d8) Update: fix [class-methods-use-this](/docs/rules/class-methods-use-this) false negatives with exceptMethods ([#12077](https://github.com/eslint/eslint/issues/12077)) (Milos Djermanovic)
* [`f5e0cc4`](https://github.com/eslint/eslint/commit/f5e0cc40795f175692acb05daaadb91e9e5ae5d3) Update: Check computed method keys in [no-extra-parens](/docs/rules/no-extra-parens) ([#11973](https://github.com/eslint/eslint/issues/11973)) (Milos Djermanovic)
* [`5831767`](https://github.com/eslint/eslint/commit/58317673210e48be3975e317c2c566fae155c94f) Update: report location of [func-names](/docs/rules/func-names) (fixes [#12022](https://github.com/eslint/eslint/issues/12022)) ([#12028](https://github.com/eslint/eslint/issues/12028)) (Pig Fang)




## Bug Fixes


* [`30ebf92`](https://github.com/eslint/eslint/commit/30ebf929f60684520b1201c1adfd86214c19d614) Fix: [prefer-template](/docs/rules/prefer-template) autofix produces syntax error with octal escapes ([#12085](https://github.com/eslint/eslint/issues/12085)) (Milos Djermanovic)
* [`13c3988`](https://github.com/eslint/eslint/commit/13c3988a4001ae368ea7b6c8d3dd0abfa7c6cf64) Fix: Check literal type explicitly in [dot-notation](/docs/rules/dot-notation) ([#12095](https://github.com/eslint/eslint/issues/12095)) (Milos Djermanovic)
* [`3e5ceca`](https://github.com/eslint/eslint/commit/3e5ceca4d2284b55a2292a1d3de9aa4cdf6fa213) Fix: Handle empty string property names in getFunctionNameWithKind ([#12104](https://github.com/eslint/eslint/issues/12104)) (Milos Djermanovic)
* [`9a043ff`](https://github.com/eslint/eslint/commit/9a043ffbb864fc65baeb16fe5668435e3b7cfe34) Fix: [no-duplicate-case](/docs/rules/no-duplicate-case) false positives on Object.prototype keys ([#12107](https://github.com/eslint/eslint/issues/12107)) (Milos Djermanovic)
* [`4cb7877`](https://github.com/eslint/eslint/commit/4cb78774f6cc687a3c8701462f8c7f7b587ecaf0) Fix: fix [no-extra-parens](/docs/rules/no-extra-parens) ignores some nodes ([#11909](https://github.com/eslint/eslint/issues/11909)) (Pig Fang)
* [`19ab666`](https://github.com/eslint/eslint/commit/19ab6666e8e4142a183bdee2be96e5bafbac0e21) Fix: [yoda](/docs/rules/yoda) exceptRange false positives on empty string property names ([#12071](https://github.com/eslint/eslint/issues/12071)) (Milos Djermanovic)
* [`acce6de`](https://github.com/eslint/eslint/commit/acce6de940e2b089ff5ba59e4518a54af1682d5e) Fix: [class-methods-use-this](/docs/rules/class-methods-use-this) reports 'undefined' names ([#12103](https://github.com/eslint/eslint/issues/12103)) (Milos Djermanovic)
* [`92ec2cb`](https://github.com/eslint/eslint/commit/92ec2cb1731b7b6e0ac66336d583fbb782504290) Fix: Allow bind call with a single spread element in [no-extra-bind](/docs/rules/no-extra-bind) ([#12088](https://github.com/eslint/eslint/issues/12088)) (Milos Djermanovic)
* [`bfdb0c9`](https://github.com/eslint/eslint/commit/bfdb0c97003fc0e045aa6ed10b177c35305a6e46) Fix: [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) invalid autofix for Boolean() without args ([#12076](https://github.com/eslint/eslint/issues/12076)) (Milos Djermanovic)
* [`cf31dab`](https://github.com/eslint/eslint/commit/cf31dab5d5982151e0cfcc32879e69a83180ec70) Fix: [no-restricted-syntax](/docs/rules/no-restricted-syntax) - correct the schema ([#12051](https://github.com/eslint/eslint/issues/12051)) (Brad Zacher)




## Documentation


* [`01d38ce`](https://github.com/eslint/eslint/commit/01d38ce2faf0abbc9dd5d25694baeee131036165) Docs: Remove TDZ scope from the scope manager interface documentation ([#12054](https://github.com/eslint/eslint/issues/12054)) (Milos Djermanovic)
* [`11be2f8`](https://github.com/eslint/eslint/commit/11be2f8513bd61499f6247392a33ac0a26901c90) Docs: do not recommend global-installed usage ([#12016](https://github.com/eslint/eslint/issues/12016)) (薛定谔的猫)
* [`fb08b7c`](https://github.com/eslint/eslint/commit/fb08b7c9d28bc68864eb940e26df274059228b6a) Docs: Remove readonly/writable global logic from [no-undef](/docs/rules/no-undef) (fixes [#11963](https://github.com/eslint/eslint/issues/11963)) ([#12053](https://github.com/eslint/eslint/issues/12053)) (Milos Djermanovic)
* [`d961438`](https://github.com/eslint/eslint/commit/d9614388df8cfb977842ed7ac4725d76a3e05df3) Docs: Fix Incorrect Documentation ([#12045](https://github.com/eslint/eslint/issues/12045)) (Michael Miceli)
* [`d90183f`](https://github.com/eslint/eslint/commit/d90183ff6757cff854f4ca4d25b835143dfb4b21) Docs: add a case to [func-names](/docs/rules/func-names) ([#12038](https://github.com/eslint/eslint/issues/12038)) (Chiawen Chen)
* [`8a5b62d`](https://github.com/eslint/eslint/commit/8a5b62de2ae574f416c0f8ad91205da9b1837275) Docs: no use eslint.linter in code example ([#12037](https://github.com/eslint/eslint/issues/12037)) (薛定谔的猫)








## Chores


* [`fe631af`](https://github.com/eslint/eslint/commit/fe631afee59641876598d19b1935967099cc6fa0) Chore: minor typo fix ([#12112](https://github.com/eslint/eslint/issues/12112)) (James George)
* [`34ccc0c`](https://github.com/eslint/eslint/commit/34ccc0cd81f495190e585c6efa8ae233d45bd3ed) Chore: Remove TDZ scope type condition from [no-unused-vars](/docs/rules/no-unused-vars) ([#12055](https://github.com/eslint/eslint/issues/12055)) (Milos Djermanovic)
