---
layout: post
title: ESLint v6.0.0 released
teaser: "We just pushed ESLint v6.0.0, which is a major release of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-major.png
tags:
  - release
  - patch
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

* There are several breaking changes in 6.0.0. We've created a [migration guide](/docs/user-guide/migrating-to-6.0.0) to explain the breaking changes and describe how to upgrade.
* Configuration using glob patterns now supports `extends` and nested `overrides`
* Using multiple [processors](/docs/user-guide/configuring#specifying-processor) is now supported.
* The [`function-paren-newline`](/docs/rules/function-paren-newline) rule has a new `multiline-arguments` option.
* The [`sort-keys`](/docs/rules/sort-keys) rule now supports a `minKeys` option.


---

Changes since v6.0.0-rc.0:

## Bug Fixes


* [`5f022bc`](https://github.com/eslint/eslint/commit/5f022bc91d0d93d140876ceb1ee4e08b1b7cfd49) Fix: [no-else-return](/docs/rules/no-else-return) autofix produces name collisions (fixes [#11069](https://github.com/eslint/eslint/issues/11069)) ([#11867](https://github.com/eslint/eslint/issues/11867)) (Milos Djermanovic)
* [`ded9548`](https://github.com/eslint/eslint/commit/ded9548d881b15e771ca79b844e8159601f30f70) Fix: [multiline-comment-style](/docs/rules/multiline-comment-style) incorrect message ([#11864](https://github.com/eslint/eslint/issues/11864)) (golopot)
* [`c844c6f`](https://github.com/eslint/eslint/commit/c844c6f2ff314cfa8c6ca0e35a1ef58b7e297b79) Fix: [max-len](/docs/rules/max-len) properly ignore trailing comments (fixes [#11838](https://github.com/eslint/eslint/issues/11838)) ([#11841](https://github.com/eslint/eslint/issues/11841)) (ZYSzys)
* [`1b5661a`](https://github.com/eslint/eslint/commit/1b5661ae467c227c0239e06cc1466480004aa799) Fix: [no-var](/docs/rules/no-var) should not fix variables named 'let' (fixes [#11830](https://github.com/eslint/eslint/issues/11830)) ([#11832](https://github.com/eslint/eslint/issues/11832)) (Milos Djermanovic)
* [`81c3823`](https://github.com/eslint/eslint/commit/81c382378923a45015bafe58362f6c8faa5c3d5f) Fix: [require-atomic-updates](/docs/rules/require-atomic-updates) reports parameters (fixes [#11723](https://github.com/eslint/eslint/issues/11723)) ([#11774](https://github.com/eslint/eslint/issues/11774)) (Toru Nagashima)




## Documentation


* [`cad074d`](https://github.com/eslint/eslint/commit/cad074d4ddb34a59183b5965ca50170713b5a711) Docs: Add JSHint W047 compat to [no-floating-decimal](/docs/rules/no-floating-decimal) ([#11861](https://github.com/eslint/eslint/issues/11861)) (Timo Tijhof)
* [`65faa04`](https://github.com/eslint/eslint/commit/65faa04e8b42eecd4505111bbff296951179f033) Docs: Clarify [prefer-destructuring](/docs/rules/prefer-destructuring) array/object difference (fixes [#9970](https://github.com/eslint/eslint/issues/9970)) ([#11851](https://github.com/eslint/eslint/issues/11851)) (Oliver Sieweke)




## Dependency Upgrades


* [`81aa06b`](https://github.com/eslint/eslint/commit/81aa06b4cc49e9c15234a2c4d27659a03fea53d8) Upgrade: espree@6.0.0 ([#11869](https://github.com/eslint/eslint/issues/11869)) (Teddy Katz)
* [`41f6304`](https://github.com/eslint/eslint/commit/41f6304ce641a82ee729251b448dceb9fb0d501d) Upgrade: sinon ([#11855](https://github.com/eslint/eslint/issues/11855)) (Toru Nagashima)
* [`c57a4a4`](https://github.com/eslint/eslint/commit/c57a4a4a993193c4208c6419df331a7bc644a536) Upgrade: @babel/polyfill => core-js v3 ([#11833](https://github.com/eslint/eslint/issues/11833)) (薛定谔的猫)




## Build Related


* [`4d75956`](https://github.com/eslint/eslint/commit/4d75956147b6fd662ee90eb21d3f762816463b88) Build: CI with Azure Pipelines ([#11845](https://github.com/eslint/eslint/issues/11845)) (Toru Nagashima)




## Chores


* [`167ce87`](https://github.com/eslint/eslint/commit/167ce87e908ec04b0d3d79960278d45c883c4285) Chore: remove unuseable profile command ([#11854](https://github.com/eslint/eslint/issues/11854)) (Toru Nagashima)
* [`1db3462`](https://github.com/eslint/eslint/commit/1db346220889305a427b45a00afcf362b81b3767) Chore: rm superfluous argument & fix perf-multifiles-targets ([#11834](https://github.com/eslint/eslint/issues/11834)) (薛定谔的猫)
