---
layout: post
title: ESLint v6.0.0-rc.0 released
teaser: We just pushed ESLint v6.0.0-rc.0, which is a new prerelease version for ESLint v6. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

1. BigInt and dynamic import are at stage 4 (aside from some TC39 formalities), so we have begun to accept PRs to incorporate them into core ESLint rules. The [`valid-typeof`](/docs/rules/valid-typeof) rule now supports BigInt. Please see [#11803](https://github.com/eslint/eslint/issues/11803) to track our progress in fully supporting these newly standardized language features.
1. The [`sort-keys`](/docs/rules/sort-keys) rule now supports a `minKeys` option.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@6.0.0-rc.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/6.0.0/user-guide/migrating-to-6.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.

## Features

* [`d662b17`](https://github.com/eslint/eslint/commit/d662b178c7dad193201564d16f7977af2f81ebcf) New: Add classname attribute to JUnit testcase (refs [#11068](https://github.com/eslint/eslint/issues/11068)) ([#11683](https://github.com/eslint/eslint/issues/11683)) (Fabio Pitino)

## Enhancements

* [`f403b07`](https://github.com/eslint/eslint/commit/f403b07283f91f1285d8318d6acea851dd765755) Update: introduce minKeys option to [sort-keys](/docs/rules/sort-keys) rule (fixes [#11624](https://github.com/eslint/eslint/issues/11624)) ([#11625](https://github.com/eslint/eslint/issues/11625)) (Christian)
* [`e4ab053`](https://github.com/eslint/eslint/commit/e4ab0531c4e44c23494c6a802aa2329d15ac90e5) Update: support "bigint" in [valid-typeof](/docs/rules/valid-typeof) rule ([#11802](https://github.com/eslint/eslint/issues/11802)) (Colin Ihrig)
* [`37e5193`](https://github.com/eslint/eslint/commit/37e5193102d7544f155cdcb09c7c50dc602914d4) Update: add `endColumn` to [no-useless-escape](/docs/rules/no-useless-escape) (fixes [#11629](https://github.com/eslint/eslint/issues/11629)) ([#11790](https://github.com/eslint/eslint/issues/11790)) (Pig Fang)
* [`9590587`](https://github.com/eslint/eslint/commit/9590587cef74c936ef9b7ce2d22a71e2fd0fbbc4) Update: improve reported location of [arrow-parens](/docs/rules/arrow-parens) (fixes [#11773](https://github.com/eslint/eslint/issues/11773)) ([#11775](https://github.com/eslint/eslint/issues/11775)) (Pig Fang)

## Bug Fixes

* [`87451f4`](https://github.com/eslint/eslint/commit/87451f4779bc4c0ec874042b6854920f947ee258) Fix: [no-octal](/docs/rules/no-octal) should report NonOctalDecimalIntegerLiteral (fixes [#11794](https://github.com/eslint/eslint/issues/11794)) ([#11805](https://github.com/eslint/eslint/issues/11805)) (Milos Djermanovic)
* [`21f3131`](https://github.com/eslint/eslint/commit/21f3131aa1636afa8e5c01053e0e870f968425b1) Fix: `overrides` handle relative paths as expected (fixes [#11577](https://github.com/eslint/eslint/issues/11577)) ([#11799](https://github.com/eslint/eslint/issues/11799)) (Toru Nagashima)
* [`5509cdf`](https://github.com/eslint/eslint/commit/5509cdfa1b3d575248eef89a935f79c82e3f3071) Fix: fails the test case if autofix made syntax error (fixes [#11615](https://github.com/eslint/eslint/issues/11615)) ([#11798](https://github.com/eslint/eslint/issues/11798)) (Toru Nagashima)
* [`cb1922b`](https://github.com/eslint/eslint/commit/cb1922bdc07e58de0e55c13fd992dd8faf3292a4) Fix: show custom message for namespace import (fixes [#11580](https://github.com/eslint/eslint/issues/11580)) ([#11791](https://github.com/eslint/eslint/issues/11791)) (Pig Fang)

## Documentation

* [`20908a3`](https://github.com/eslint/eslint/commit/20908a38f489c285abf8fceef4d9d13bf8b87f22) Docs: removed '>' prefix from from docs/working-with-rules ([#11818](https://github.com/eslint/eslint/issues/11818)) (Alok Takshak)

## Build Related

* [`ad4b048`](https://github.com/eslint/eslint/commit/ad4b048c6d034cbd7fd97deb4390d059bde8803f) Build: Fix typo in blog post template (fixes [#11614](https://github.com/eslint/eslint/issues/11614)) ([#11782](https://github.com/eslint/eslint/issues/11782)) (Kai Cataldo)

## Chores

* [`e0fafc8`](https://github.com/eslint/eslint/commit/e0fafc8ef59a80a6137f4170bbe46582d6fbcafc) Chore: removes unnecessary assignment in loop ([#11780](https://github.com/eslint/eslint/issues/11780)) (Dimitri Mitropoulos)
* [`8eaa9b2`](https://github.com/eslint/eslint/commit/8eaa9b259dc08dfb48269b1e4413d0d47698ed87) Chore: remove incorrect comment ([#11769](https://github.com/eslint/eslint/issues/11769)) (薛定谔的猫)
* [`4039a49`](https://github.com/eslint/eslint/commit/4039a49177f2fefacd747050b420c0c4560b7d4b) Chore: add .github/funding.yml ([#11764](https://github.com/eslint/eslint/issues/11764)) (Toru Nagashima)
