---
layout: post
title: ESLint v6.0.0-alpha.1 released
teaser: "We just pushed ESLint v6.0.0-alpha.1, which is a new prerelease for ESLint v6. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

Most of the highlights of this release are breaking changes, and are discussed further in the [migration guide](/docs/6.0.0/user-guide/migrating-to-6.0.0).

New breaking changes in this prerelease include:

* [Some config-loading bugs have been fixed](/docs/6.0.0/user-guide/migrating-to-6.0.0#-overrides-in-an-extended-config-file-can-now-be-overridden-by-a-parent-config-file). This change involved some refactoring to how config files are processed internally. Please let us know if you encounter any problems relating to configuration in this release.
* [`eslint:recommended` has been updated](/docs/6.0.0/user-guide/migrating-to-6.0.0#-eslintrecommended-has-been-updated)
* [`no-redeclare` has been made stricter](/docs/6.0.0/user-guide/migrating-to-6.0.0#no-redeclare-updates)

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@6.0.0-alpha.1 --save-dev
```

### Migration Guide

If you're upgrading from ESLint v5.x, we recommend looking at the [migration guide](/docs/6.0.0/user-guide/migrating-to-6.0.0), which describes the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.


## Breaking Changes


* [`6ae21a4`](https://github.com/eslint/eslint/commit/6ae21a4bfe5a1566f787fbad798182a524b96d28) Breaking: fix config loading (fixes [#11510](https://github.com/eslint/eslint/issues/11510), fixes [#11559](https://github.com/eslint/eslint/issues/11559), fixes [#11586](https://github.com/eslint/eslint/issues/11586)) ([#11546](https://github.com/eslint/eslint/issues/11546)) (Toru Nagashima)
* [`0fc8e62`](https://github.com/eslint/eslint/commit/0fc8e62818bc8d0a0a804b59c6110818844df5f3) Breaking: eslint:recommended changes (fixes [#10768](https://github.com/eslint/eslint/issues/10768)) ([#11518](https://github.com/eslint/eslint/issues/11518)) (薛定谔的猫)
* [`20364cc`](https://github.com/eslint/eslint/commit/20364cc4f7fe0423adce0dd44fb24fc48e1cae4b) Breaking: make [no-redeclare](/docs/rules/no-redeclare) stricter (fixes [#11370](https://github.com/eslint/eslint/issues/11370), fixes [#11405](https://github.com/eslint/eslint/issues/11405)) ([#11509](https://github.com/eslint/eslint/issues/11509)) (Toru Nagashima)




## Features


* [`21dd211`](https://github.com/eslint/eslint/commit/21dd2116c70b93aa8dd50d2b15e202724b11486a) New: add --resolve-plugins-relative-to flag ([#11696](https://github.com/eslint/eslint/issues/11696)) (Teddy Katz)






## Bug Fixes


* [`252efd3`](https://github.com/eslint/eslint/commit/252efd337b1441debb6d2cc8f51a625549b2c535) Fix: delete unnecessary duplicated question (fixes [#11617](https://github.com/eslint/eslint/issues/11617)) ([#11618](https://github.com/eslint/eslint/issues/11618)) (HelloRusk)
* [`1a3a88d`](https://github.com/eslint/eslint/commit/1a3a88df2f952c34631d8e1d83de47178826fce0) Fix: Curly rule incorrectly flagging lexical declarations (fixes [#11663](https://github.com/eslint/eslint/issues/11663)) ([#11675](https://github.com/eslint/eslint/issues/11675)) (Brian Kurek)
* [`f47d72c`](https://github.com/eslint/eslint/commit/f47d72ce2f2edb80cd38810894b9d4bda896bb29) Fix: not set ecmaVersion to 6 when sourceType=module (fixes [#9687](https://github.com/eslint/eslint/issues/9687)) ([#11649](https://github.com/eslint/eslint/issues/11649)) (薛定谔的猫)
* [`9484e9e`](https://github.com/eslint/eslint/commit/9484e9ea188ff70683c3112e397c7fddcc3f8095) Fix: ignore return statements in dead code (fixes [#11647](https://github.com/eslint/eslint/issues/11647)) ([#11688](https://github.com/eslint/eslint/issues/11688)) (Toru Nagashima)
* [`aae6f65`](https://github.com/eslint/eslint/commit/aae6f6525557ba06e73f051511646056313fcf91) Fix: don't use deprecated API ([#11689](https://github.com/eslint/eslint/issues/11689)) (Toru Nagashima)
* [`e4400b5`](https://github.com/eslint/eslint/commit/e4400b5a02602bba7f67ea4cb874c231903c546a) Fix: [require-atomic-updates](/docs/rules/require-atomic-updates) false positive (fixes [#11194](https://github.com/eslint/eslint/issues/11194), fixes [#11687](https://github.com/eslint/eslint/issues/11687)) ([#11224](https://github.com/eslint/eslint/issues/11224)) (Toru Nagashima)
* [`776b0fe`](https://github.com/eslint/eslint/commit/776b0fe3d93da958517ac7752682091f22eb30b4) Fix: update rule message of [no-throw-literal](/docs/rules/no-throw-literal) (fixes [#11637](https://github.com/eslint/eslint/issues/11637)) ([#11638](https://github.com/eslint/eslint/issues/11638)) (Pig Fang)
* [`67c08b6`](https://github.com/eslint/eslint/commit/67c08b67509c54acd96aab2cec22efb53bfe6265) Fix: consider comments in [object-curly-spacing](/docs/rules/object-curly-spacing) (fixes [#11656](https://github.com/eslint/eslint/issues/11656)) ([#11657](https://github.com/eslint/eslint/issues/11657)) (Pig Fang)
* [`b6d41cb`](https://github.com/eslint/eslint/commit/b6d41cbe28a8b28b1c1d9aa36cb4c349c73f6f1d) Fix: check token before using in [no-cond-assign](/docs/rules/no-cond-assign) (fixes [#11611](https://github.com/eslint/eslint/issues/11611)) ([#11619](https://github.com/eslint/eslint/issues/11619)) (Pig Fang)
* [`1dfe077`](https://github.com/eslint/eslint/commit/1dfe077b7e47c6090277eb984e08bd472bb5595e) Fix: autofix of [no-unneeded-ternary](/docs/rules/no-unneeded-ternary) made syntax error (fixes [#11579](https://github.com/eslint/eslint/issues/11579)) ([#11616](https://github.com/eslint/eslint/issues/11616)) (Toru Nagashima)




## Documentation


* [`e84b6f8`](https://github.com/eslint/eslint/commit/e84b6f8b171ba4266164688f76d5ee45d278e5c2) Docs: fix example in [object-curly-newline](/docs/rules/object-curly-newline) docs ([#11633](https://github.com/eslint/eslint/issues/11633)) (golopot)
* [`483239e`](https://github.com/eslint/eslint/commit/483239ec74a0c13529fc99547a784b749f41dd54) Docs: updated ImportDeclaration in docs-rules-[indent](/docs/rules/indent) ([#11679](https://github.com/eslint/eslint/issues/11679)) (Alok Takshak)
* [`4b3b036`](https://github.com/eslint/eslint/commit/4b3b036d6240cdbc2d52e670de36b1117f5f34d7) Docs: replace `var` with `const` in code examples ([#11655](https://github.com/eslint/eslint/issues/11655)) (Niyaz Akhmetov)
* [`f2e7828`](https://github.com/eslint/eslint/commit/f2e78281d057f38b18cc160e81ed1bb54a5b9565) Docs: Fix Node 6 LTS EOL date ([#11676](https://github.com/eslint/eslint/issues/11676)) (James Ross)
* [`adc6585`](https://github.com/eslint/eslint/commit/adc6585ce074e03fc8a842e8ebc5b082a0ed0b65) Docs: update status of breaking changes in migration guide ([#11652](https://github.com/eslint/eslint/issues/11652)) (Teddy Katz)
* [`eef71e4`](https://github.com/eslint/eslint/commit/eef71e455e67040168c8df8a6c9c2b4fbe805a50) Docs: add missing items to migration guide ([#11628](https://github.com/eslint/eslint/issues/11628)) (Teddy Katz)
* [`bebd079`](https://github.com/eslint/eslint/commit/bebd0793eaf122b013cca501ff2c6b0fc05d5493) Docs: fix grammar mistake in [no-caller](/docs/rules/no-caller) docs ([#11623](https://github.com/eslint/eslint/issues/11623)) (Daniel Lemay)






## Build Related


* [`f62a451`](https://github.com/eslint/eslint/commit/f62a4510b007172c7160f007a6ec2aa2c9a80dd7) Build: add node 12 ([#11648](https://github.com/eslint/eslint/issues/11648)) (薛定谔的猫)




## Chores


* [`f42d0af`](https://github.com/eslint/eslint/commit/f42d0afd89874b459fce1eb1998247d53f9aa42b) Chore: lazy loading for rules ([#11705](https://github.com/eslint/eslint/issues/11705)) (Toru Nagashima)
* [`f5bae78`](https://github.com/eslint/eslint/commit/f5bae78c19d5359f67969a2ff344025082e253f4) Chore: fix CLIEngine tests when os.tmpdir is a symlink ([#11697](https://github.com/eslint/eslint/issues/11697)) (Teddy Katz)
* [`e4a08ba`](https://github.com/eslint/eslint/commit/e4a08bae82788136b6899262cb8b9ed4fe7964e6) Chore: update eslint-plugin-node to 9.0.0 ([#11670](https://github.com/eslint/eslint/issues/11670)) (Toru Nagashima)
* [`7f290a9`](https://github.com/eslint/eslint/commit/7f290a9044ca795884ac2e495cd31b2a35f109a6) Chore: add eslint as a devDependeny ([#11654](https://github.com/eslint/eslint/issues/11654)) (Toru Nagashima)
* [`139fd2f`](https://github.com/eslint/eslint/commit/139fd2f1254bcc524738f8c2645e0847df95e0d0) Chore: add markdownlint-cli ([#11653](https://github.com/eslint/eslint/issues/11653)) (Toru Nagashima)
* [`8b4dba6`](https://github.com/eslint/eslint/commit/8b4dba606f8306f8ad0a37e2174a6e3236f7ebe7) Chore: Add linting to git commit ([#11556](https://github.com/eslint/eslint/issues/11556)) (Nicholas C. Zakas)
