---
layout: post
title: ESLint v6.0.0-alpha.0 released
teaser: "We just pushed ESLint v6.0.0-alpha.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

Most of the highlights of this release are breaking changes, and are discussed further in the [migration guide](/docs/6.0.0/user-guide/migrating-to-6.0.0).

Non-breaking highlights:

* The [`function-paren-newline`](/docs/rules/function-paren-newline) rule has a new `multiline-arguments` option.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@6.0.0-alpha.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/6.0.0/user-guide/migrating-to-6.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.




## Breaking Changes


* [`9e49b56`](https://github.com/eslint/eslint/commit/9e49b56c08fd0e449fddab45dfeb0da8d918b460) Breaking: upgrade espree to 6.0.0-alpha.0 (fixes [#9687](https://github.com/eslint/eslint/issues/9687)) ([#11610](https://github.com/eslint/eslint/issues/11610)) (Teddy Katz)
* [`ef7801e`](https://github.com/eslint/eslint/commit/ef7801ea510e12a9ca4963bcc8ec7e3aacc75ff0) Breaking: disallow invalid rule defaults in RuleTester (fixes [#11473](https://github.com/eslint/eslint/issues/11473)) ([#11599](https://github.com/eslint/eslint/issues/11599)) (Teddy Katz)
* [`4e7cdca`](https://github.com/eslint/eslint/commit/4e7cdca571632a3f3c32b39eb03022fe88ca8b30) Breaking: [comma-dangle](/docs/rules/comma-dangle) enable functions: "never" (fixes [#11502](https://github.com/eslint/eslint/issues/11502)) ([#11519](https://github.com/eslint/eslint/issues/11519)) (薛定谔的猫)
* [`12f256f`](https://github.com/eslint/eslint/commit/12f256f22534c4a4e1ca0ba54c37c6db81441461) Breaking: [no-confusing-arrow](/docs/rules/no-confusing-arrow) enable allowParens: true (fixes [#11503](https://github.com/eslint/eslint/issues/11503)) ([#11520](https://github.com/eslint/eslint/issues/11520)) (薛定谔的猫)
* [`25cc63d`](https://github.com/eslint/eslint/commit/25cc63d47e6c0aea8b88589a088c1f0de5f6f1cc) Breaking: simplify config/plugin/parser resolution (fixes [#10125](https://github.com/eslint/eslint/issues/10125)) ([#11388](https://github.com/eslint/eslint/issues/11388)) (Teddy Katz)
* [`fd1c91b`](https://github.com/eslint/eslint/commit/fd1c91b00e8d8c3a83d21e60668d5f1fa61cb214) Breaking: throw an error for invalid global configs (refs [#11338](https://github.com/eslint/eslint/issues/11338)) ([#11517](https://github.com/eslint/eslint/issues/11517)) (Teddy Katz)
* [`be83322`](https://github.com/eslint/eslint/commit/be833229b355eafb90f3e0bbc29bb106e100bed0) Breaking: Remove extra rules from eslint:recommended (fixes [#10873](https://github.com/eslint/eslint/issues/10873)) ([#11357](https://github.com/eslint/eslint/issues/11357)) (Kevin Partington)
* [`2543f11`](https://github.com/eslint/eslint/commit/2543f11dfe8069ed5096073169cf6791d42454db) Breaking: remove deprecated experimentalObjectRestSpread option ([#11420](https://github.com/eslint/eslint/issues/11420)) (Teddy Katz)
* [`0fb5fd4`](https://github.com/eslint/eslint/commit/0fb5fd402334098dc44cbfbb8ab25919da04843d) Breaking: interpret rule options as unicode regexes (fixes [#11423](https://github.com/eslint/eslint/issues/11423)) ([#11516](https://github.com/eslint/eslint/issues/11516)) (Teddy Katz)
* [`6e7da57`](https://github.com/eslint/eslint/commit/6e7da57dddc41830df4aee77e31c4320c1557350) Breaking: drop Node.js 6 support (fixes [#11456](https://github.com/eslint/eslint/issues/11456)) ([#11557](https://github.com/eslint/eslint/issues/11557)) (Toru Nagashima)






## Enhancements


* [`5cfdc2d`](https://github.com/eslint/eslint/commit/5cfdc2d08307c63bec487e76d2f470ef84166867) Update: Improve [no-loop-func](/docs/rules/no-loop-func) rule description and message ([#11046](https://github.com/eslint/eslint/issues/11046)) (Pedro Lopes)
* [`2f8ae13`](https://github.com/eslint/eslint/commit/2f8ae1397eef3625fe66636e95b0b312c6ff8a37) Update: support single argument on newline with [function-paren-newline](/docs/rules/function-paren-newline) ([#11406](https://github.com/eslint/eslint/issues/11406)) (Vladlen Grachev)




## Bug Fixes


* [`0127d10`](https://github.com/eslint/eslint/commit/0127d107590acabfdea4a68b56acbeee6a7b9daa) Fix: [no-var](/docs/rules/no-var) fixed to incorrect code (fixes [#11441](https://github.com/eslint/eslint/issues/11441)) ([#11443](https://github.com/eslint/eslint/issues/11443)) (薛定谔的猫)
* [`608a02c`](https://github.com/eslint/eslint/commit/608a02c60656b96c3219d342eee7e98b55bdd580) Fix: [object-shorthand](/docs/rules/object-shorthand) ignoreConstructors option (fixes [#11595](https://github.com/eslint/eslint/issues/11595)) ([#11596](https://github.com/eslint/eslint/issues/11596)) (overlookmotel)
* [`b92ca6e`](https://github.com/eslint/eslint/commit/b92ca6ea8ae46b92c258921e8b5b40f5035dbc43) Fix: getErrorResults function to not mutate passed parameter ([#11592](https://github.com/eslint/eslint/issues/11592)) (danielamaia)
* [`19248e0`](https://github.com/eslint/eslint/commit/19248e0838425748d75518fe9f0a985587793378) Fix: make `overrides[].files` matching dotfiles (fixes [#11201](https://github.com/eslint/eslint/issues/11201)) ([#11225](https://github.com/eslint/eslint/issues/11225)) (Toru Nagashima)




## Documentation


* [`8bfd1d1`](https://github.com/eslint/eslint/commit/8bfd1d138001d4493180b2fcff3330b42d0bb7cb) Docs: add v6.0.0 migration guide ([#11515](https://github.com/eslint/eslint/issues/11515)) (Teddy Katz)
* [`cbdee62`](https://github.com/eslint/eslint/commit/cbdee6230d22522c37259449467ace16f28ea8e8) Docs: README updates to reflect JSCS compat project is finished ([#11568](https://github.com/eslint/eslint/issues/11568)) (Kevin Partington)
* [`595de40`](https://github.com/eslint/eslint/commit/595de4074fac1b5839f56b29fe0106a7fda7e3e0) Docs: edit [arrow-parens](/docs/rules/arrow-parens) as-needed explanation (fixes [#11202](https://github.com/eslint/eslint/issues/11202)) ([#11569](https://github.com/eslint/eslint/issues/11569)) (Logan Lowder)
* [`a73b4b8`](https://github.com/eslint/eslint/commit/a73b4b8d6398b00bdaf90599d9e6d1c80f000f88) Docs: Update README team and sponsors (ESLint Jenkins)




## Dependency Upgrades


* [`eeea893`](https://github.com/eslint/eslint/commit/eeea89361d48494995446ddb6ee6f049457911ec) Upgrade: update js-yaml package to 3.13.1 version ([#11607](https://github.com/eslint/eslint/issues/11607)) (Pobegaylo Maksim)
* [`e70d5f7`](https://github.com/eslint/eslint/commit/e70d5f7573a9641d7b63394df53a3ef86183445c) Upgrade: compatible deps ([#11608](https://github.com/eslint/eslint/issues/11608)) (薛定谔的猫)
* [`3396c3e`](https://github.com/eslint/eslint/commit/3396c3e2231b5b6e16da8751c22c86c256590f6b) Upgrade: karma@^4.0.1, drops Node 6 support, fixes vulnerability ([#11570](https://github.com/eslint/eslint/issues/11570)) (Kevin Partington)






## Chores


* [`3d9e137`](https://github.com/eslint/eslint/commit/3d9e1372aad1e174b5438e3d6bd75fdefba06bad) Chore: fix test that fails when the CWD contains a space ([#11612](https://github.com/eslint/eslint/issues/11612)) (Teddy Katz)
