---
layout: post
title: ESLint v5.15.0 released
teaser: "We just pushed ESLint v5.15.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

The [prefer-named-capture-group](/docs/rules/prefer-named-capture-group) rule has been added. This rule encourages the use of [named capture groups](https://github.com/tc39/proposal-regexp-named-groups) over numbered capture groups.

## Features


* [`ec59ec0`](https://github.com/eslint/eslint/commit/ec59ec09c8d001b8c04f9edc09994e2b0d0af0f9) New: add rule "[prefer-named-capture-group](/docs/rules/prefer-named-capture-group)" (fixes [#11381](https://github.com/eslint/eslint/issues/11381)) ([#11392](https://github.com/eslint/eslint/issues/11392)) (Pig Fang)




## Enhancements


* [`de5cbc5`](https://github.com/eslint/eslint/commit/de5cbc526b30405e742b35d85d04361529d49ed4) Update: remove invalid defaults from core rules (fixes [#11415](https://github.com/eslint/eslint/issues/11415)) ([#11427](https://github.com/eslint/eslint/issues/11427)) (Teddy Katz)




## Bug Fixes


* [`6489518`](https://github.com/eslint/eslint/commit/64895185bde5233223648bcaf46f8deb72c9fb55) Fix: [no-extra-parens](/docs/rules/no-extra-parens) crash when code is "((let))" ([#11444](https://github.com/eslint/eslint/issues/11444)) (Teddy Katz)




## Documentation


* [`8f3d717`](https://github.com/eslint/eslint/commit/8f3d71754932669332ad7623bcc4c1aef3897125) Docs: Add non-attending TSC member info ([#11411](https://github.com/eslint/eslint/issues/11411)) (Nicholas C. Zakas)
* [`ce0777d`](https://github.com/eslint/eslint/commit/ce0777da5bc167fe0c529158fd8216d3eaf11565) Docs: use more common spelling ([#11417](https://github.com/eslint/eslint/issues/11417)) (薛定谔的猫)




## Dependency Upgrades


* [`a44f750`](https://github.com/eslint/eslint/commit/a44f75073306e5ea4e6722654009a99884fbca4f) Upgrade: eslint-scope@4.0.2 ([#11461](https://github.com/eslint/eslint/issues/11461)) (Teddy Katz)




## Build Related


* [`4088c6c`](https://github.com/eslint/eslint/commit/4088c6c9d4578cd581ce8ff4385d90b58a75b755) Build: Remove path.resolve in webpack build ([#11462](https://github.com/eslint/eslint/issues/11462)) (Kevin Partington)
* [`eb0650b`](https://github.com/eslint/eslint/commit/eb0650ba20cf9f9ad78dbaccfeb7e0e7ab56e31d) Build: fix linting errors on master ([#11428](https://github.com/eslint/eslint/issues/11428)) (Teddy Katz)
* [`db0c5e2`](https://github.com/eslint/eslint/commit/db0c5e2a7f894b7cda71007b0ba43d7814b3fb2e) Build: switch from browserify to webpack (fixes [#11366](https://github.com/eslint/eslint/issues/11366)) ([#11398](https://github.com/eslint/eslint/issues/11398)) (Pig Fang)




## Chores


* [`ee88475`](https://github.com/eslint/eslint/commit/ee884754e4111e11994ff0df3f0c29e43e1dc3f2) Chore: add utils for rule tests ([#11453](https://github.com/eslint/eslint/issues/11453)) (薛定谔的猫)
* [`5018378`](https://github.com/eslint/eslint/commit/5018378131fd5190bbccca902c0cf4276ee1581a) Chore: enable [require-unicode-regexp](/docs/rules/require-unicode-regexp) on ESLint codebase ([#11422](https://github.com/eslint/eslint/issues/11422)) (Teddy Katz)
* [`f6ba633`](https://github.com/eslint/eslint/commit/f6ba633f56eca6be20fc4b0d9496a78b9498d578) Chore: lint all files in the repo at the same time ([#11425](https://github.com/eslint/eslint/issues/11425)) (Teddy Katz)
* [`b9aabe3`](https://github.com/eslint/eslint/commit/b9aabe34311f6189b87c9d8a1aa40f3513fed773) Chore: run fuzzer along with unit tests ([#11404](https://github.com/eslint/eslint/issues/11404)) (Teddy Katz)
