---
layout: post
title: ESLint v5.14.0 released
teaser: "We just pushed ESLint v5.14.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-patch.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

* For clarity configuration of global variables has been enhanced with two additional values `readonly` and `writable`. All previous values are still valid.
* The [prefer-destructuring](/docs/rules/prefer-destructuring) rule is now auto-fixable.
* Auto-fix was removed from [prefer-spread](/docs/rules/prefer-spread) to avoid creating invalid code.
* `--init` CLI command has been updated to streamline available options.


## Features


* [`a23d197`](https://github.com/eslint/eslint/commit/a23d1975d48841eafdead1a1357e2af842f688bc) New: add allowSingleLineBlocks opt. to [padded-blocks](/docs/rules/padded-blocks) rule (fixes [#7145](https://github.com/eslint/eslint/issues/7145)) ([#11243](https://github.com/eslint/eslint/issues/11243)) (richie3366)




## Enhancements


* [`51c4972`](https://github.com/eslint/eslint/commit/51c497298a15ad296a2b1f8fc397df687976b836) Update: Behavior of --init (fixes [#11105](https://github.com/eslint/eslint/issues/11105)) ([#11332](https://github.com/eslint/eslint/issues/11332)) (Nicholas C. Zakas)
* [`550de1e`](https://github.com/eslint/eslint/commit/550de1e611a1e9af873bcb18d74cf2056e8d2e1b) Update: use `default` keyword in JSON schema (fixes [#9929](https://github.com/eslint/eslint/issues/9929)) ([#11288](https://github.com/eslint/eslint/issues/11288)) (Pig Fang)
* [`983c520`](https://github.com/eslint/eslint/commit/983c5201210d7a4ffab0b3d05ab9919c0754e5ca) Update: Use 'readonly' and 'writable' for globals (fixes [#11359](https://github.com/eslint/eslint/issues/11359)) ([#11384](https://github.com/eslint/eslint/issues/11384)) (Nicholas C. Zakas)
* [`3c90dd7`](https://github.com/eslint/eslint/commit/3c90dd7e25cf97833deddb11cfbc107a5663ac08) Update: remove [prefer-spread](/docs/rules/prefer-spread) autofix (fixes [#11330](https://github.com/eslint/eslint/issues/11330)) ([#11365](https://github.com/eslint/eslint/issues/11365)) (薛定谔的猫)
* [`5eb3121`](https://github.com/eslint/eslint/commit/5eb3121b82c1837da0c3021b7d9384bb30832e36) Update: add fixer for [`prefer-destructuring`](/docs/rules/prefer-destructuring) (fixes [#11151](https://github.com/eslint/eslint/issues/11151)) ([#11301](https://github.com/eslint/eslint/issues/11301)) (golopot)
* [`533d240`](https://github.com/eslint/eslint/commit/533d240b0811f663494cb213b06cc9e51e1ff2d0) Update: [no-shadow-restricted-names](/docs/rules/no-shadow-restricted-names) lets unassigned vars shadow undefined ([#11341](https://github.com/eslint/eslint/issues/11341)) (Teddy Katz)
* [`d0e823a`](https://github.com/eslint/eslint/commit/d0e823aef196a6564c87a78b72c1ef980ce67af9) Update: Make --init run js config files through linter (fixes [#9947](https://github.com/eslint/eslint/issues/9947)) ([#11337](https://github.com/eslint/eslint/issues/11337)) (Brian Kurek)




## Bug Fixes


* [`85a04b3`](https://github.com/eslint/eslint/commit/85a04b319e6dfde1458174cd1d8c9e7d33da0871) Fix: adds conditional for separateRequires in [one-var](/docs/rules/one-var) (fixes [#10179](https://github.com/eslint/eslint/issues/10179)) ([#10980](https://github.com/eslint/eslint/issues/10980)) (Scott Stern)
* [`ab8ac6a`](https://github.com/eslint/eslint/commit/ab8ac6adaaf7a88e160899e7f438a4cfd655eb6e) Fix: Support boundary spread elements in [sort-keys](/docs/rules/sort-keys) ([#11158](https://github.com/eslint/eslint/issues/11158)) (Jakub Rożek)
* [`e25e7aa`](https://github.com/eslint/eslint/commit/e25e7aa3ea1e8c9b3cd3242acda6d4a5572c2c6a) Fix: [comma-spacing](/docs/rules/comma-spacing) ignore comma before closing paren (fixes [#11295](https://github.com/eslint/eslint/issues/11295)) ([#11374](https://github.com/eslint/eslint/issues/11374)) (Pig Fang)
* [`84ce72f`](https://github.com/eslint/eslint/commit/84ce72fdeba082b7b132e4ac6b714fb1a93831b7) Fix: Remove extraneous linefeeds in [`one-var`](/docs/rules/one-var) fixer (fixes [#10741](https://github.com/eslint/eslint/issues/10741)) ([#10955](https://github.com/eslint/eslint/issues/10955)) (st-sloth)
* [`92fc2f4`](https://github.com/eslint/eslint/commit/92fc2f4f3faf8aeaae8a8e71db0de405404fb6c3) Fix: CircularJSON dependency warning (fixes [#11052](https://github.com/eslint/eslint/issues/11052)) ([#11314](https://github.com/eslint/eslint/issues/11314)) (Terry)




## Documentation


* [`104ae88`](https://github.com/eslint/eslint/commit/104ae881d0b21e9c64e006b2a2c21535cef0ad28) Docs: Update governance doc with reviewers status ([#11399](https://github.com/eslint/eslint/issues/11399)) (Nicholas C. Zakas)
* [`a1f7c44`](https://github.com/eslint/eslint/commit/a1f7c44ea9efbd9393889c1cc91b74260e0a8e02) Docs: fix [space-before-blocks](/docs/rules/space-before-blocks) correct code for "classes": "never" ([#11391](https://github.com/eslint/eslint/issues/11391)) (PoziWorld)
* [`14f58a2`](https://github.com/eslint/eslint/commit/14f58a2bec4d6aade0de22771c378b86b1e51959) Docs: fix grammar in [object-curly-spacing](/docs/rules/object-curly-spacing) docs ([#11389](https://github.com/eslint/eslint/issues/11389)) (PoziWorld)
* [`d3e9a27`](https://github.com/eslint/eslint/commit/d3e9a27bbba30008a610df59e82b7192f0ecc3a3) Docs: fix grammar in “those who says” ([#11390](https://github.com/eslint/eslint/issues/11390)) (PoziWorld)
* [`ea8e804`](https://github.com/eslint/eslint/commit/ea8e8045ba0e6c1e1015104346af962f3e16fd81) Docs: Add note about support for object spread (fixes [#11136](https://github.com/eslint/eslint/issues/11136)) ([#11395](https://github.com/eslint/eslint/issues/11395)) (Steven Thomas)
* [`95aa3fd`](https://github.com/eslint/eslint/commit/95aa3fdb392d265e6c3d813d54076458e88e7ad8) Docs: Update README team and sponsors (ESLint Jenkins)
* [`ad7a380`](https://github.com/eslint/eslint/commit/ad7a38097c32a91e5a831ef1bc8933601532576c) Docs: Update README team and sponsors (ESLint Jenkins)
* [`3e0c417`](https://github.com/eslint/eslint/commit/3e0c4176eff085498b813f8ba1732d7ed6ee44f8) Docs: Fix grammar in “there’s nothing prevent you” ([#11385](https://github.com/eslint/eslint/issues/11385)) (PoziWorld)
* [`de988bc`](https://github.com/eslint/eslint/commit/de988bc909b491366ad0cd9bc83f4d6de42d041a) Docs: Fix grammar: Spacing improve -> Spacing improves ([#11386](https://github.com/eslint/eslint/issues/11386)) (PoziWorld)
* [`1e56897`](https://github.com/eslint/eslint/commit/1e56897db3e254e0aef6d2fe3274157fc379c79e) Docs: “the function actually use”: use -> uses ([#11380](https://github.com/eslint/eslint/issues/11380)) (PoziWorld)
* [`5a71bc9`](https://github.com/eslint/eslint/commit/5a71bc95a7e961b1b1b77022645e0bd9cdd08dc0) Docs: Update README team and sponsors (ESLint Jenkins)
* [`82a58ce`](https://github.com/eslint/eslint/commit/82a58ce26b282fd80335b3ac4fc88f21266c3ba1) Docs: Update README team and sponsors (ESLint Jenkins)
* [`546d355`](https://github.com/eslint/eslint/commit/546d355ace65631e27de859baea3ffcc50e0ad2c) Docs: Update README with latest sponsors/team data ([#11378](https://github.com/eslint/eslint/issues/11378)) (Nicholas C. Zakas)
* [`c0df9fe`](https://github.com/eslint/eslint/commit/c0df9febb7c7e045ababc10b88dbcbb3f28c724c) Docs: `...` is not an operator ([#11232](https://github.com/eslint/eslint/issues/11232)) (Felix Kling)
* [`7ecfdef`](https://github.com/eslint/eslint/commit/7ecfdefaeadb772f8b96ffe37c4a2c97fde0da16) Docs: update typescript parser (refs [#11368](https://github.com/eslint/eslint/issues/11368)) ([#11369](https://github.com/eslint/eslint/issues/11369)) (薛定谔的猫)
* [`173eb38`](https://github.com/eslint/eslint/commit/173eb38cdb3e4673cba947521f27158828186d77) Docs: Clarify ecmaVersion doesn't imply globals (refs [#9812](https://github.com/eslint/eslint/issues/9812)) ([#11364](https://github.com/eslint/eslint/issues/11364)) (Keith Maxwell)
* [`389362a`](https://github.com/eslint/eslint/commit/389362a06ac6601512b872d3e843c7371f2a1bcc) Docs: clarify motivation for [no-prototype-builtins](/docs/rules/no-prototype-builtins) ([#11356](https://github.com/eslint/eslint/issues/11356)) (Teddy Katz)
* [`4dd19a3`](https://github.com/eslint/eslint/commit/4dd19a3c4c037adc860a65e96f2ba3eeccace1de) Docs: mention '[prefer-spread](/docs/rules/prefer-spread)' in docs of '[no-useless-call](/docs/rules/no-useless-call)' ([#11348](https://github.com/eslint/eslint/issues/11348)) (Klaus Meinhardt)
* [`4fd83d5`](https://github.com/eslint/eslint/commit/4fd83d5ec47a6a7b81cd8801c3bd63d27ea1c7c4) Docs: fix a misleading example in [one-var](/docs/rules/one-var) ([#11350](https://github.com/eslint/eslint/issues/11350)) (薛定谔的猫)




## Dependency Upgrades


* [`0c02932`](https://github.com/eslint/eslint/commit/0c02932f1b2e2a85809e84617efa1b8836c19cfb) Upgrade: espree@5.0.1 ([#11401](https://github.com/eslint/eslint/issues/11401)) (Ilya Volodin)
* [`f1d3a7e`](https://github.com/eslint/eslint/commit/f1d3a7ee7c82365989e219b1dae379f08f6dd526) Upgrade: some deps (fixes [#11372](https://github.com/eslint/eslint/issues/11372)) ([#11373](https://github.com/eslint/eslint/issues/11373)) (薛定谔的猫)






## Chores


* [`9441ce7`](https://github.com/eslint/eslint/commit/9441ce77b7228f2c4562e158a10905afe11f31f2) Chore: update incorrect tests to fix build failing ([#11354](https://github.com/eslint/eslint/issues/11354)) (薛定谔的猫)
