---
layout: post
title: Funding ESLint's Future
teaser: "With ESLint being an important part of the JS ecosystem, we are happy to announce the launch of the ESLint Collective. We share what this means and our goals and plans, and we introduce our first sponsors. Thanks to the ESLint community, we can make ESLint's development more sustainable."
tags:
  - Open Source
  - Funding
  - Open Collective
  - Sponsors
  - Backers
authors:
  - nzakas
categories:
  - Sponsorships
---

June 2019 will mark six years since ESLint was first released. What began as a side project for a very narrow use case has grown into the most popular JavaScript linter in the world, with over 6.5 million npm downloads *every week*. ESLint is now used by both large companies and individual developers to help find and fix problems with JavaScript code every day. In addition, ESLint has been flexible enough to work with languages derived from JavaScript, such as [Flow](https://www.npmjs.com/package/eslint-plugin-flowtype) and [TypeScript](https://typescript-eslint.io), and even helps mobile developers by linting [React Native](https://www.npmjs.com/package/eslint-plugin-react-native).

All of this means that ESLint has become an important part of the JavaScript ecosystem. It's a tool that the JavaScript community depends on and expects to be available, performant, and secure. These expectations are currently being met by an all-volunteer team who spends their free time during lunch breaks, nights, and weekends maintaining ESLint. And while that has worked well for normal maintenance, it's grown difficult to deal with more involved issues such as roadmap planning and security issues.

In short, we've realized that in order for ESLint to continue to grow and evolve, we need to get more organized and set up a way to fund ESLint's development going forward.

## The ESLint Collective

<p class="text-center"><a href="https://opencollective.com/eslint"><img src="/assets/img/posts/eslint-collective.png" alt="ESLint Collective Logo" style="max-width: 100%"></a><br><a href="https://opencollective.com/eslint" class="btn btn-default">Become a Sponsor</a></p>

Today, we are happy to announce the [ESLint Collective](https://opencollective.com/eslint) on Open Collective. Open Collective is a secure way for people to sustain and support open source projects. The funds taken in and paid out are publicly available on each collective's page, so there is 100% transparency around the money a collective uses. Open Collective has already helped other JavaScript ecosystem projects such as [Webpack](https://opencollective.com/webpack) and [Babel](https://opencollective.com/babel) to fund their ongoing development, and the ESLint team is happy to join them on what has proven to be a great option for open source sustainability.

Some of the benefits of working with Open Collective include:

* **Full Transparency.** Everyone gets to see where money is coming from and where it's going.
* **Individual and Corporate Sponsors.** Open Collective makes it easy for both individuals and companies to sponsor open source projects.
* **Potential Tax Benefits.** Because funds are paid to the Open Source Collective, a 501(c)(6) organization in the U.S., there may be tax benefits for some donors (please check with your accountant).
* **Automatic Invoicing.** For corporate sponsors, Open Collective automatically generates and sends invoices for tracking purposes.
* **Open Participation.** Anyone can request reimbursement for funds spent helping the ESLint project and ESLint can pay out to anyone.

## How will the money be spent?

The ESLint team has a lot of ideas about how to proceed going forward. Depending on the amount we raise, here are some of the things we're planning:

* **Paying team members for maintenance and development.** All ESLint team members are still contributing in their spare time. Having the option to work part-time or full-time on ESLint, and be compensated for it, would allow for faster and more consistent development.
* **Rewarding contributions from the community.** We'd like to reward everyone who contributes to ESLint, whether it's a one-time contribution or ongoing contributions. We are still figuring out the details, but rewarding people with everything from stickers and t-shirts to cash payouts for significant contributions are things we are thinking about right now.
* **Improve documentation.** ESLint's documentation hasn't had a significant overhaul since the project was first released. We feel there are a lot of ways to improve the documentation, including potentially contracting an information architect or technical writer to improve our documentation.
* **Better communication and support.** By paying team members part-time or full-time, that also opens up the possibility of sending team members to meetups, companies, and conferences to interact with the community and better understand the problems developers are facing.
* **Developing a Roadmap.** For a while, the ESLint team has mostly worked on a one-off basis in terms of which features to implement. Without knowing who would be able to spend what amount of time on the project, it was difficult to do long-term planning and develop a roadmap for the future. This is something we will finally be able to do when we are a self-sustaining project.

## Our Goal: $20,000 per month

In order to achieve everything we have in mind, we believe that we will need $20,000 per month. With this amount, we can sustain ESLint for the foreseeable future.

## Introducing our first sponsors

<p class="text-center">
    <a href="https://facebook.com"><img src="/assets/img/logos/facebook.png" alt="Facebook" height="96"></a>
    <a href="https://airbnb.com"><img src="/assets/img/logos/airbnb.png" alt="Airbnb" height="96"></a>
</p>

We're also excited to announce our first sponsors. [Facebook](https://facebook.com) and [Airbnb](https://airbnb.com) have both pledged $1,000 per month to support ESLint.

<p class="text-center">
    <a href="https://frontendmasters.com"><img src="https://static.frontendmasters.com/assets/fm/js/frontendmasters.0e71088726.svg" alt="Frontend Masters" height="32"></a>
</p>

Additionally, [Frontend Masters](https://frontendmasters.com) has donated $200 to support ESLint.

If your company also uses ESLint to find and fix problems in your JavaScript code, please ask them to join these fantastic companies in [sponsoring ESLint](https://opencollective.com/eslint). (All sponsors above $200 per month get their logos on both the ESLint README and on the homepage of eslint.org.)

We'd like to thank Eric Nakagawa at Facebook, Jordan Harband at Airbnb, Marc Grabanski at Frontend Masters, and Pia Mancini at Open Collective for supporting our early sponsorship efforts at their respective companies.

## The best is yet to come for ESLint

We are grateful to the ESLint community for your continued support and feedback, and we're looking forward to continuing to interact and grow with you. We truly believe that the best is yet to come for ESLint, and with financial support from the companies that use ESLint, we will be able to achieve our vision.
