---
layout: post
title: ESLint v5.11.0 released
teaser: "We just pushed ESLint v5.11.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* One new rule has been added: [`no-useless-catch`](/docs/rules/no-useless-catch)
* The [`indent`](/docs/rules/indent) rule now supports a `VariableDeclarator: "first"` option.

## Features


* [`b4395f6`](https://github.com/eslint/eslint/commit/b4395f671442a7e0be956382c24cce38025a6df6) New: add option `first` for VariableDeclarator in [indent](/docs/rules/indent) (fixes [#8976](https://github.com/eslint/eslint/issues/8976)) ([#11193](https://github.com/eslint/eslint/issues/11193)) (Pig Fang)
* [`2b5a602`](https://github.com/eslint/eslint/commit/2b5a60284670a3ab1281b206941ed38faf2ea10c) New: [no-useless-catch](/docs/rules/no-useless-catch) rule (fixes [#11174](https://github.com/eslint/eslint/issues/11174)) ([#11198](https://github.com/eslint/eslint/issues/11198)) (Alexander Grasley)




## Enhancements


* [`4242314`](https://github.com/eslint/eslint/commit/4242314215a6f35e432860433906f47af1a29724) Update: handle computed properties in [camelcase](/docs/rules/camelcase) (fixes [#11084](https://github.com/eslint/eslint/issues/11084)) ([#11113](https://github.com/eslint/eslint/issues/11113)) (Bence Dányi)




## Bug Fixes


* [`06b3b5b`](https://github.com/eslint/eslint/commit/06b3b5bfcf0429c5078d4f4af3c03bb777e4f022) Fix: Account for comments in [implicit-arrow-linebreak](/docs/rules/implicit-arrow-linebreak) ([#10545](https://github.com/eslint/eslint/issues/10545)) (Mark de Dios)




## Documentation


* [`1009304`](https://github.com/eslint/eslint/commit/100930493d9ab802a94dac5c761515b12241ddd2) Docs: add a note for [no-unused-expressions](/docs/rules/no-unused-expressions) (fixes [#11169](https://github.com/eslint/eslint/issues/11169)) ([#11192](https://github.com/eslint/eslint/issues/11192)) (Pig Fang)
* [`88f99d3`](https://github.com/eslint/eslint/commit/88f99d31b88a4cde4563bc4a6f4c41f0cc557885) Docs: clarify how to use configs in plugins ([#11199](https://github.com/eslint/eslint/issues/11199)) (Kai Cataldo)
* [`bcf558b`](https://github.com/eslint/eslint/commit/bcf558b2f7036f487af2bdb2b2d34b6cdf7fc174) Docs: Clarify the [no-unused-vars](/docs/rules/no-unused-vars) docs ([#11195](https://github.com/eslint/eslint/issues/11195)) (Jed Fox)
* [`a470eb7`](https://github.com/eslint/eslint/commit/a470eb73d52fae0f0bc48de5a487e23cf78fcfa9) Docs: Fix [no-irregular-whitespace](/docs/rules/no-irregular-whitespace) description ([#11196](https://github.com/eslint/eslint/issues/11196)) (Jed Fox)
* [`8abc8af`](https://github.com/eslint/eslint/commit/8abc8afe71691b747cbd1819a13d896e8aa5b92a) Docs: Remove a misleading example ([#11204](https://github.com/eslint/eslint/issues/11204)) (Bogdan Gradinariu)
* [`733d936`](https://github.com/eslint/eslint/commit/733d93618a99758a05453ab94505a9f1330950e0) Docs: link to JSDoc EOL blogpost in [valid-jsdoc](/docs/rules/valid-jsdoc) and [require-jsdoc](/docs/rules/require-jsdoc) ([#11191](https://github.com/eslint/eslint/issues/11191)) (Nathan Diddle)
* [`d5eb108`](https://github.com/eslint/eslint/commit/d5eb108e17f676d0e4fcddeb1211b4bdfac760c1) Docs: Ensure `triage` label is added to new issues ([#11182](https://github.com/eslint/eslint/issues/11182)) (Teddy Katz)
* [`617a287`](https://github.com/eslint/eslint/commit/617a2874ed085bca36ca289aac55e3b7f7ce937e) Docs: add missing deprecation notices for jsdoc rules ([#11171](https://github.com/eslint/eslint/issues/11171)) (Teddy Katz)
