---
layout: post
title: ESLint v5.10.0 released
teaser: "We just pushed ESLint v5.10.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - platinumazure
categories:
  - Release Notes
---

## Highlights

* The [`padding-line-between-statements`](/docs/rules/padding-line-between-statements) rule has new statement types: multiline-const, multiline-let, multiline-var, singleline-const, singleline-let, and singleline-var.
* The [`require-jsdoc`](/docs/rules/require-jsdoc) and [`valid-jsdoc`](/docs/rules/valid-jsdoc) rules have been deprecated, following our previously announced decision to [end support for JSDoc in ESLint](https://eslint.org/blog/2018/11/jsdoc-end-of-life).

## Enhancements

* [`4b0f517`](https://github.com/eslint/eslint/commit/4b0f517cd317e5f1b99a1e8a0392332bd8a2e231) Update: single- and multiline const, let, var statements (fixes [#10721](https://github.com/eslint/eslint/issues/10721)) ([#10919](https://github.com/eslint/eslint/issues/10919)) (Tom Panier)
* [`9666aba`](https://github.com/eslint/eslint/commit/9666abaf46c841fba7b5d4e53c6998cd25b9bc33) Update: [space-infix-ops](/docs/rules/space-infix-ops) reports violating operator ([#10934](https://github.com/eslint/eslint/issues/10934)) (Bence Dányi)
* [`4490d7a`](https://github.com/eslint/eslint/commit/4490d7af529d4ecc18b6874f1d838869656da58a) Update: deprecate [valid-jsdoc](/docs/rules/valid-jsdoc) and [require-jsdoc](/docs/rules/require-jsdoc) ([#11145](https://github.com/eslint/eslint/issues/11145)) (Teddy Katz)
* [`62fd2b9`](https://github.com/eslint/eslint/commit/62fd2b93448966331db3eb2dfbe4e1273eb032b2) Update: Amend [keyword-spacing](/docs/rules/keyword-spacing) to validate `default` keywords ([#11097](https://github.com/eslint/eslint/issues/11097)) (Bin Ury)
* [`3025cdd`](https://github.com/eslint/eslint/commit/3025cddf0a2ea8461ce05575098a5714fcf6278d) Update: don't [indent](/docs/rules/indent) leading [semi](/docs/rules/semi) in line after import (fixes [#11082](https://github.com/eslint/eslint/issues/11082)) ([#11085](https://github.com/eslint/eslint/issues/11085)) (Pig Fang)

## Bug Fixes

* [`c14f717`](https://github.com/eslint/eslint/commit/c14f717f4c32860766185da47f64f8eb0c2d2998) Fix: Update all-files-ignored.txt message to be less confusing ([#11075](https://github.com/eslint/eslint/issues/11075)) (z.ky)
* [`3bf0332`](https://github.com/eslint/eslint/commit/3bf0332508b921cb660c2e8a1ab7ddf46a2013b6) Fix: fix the fixer of lone comma with comments (fixes [#10632](https://github.com/eslint/eslint/issues/10632)) ([#11154](https://github.com/eslint/eslint/issues/11154)) (Pig Fang)
* [`c0a80d0`](https://github.com/eslint/eslint/commit/c0a80d0ca3c80ca27694fc8aedcf84b72bfd9465) Fix: Do not strip underscores in [camelcase](/docs/rules/camelcase) allow (fixes [#11000](https://github.com/eslint/eslint/issues/11000)) ([#11001](https://github.com/eslint/eslint/issues/11001)) (Luke Page)
* [`54dfa60`](https://github.com/eslint/eslint/commit/54dfa602f62e6d183d57d60d5fdd417a263f479e) Fix: Typo in function comment parameters ([#11111](https://github.com/eslint/eslint/issues/11111)) (Pierre Maoui)

## Documentation

* [`9f3573d`](https://github.com/eslint/eslint/commit/9f3573dda3dc35bc220e945686cc835eaad0ac2c) Docs: Clarify the CLIEngine options ([#10995](https://github.com/eslint/eslint/issues/10995)) (Ed Morley)
* [`60dfb6c`](https://github.com/eslint/eslint/commit/60dfb6c623dfe829e5350dabe507e7850c1beacf) Docs: Update issue templates ([#11163](https://github.com/eslint/eslint/issues/11163)) (Teddy Katz)
* [`958987a`](https://github.com/eslint/eslint/commit/958987aa6f5630faa051d8f822f0200faff41924) Docs: Fix link to rule [no-useless-rename](/docs/rules/no-useless-rename) ([#11165](https://github.com/eslint/eslint/issues/11165)) (Brian)
* [`c6471ed`](https://github.com/eslint/eslint/commit/c6471ed6feb3e71e239379a7042deb9b8ab3cf39) Docs: fix typo in issue-templates/new-rule ([#11149](https://github.com/eslint/eslint/issues/11149)) (薛定谔的猫)
* [`a675c89`](https://github.com/eslint/eslint/commit/a675c89573836adaf108a932696b061946abf1e6) Docs: (Grammar) "the setup" -> "to set up" ([#11117](https://github.com/eslint/eslint/issues/11117)) (MarvinJWendt)
* [`cf296bd`](https://github.com/eslint/eslint/commit/cf296bdabf0dbbfbae491419e38aee4ecd63ec71) Docs: switch incorrect example with correct one ([#11107](https://github.com/eslint/eslint/issues/11107)) (Romain Le Quellec)
* [`d2d500c`](https://github.com/eslint/eslint/commit/d2d500ca5dff307189b9d4161a5e7b8282557dd6) Docs: [no-console](/docs/rules/no-console)#When-Not-To-Use provides incorrect rule snippet ([#11093](https://github.com/eslint/eslint/issues/11093)) (Lawrence Chou)

## Dependency Upgrades

* [`f850726`](https://github.com/eslint/eslint/commit/f8507260c2091d18488fde20e466639d1a7f913c) Upgrade: Espree v5.0.0 ([#11161](https://github.com/eslint/eslint/issues/11161)) (Kai Cataldo)
* [`5da378a`](https://github.com/eslint/eslint/commit/5da378ac922d732ca1765f08edee0face1b1b924) Upgrade: eslint-release@1.2.0 ([#11073](https://github.com/eslint/eslint/issues/11073)) (Teddy Katz)

## Build Related

* [`709190f`](https://github.com/eslint/eslint/commit/709190f8c5d7559b1e0915e25af60b50a94ba1c7) Build: fix test failure on Node 11 ([#11100](https://github.com/eslint/eslint/issues/11100)) (Teddy Katz)

## Chores


* [`dd7b0cb`](https://github.com/eslint/eslint/commit/dd7b0cb019d94964930d30fec36f7b22ef072822) Chore: refactor template literal feature detection in '[quotes](/docs/rules/quotes)' rule ([#11125](https://github.com/eslint/eslint/issues/11125)) (Bryan)
* [`4bcdfd0`](https://github.com/eslint/eslint/commit/4bcdfd07d514fd7a6b8672d33703d0b6c606f214) Chore: fix some jsdoc-related issues ([#11148](https://github.com/eslint/eslint/issues/11148)) (薛定谔的猫)
* [`5d451c5`](https://github.com/eslint/eslint/commit/5d451c510c15abc41b5bb14b4955a7db96aeb100) Chore: Remove dependency on is-resolvable ([#11128](https://github.com/eslint/eslint/issues/11128)) (Matt Grande)
* [`bc50dc7`](https://github.com/eslint/eslint/commit/bc50dc7737496712463220e662946eb516e36ae1) Chore: Move ignored-paths, report-translator to lib/util (refs [#10559](https://github.com/eslint/eslint/issues/10559)) ([#11116](https://github.com/eslint/eslint/issues/11116)) (Kevin Partington)
* [`f394a1d`](https://github.com/eslint/eslint/commit/f394a1dfc5eb4874f899b7bc19685896893af7b8) Chore: Extract config comment parsing ([#11091](https://github.com/eslint/eslint/issues/11091)) (Nicholas C. Zakas)
* [`e18c827`](https://github.com/eslint/eslint/commit/e18c827cc12cb1c52e5d0aa993f572cb56238704) Chore: refactor linter#parseBooleanConfig to improve readability ([#11074](https://github.com/eslint/eslint/issues/11074)) (薛定谔的猫)
