---
layout: post
title: ESLint v5.9.0 released
teaser: "We just pushed ESLint v5.9.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

The following are the most important changes in this release.

### The --fix-type option

This version introduces a new `--fix-type` option for the [command line interface](https://eslint.org/docs/user-guide/command-line-interface#--fix-type). This option allows you to filter the type of fixes applied when using `--fix`. You can specify the type of fixes to apply based on the new [rule types](https://eslint.org/docs/developer-guide/working-with-rules#rule-basics) we've assigned to each rule. The three rule types are:

1. `problem` - the rule flags a potential problem with your code.
2. `suggestion` - the rule flags something that could be done in a better or preferred way.
3. `layout` - the rule flags changes limited to whitespace, semicolons, commas, or parentheses.

You might find this option useful if you're using a source code formatter with ESLint, in which case you might want to use `--fix-type problem,suggestion` to only apply fixes for rules that won't clash with your formatter.

There is also a new `fixTypes` option that can be passed to the [`CLIEngine`](https://eslint.org/docs/developer-guide/nodejs-api#cliengine) class that implements the same feature for those using the API.

**Note:** Fixes in custom rules will not be applied when using `--fix-type` unless they include a `meta.type` field. If you are maintaining a plugin with custom rules, please update your rules.

## Features


* [7ad86de](https://github.com/eslint/eslint/commit/7ad86de) New: Add --fix-type option to CLI (fixes [#10855](https://github.com/eslint/eslint/issues/10855)) ([#10912](https://github.com/eslint/eslint/issues/10912)) (Nicholas C. Zakas)




## Enhancements


* [c832cd5](https://github.com/eslint/eslint/commit/c832cd5) Update: add `ignoreDestructuring` option to [`id-match`](/docs/rules/id-match) rule ([#10554](https://github.com/eslint/eslint/issues/10554)) (一名宅。)
* [ae2b61d](https://github.com/eslint/eslint/commit/ae2b61d) Update: "off" options for "[space-before-blocks](/docs/rules/space-before-blocks)" (refs [#10906](https://github.com/eslint/eslint/issues/10906)) ([#10907](https://github.com/eslint/eslint/issues/10907)) (Sophie Kirschner)
* [79a2797](https://github.com/eslint/eslint/commit/79a27976) Update: [no-restricted-imports](/docs/rules/no-restricted-imports) to check re-export (fixes [#9678](https://github.com/eslint/eslint/issues/9678)) ([#11064](https://github.com/eslint/eslint/issues/11064)) (Nicholas C. Zakas)
* [802e926](https://github.com/eslint/eslint/commit/802e926) Update: Warn for deprecation in Node output (fixes [#7443](https://github.com/eslint/eslint/issues/7443)) ([#10953](https://github.com/eslint/eslint/issues/10953)) (Colin Chang)




## Bug Fixes


* [9436712](https://github.com/eslint/eslint/commit/9436712) Fix: Unused recursive function expressions (fixes [#10982](https://github.com/eslint/eslint/issues/10982)) ([#11032](https://github.com/eslint/eslint/issues/11032)) (Sergei Startsev)
* [54687a8](https://github.com/eslint/eslint/commit/54687a8) Fix: [prefer-const](/docs/rules/prefer-const) autofix multiline assignment (fixes [#10582](https://github.com/eslint/eslint/issues/10582)) ([#10987](https://github.com/eslint/eslint/issues/10987)) (Scott Stern)
* [dcc6233](https://github.com/eslint/eslint/commit/dcc6233) Fix: Ignore empty statements in [no-unreachable](/docs/rules/no-unreachable) (fixes [#9081](https://github.com/eslint/eslint/issues/9081)) ([#11058](https://github.com/eslint/eslint/issues/11058)) (Nicholas C. Zakas)
* [5525eb6](https://github.com/eslint/eslint/commit/5525eb6) Fix: rule deprecation warnings did not consider all rules ([#11044](https://github.com/eslint/eslint/issues/11044)) (Teddy Katz)




## Documentation


* [57f357e](https://github.com/eslint/eslint/commit/57f357e) Docs: Update [require-await](/docs/rules/require-await) docs with exception (fixes [#9540](https://github.com/eslint/eslint/issues/9540)) ([#11063](https://github.com/eslint/eslint/issues/11063)) (Nicholas C. Zakas)
* [3dd7493](https://github.com/eslint/eslint/commit/3dd7493) Docs: update ecmaVersion to include 2019/10 values ([#11059](https://github.com/eslint/eslint/issues/11059)) (Vse Mozhet Byt)
* [4fe3287](https://github.com/eslint/eslint/commit/4fe3287) Docs: Cross-reference two rules (refs [#11041](https://github.com/eslint/eslint/issues/11041)) ([#11042](https://github.com/eslint/eslint/issues/11042)) (Paul Melnikow)
* [44d37ca](https://github.com/eslint/eslint/commit/44d37ca) Docs: Update steps for adding new TSC member ([#11038](https://github.com/eslint/eslint/issues/11038)) (Nicholas C. Zakas)




## Dependency Upgrades


* [607635d](https://github.com/eslint/eslint/commit/607635d) Upgrade: eslint-plugin-node & eslint-plugin ([#11067](https://github.com/eslint/eslint/issues/11067)) (薛定谔的猫)






## Chores


* [0800b20](https://github.com/eslint/eslint/commit/0800b20) Chore: fix invalid super() calls in tests ([#11054](https://github.com/eslint/eslint/issues/11054)) (Teddy Katz)
