---
layout: post
title: ESLint v5.8.0 released
teaser: "We just pushed ESLint v5.8.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* The `Linter` API now has a static `version` property, for consistency with the `CLIEngine.version` property. (Previously, the `version` property was only present on instances of `Linter` rather than `Linter` itself.)

## Enhancements


* [3943635](https://github.com/eslint/eslint/commit/3943635) Update: Create Linter.version API (fixes [#9271](https://github.com/eslint/eslint/issues/9271)) ([#11010](https://github.com/eslint/eslint/issues/11010)) (Nicholas C. Zakas)




## Bug Fixes


* [9152417](https://github.com/eslint/eslint/commit/9152417) Fix: deprecation warning in RuleTester using Node v11 ([#11009](https://github.com/eslint/eslint/issues/11009)) (Teddy Katz)
* [57ef0fd](https://github.com/eslint/eslint/commit/57ef0fd) Fix: [prefer-const](/docs/rules/prefer-const) when using destructuring assign (fixes [#8308](https://github.com/eslint/eslint/issues/8308)) ([#10924](https://github.com/eslint/eslint/issues/10924)) (Nicholas C. Zakas)




## Documentation


* [e349a03](https://github.com/eslint/eslint/commit/e349a03) Docs: Update issue templates to ask for PRs ([#11012](https://github.com/eslint/eslint/issues/11012)) (Nicholas C. Zakas)
* [a940cf4](https://github.com/eslint/eslint/commit/a940cf4) Docs: Mention version for config glob patterns (fixes [#8793](https://github.com/eslint/eslint/issues/8793)) (Nicholas C. Zakas)
* [58ff359](https://github.com/eslint/eslint/commit/58ff359) Docs: add instructions for npm 2FA (refs [#10631](https://github.com/eslint/eslint/issues/10631)) ([#10992](https://github.com/eslint/eslint/issues/10992)) (Teddy Katz)




## Dependency Upgrades


* [2f87bb3](https://github.com/eslint/eslint/commit/2f87bb3) Upgrade: eslint-release@1.0.0 (refs [#10631](https://github.com/eslint/eslint/issues/10631)) ([#10991](https://github.com/eslint/eslint/issues/10991)) (Teddy Katz)




## Build Related


* [5a31a92](https://github.com/eslint/eslint/commit/5a31a92) Build: compile espree's deps to ES5 when generating site (fixes [#11014](https://github.com/eslint/eslint/issues/11014)) ([#11015](https://github.com/eslint/eslint/issues/11015)) (Teddy Katz)
* [6e1c530](https://github.com/eslint/eslint/commit/6e1c530) Build: run tests on Node 11 ([#11008](https://github.com/eslint/eslint/issues/11008)) (Teddy Katz)




## Chores


* [3d88b38](https://github.com/eslint/eslint/commit/3d88b38) Chore: avoid using legacy report API in [no-irregular-whitespace](/docs/rules/no-irregular-whitespace) ([#11013](https://github.com/eslint/eslint/issues/11013)) (Teddy Katz)
* [577cbf1](https://github.com/eslint/eslint/commit/577cbf1) Chore: Add typescript-specific edge case tests to [space-infix-ops](/docs/rules/space-infix-ops) ([#10986](https://github.com/eslint/eslint/issues/10986)) (Bence Dányi)
* [d45b184](https://github.com/eslint/eslint/commit/d45b184) Chore: Using deconstruction assignment for shelljs ([#10974](https://github.com/eslint/eslint/issues/10974)) (ZYSzys)
