---
layout: post
title: ESLint v5.7.0 released
teaser: "We just pushed ESLint v5.7.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

Three rules gained new options in this release:

- [`padding-line-between-statements`](/docs/rules/padding-line-between-statements) has a new `iife` node type to specifically target immediately-invoked function expression invocations as distinct statements.
- [`no-tabs`](/docs/rules/no-tabs) has a new `allowIndentationTabs` option to permit tabs only for indentation and nowhere else.
- [`camelcase`](/docs/rules/camelcase) has a new `allow` option that can be configured to individually allow certain non-camelcase identifiers like React's `UNSAFE_componentWillMount`.




## Enhancements


* [6cb63fd](https://github.com/eslint/eslint/commit/6cb63fd) Update: Add iife to [padding-line-between-statements](/docs/rules/padding-line-between-statements) (fixes [#10853](https://github.com/eslint/eslint/issues/10853)) ([#10916](https://github.com/eslint/eslint/issues/10916)) (Kevin Partington)
* [5fd1bda](https://github.com/eslint/eslint/commit/5fd1bda) Update: [no-tabs](/docs/rules/no-tabs) allowIndentationTabs option (fixes [#10256](https://github.com/eslint/eslint/issues/10256)) ([#10925](https://github.com/eslint/eslint/issues/10925)) (Kevin Partington)
* [066f7e0](https://github.com/eslint/eslint/commit/066f7e0) Update: [camelcase](/docs/rules/camelcase) rule ignoreList added ([#10783](https://github.com/eslint/eslint/issues/10783)) (Julien Martin)




## Bug Fixes


* [d12be69](https://github.com/eslint/eslint/commit/d12be69) Fix: [no-extra-bind](/docs/rules/no-extra-bind) No autofix if arg may have side effect (fixes [#10846](https://github.com/eslint/eslint/issues/10846)) ([#10918](https://github.com/eslint/eslint/issues/10918)) (Kevin Partington)
* [847372f](https://github.com/eslint/eslint/commit/847372f) Fix: [no-unused-vars](/docs/rules/no-unused-vars) false pos. with markVariableAsUsed (fixes [#10952](https://github.com/eslint/eslint/issues/10952)) ([#10954](https://github.com/eslint/eslint/issues/10954)) (Roy Sutton)
* [543edfa](https://github.com/eslint/eslint/commit/543edfa) Fix: Fix error with [one-var](/docs/rules/one-var) (fixes [#10937](https://github.com/eslint/eslint/issues/10937)) ([#10938](https://github.com/eslint/eslint/issues/10938)) (Justin Krup)
* [5fe0e1a](https://github.com/eslint/eslint/commit/5fe0e1a) Fix: [no-invalid-regexp](/docs/rules/no-invalid-regexp) disallows \ at end of pattern (fixes [#10861](https://github.com/eslint/eslint/issues/10861)) ([#10920](https://github.com/eslint/eslint/issues/10920)) (Toru Nagashima)




## Documentation


* [95c4cb1](https://github.com/eslint/eslint/commit/95c4cb1) Docs: Fix typo for [no-unsafe-finally](/docs/rules/no-unsafe-finally) ([#10945](https://github.com/eslint/eslint/issues/10945)) (Sergio Santoro)
* [f85547a](https://github.com/eslint/eslint/commit/f85547a) Docs: Add 'When Not To Use' section to [space-infix-ops](/docs/rules/space-infix-ops) ([#10931](https://github.com/eslint/eslint/issues/10931)) (Bence Dányi)
* [3dccac4](https://github.com/eslint/eslint/commit/3dccac4) Docs: Update working-with-parsers link ([#10929](https://github.com/eslint/eslint/issues/10929)) (Azeem Bande-Ali)
* [557a8bb](https://github.com/eslint/eslint/commit/557a8bb) Docs: Remove old note about caching, add a new one (fixes [#10739](https://github.com/eslint/eslint/issues/10739)) ([#10913](https://github.com/eslint/eslint/issues/10913)) (Zac)




## Dependency Upgrades


* [70bde69](https://github.com/eslint/eslint/commit/70bde69) Upgrade: table to version 5 ([#10903](https://github.com/eslint/eslint/issues/10903)) (Rouven Weßling)






## Chores


* [4132de7](https://github.com/eslint/eslint/commit/4132de7) Chore: Simplify [space-infix-ops](/docs/rules/space-infix-ops) ([#10935](https://github.com/eslint/eslint/issues/10935)) (Bence Dányi)
* [fe8111a](https://github.com/eslint/eslint/commit/fe8111a) Chore: Add more test cases to [space-infix-ops](/docs/rules/space-infix-ops) ([#10936](https://github.com/eslint/eslint/issues/10936)) (Bence Dányi)
* [2e52bca](https://github.com/eslint/eslint/commit/2e52bca) Chore: Update issue templates ([#10900](https://github.com/eslint/eslint/issues/10900)) (Nicholas C. Zakas)
